/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.RsConstantConditionIfInspectionKt;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsIfExprKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/inspections/SimplifyFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsIfExpr;", "element", "conditionValue", "", "<init>", "(Lorg/rust/lang/core/psi/RsIfExpr;Z)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
public class SimplifyFix
extends RsQuickFixBase<RsIfExpr> {
    private final boolean conditionValue;

    public SimplifyFix(@NotNull RsIfExpr element, boolean conditionValue) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        this.conditionValue = conditionValue;
    }

    @Override
    @NotNull
    public String getText() {
        return this.conditionValue ? RsBundle.INSTANCE.message("intention.name.unwrap.if.expression", new Object[0]) : RsBundle.INSTANCE.message("intention.name.remove.if.expression", new Object[0]);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsIfExpr element) {
        block2: {
            Editor editor3;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsExpr elseExpr = RsIfExprKt.getElseExpr(element);
            if (elseExpr instanceof RsIfExpr && !this.conditionValue) {
                element.replace(elseExpr);
                return;
            }
            RsExpr rsExpr = this.conditionValue ? (RsExpr)RsIfExprKt.getThenExpr(element) : elseExpr;
            RsBlockExpr rsBlockExpr = rsExpr instanceof RsBlockExpr ? (RsBlockExpr)rsExpr : null;
            if (rsBlockExpr == null) {
                return;
            }
            RsBlockExpr branch = rsBlockExpr;
            PsiElement replaced = RsConstantConditionIfInspectionKt.access$replaceWithBlockContent(element, branch);
            if (replaced == null || (editor3 = editor2) == null || (editor3 = editor3.getCaretModel()) == null) break block2;
            editor3.moveToOffset(PsiElementKt.getStartOffset(replaced));
        }
    }
}

