/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.RsWrongLifetimeParametersNumberInspection;
import org.rust.ide.inspections.lints.RsNeedlessLifetimesInspectionKt;
import org.rust.lang.core.psi.RsFnPointerType;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPathType;
import org.rust.lang.core.psi.RsRefLikeType;
import org.rust.lang.core.psi.RsRetType;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsGenericDeclarationKt;
import org.rust.lang.core.psi.ext.RsMethodOrPathKt;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/RsWrongLifetimeParametersNumberInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsWrongLifetimeParametersNumberInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPathType(RsPathType type) {
                int actualLifetimes;
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                RsPath rsPath = type.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)rsPath, (String)"<get-path>(...)");
                RsPath path = rsPath;
                if (path.getValueParameterList() != null) {
                    return;
                }
                if (path.getCself() != null) {
                    return;
                }
                RsPathReference rsPathReference = path.getReference();
                RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
                RsGenericDeclaration rsGenericDeclaration = rsElement instanceof RsGenericDeclaration ? (RsGenericDeclaration)rsElement : null;
                if (rsGenericDeclaration == null) {
                    return;
                }
                RsGenericDeclaration paramsDecl = rsGenericDeclaration;
                int expectedLifetimes = RsGenericDeclarationKt.getLifetimeParameters(paramsDecl).size();
                if (expectedLifetimes == (actualLifetimes = RsMethodOrPathKt.getLifetimeArguments(path).size())) {
                    return;
                }
                if (actualLifetimes == 0 && !ExtensionsKt.getLifetimeElidable(type)) {
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MissingLifetimeSpecifier(type), this.$holder, false, null, 6, null);
                } else if (actualLifetimes > 0) {
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.WrongNumberOfLifetimeArguments(type, expectedLifetimes, actualLifetimes), this.$holder, false, null, 6, null);
                }
            }

            public void visitRefLikeType(RsRefLikeType type) {
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                if (type.getMul() == null && !ExtensionsKt.getLifetimeElidable(type) && type.getLifetime() == null) {
                    PsiElement psiElement2 = type.getAnd();
                    if (psiElement2 == null) {
                        psiElement2 = type;
                    }
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MissingLifetimeSpecifier(psiElement2), this.$holder, false, null, 6, null);
                }
            }

            public void visitFunction2(RsFunction fn) {
                Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
                if (!RsNeedlessLifetimesInspectionKt.hasMissingLifetimes(fn)) {
                    return;
                }
                RsRetType rsRetType = fn.getRetType();
                if (rsRetType == null) {
                    return;
                }
                RsRetType retType = rsRetType;
                Sequence descendants = PsiTreeUtilKt.descendants$default((PsiElement)retType, (boolean)false, buildVisitor.1::visitFunction2$lambda$0, (int)1, null);
                for (PsiElement type : descendants) {
                    PsiElement and;
                    if (!(type instanceof RsRefLikeType) || ((RsRefLikeType)type).getAnd() == null || ((RsRefLikeType)type).getLifetime() != null) continue;
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MissingLifetimeSpecifier(and), this.$holder, false, null, 6, null);
                }
            }

            private static final boolean visitFunction2$lambda$0(PsiElement it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                PsiElement psiElement2 = it2;
                return psiElement2 instanceof RsFnPointerType ? false : (psiElement2 instanceof RsPath ? ((RsPath)it2).getValueParameterList() == null : true);
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }
}

