/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.RsWrongGenericParametersNumberInspection;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsTypeAlias;
import org.rust.lang.core.psi.RsTypeParameterList;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsGenericDeclarationKt;
import org.rust.lang.core.psi.ext.RsGenericParameter;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016JR\u0010\n\u001a\u00020\u000b\"\f\b\u0000\u0010\f*\u00020\r*\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u0002H\f2\u0006\u0010\u0010\u001a\u00020\u00112\u001d\u0010\u0012\u001a\u0019\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013\u00a2\u0006\u0002\b\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/rust/ide/inspections/RsWrongGenericParametersNumberInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkParameters", "", "T", "Lorg/rust/lang/core/psi/ext/RsAbstractable;", "Lorg/rust/lang/core/psi/ext/RsGenericDeclaration;", "item", "paramType", "", "getParameters", "Lkotlin/Function1;", "", "Lorg/rust/lang/core/psi/ext/RsGenericParameter;", "Lkotlin/ExtensionFunctionType;", "(Lorg/rust/ide/inspections/RsProblemsHolder;Lorg/rust/lang/core/psi/ext/RsAbstractable;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsWrongGenericParametersNumberInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsWrongGenericParametersNumberInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFunction2(RsFunction function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                RsWrongGenericParametersNumberInspection.access$checkParameters(this.this$0, this.$holder, function, "type", buildVisitor.1::visitFunction2$lambda$0);
                RsWrongGenericParametersNumberInspection.access$checkParameters(this.this$0, this.$holder, function, "const", buildVisitor.1::visitFunction2$lambda$1);
            }

            public void visitTypeAlias2(RsTypeAlias alias) {
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                RsWrongGenericParametersNumberInspection.access$checkParameters(this.this$0, this.$holder, alias, "type", buildVisitor.1::visitTypeAlias2$lambda$2);
                RsWrongGenericParametersNumberInspection.access$checkParameters(this.this$0, this.$holder, alias, "const", buildVisitor.1::visitTypeAlias2$lambda$3);
            }

            private static final List visitFunction2$lambda$0(RsGenericDeclaration $this$checkParameters) {
                Intrinsics.checkNotNullParameter((Object)$this$checkParameters, (String)"$this$checkParameters");
                return RsGenericDeclarationKt.getTypeParameters($this$checkParameters);
            }

            private static final List visitFunction2$lambda$1(RsGenericDeclaration $this$checkParameters) {
                Intrinsics.checkNotNullParameter((Object)$this$checkParameters, (String)"$this$checkParameters");
                return RsGenericDeclarationKt.getConstParameters($this$checkParameters);
            }

            private static final List visitTypeAlias2$lambda$2(RsGenericDeclaration $this$checkParameters) {
                Intrinsics.checkNotNullParameter((Object)$this$checkParameters, (String)"$this$checkParameters");
                return RsGenericDeclarationKt.getTypeParameters($this$checkParameters);
            }

            private static final List visitTypeAlias2$lambda$3(RsGenericDeclaration $this$checkParameters) {
                Intrinsics.checkNotNullParameter((Object)$this$checkParameters, (String)"$this$checkParameters");
                return RsGenericDeclarationKt.getConstParameters($this$checkParameters);
            }
        };
    }

    private final <T extends RsAbstractable & RsGenericDeclaration> void checkParameters(RsProblemsHolder holder, T item, String paramType, Function1<? super RsGenericDeclaration, ? extends List<? extends RsGenericParameter>> getParameters) {
        PsiElement psiElement2;
        String string;
        String string2 = item.getName();
        if (string2 == null) {
            return;
        }
        String itemName = string2;
        T t = item;
        if (t instanceof RsFunction) {
            string = "Method";
        } else if (t instanceof RsTypeAlias) {
            string = "Type";
        } else {
            return;
        }
        String itemType = string;
        RsAbstractable rsAbstractable = RsAbstractableKt.getSuperItem(item);
        RsGenericDeclaration rsGenericDeclaration = rsAbstractable instanceof RsGenericDeclaration ? (RsGenericDeclaration)((Object)rsAbstractable) : null;
        if (rsGenericDeclaration == null) {
            return;
        }
        RsGenericDeclaration superItem = rsGenericDeclaration;
        RsTypeParameterList rsTypeParameterList = ((RsGenericDeclaration)item).getTypeParameterList();
        if (rsTypeParameterList != null) {
            psiElement2 = rsTypeParameterList;
        } else {
            psiElement2 = ((PsiNameIdentifierOwner)item).getNameIdentifier();
            if (psiElement2 == null) {
                return;
            }
        }
        PsiElement toHighlight = psiElement2;
        List typeParameters = (List)getParameters.invoke(item);
        List superTypeParameters = (List)getParameters.invoke((Object)superItem);
        if (typeParameters.size() == superTypeParameters.size()) {
            return;
        }
        String paramName = paramType + " " + StringUtil.pluralize((String)"parameter", (int)typeParameters.size());
        String superParamName = paramType + " " + StringUtil.pluralize((String)"parameter", (int)superTypeParameters.size());
        Object[] objectArray = new Object[]{itemType, itemName, typeParameters.size(), paramName, superTypeParameters.size(), superParamName};
        String problemText = RsBundle.INSTANCE.message("inspection.message.has.but.its.trait.declaration.has", objectArray);
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.WrongNumberOfGenericParameters(toHighlight, problemText), holder, false, null, 6, null);
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkParameters(RsWrongGenericParametersNumberInspection $this, RsProblemsHolder holder, RsAbstractable item, String paramType, Function1 getParameters) {
        $this.checkParameters(holder, item, paramType, (Function1<? super RsGenericDeclaration, ? extends List<? extends RsGenericParameter>>)getParameters);
    }
}

