/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.RsWrongGenericArgumentsNumberInspectionKt;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPathType;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.RsTypeArgumentList;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsGenericDeclarationKt;
import org.rust.lang.core.psi.ext.RsMethodOrPath;
import org.rust.lang.core.psi.ext.RsTypeArgumentListKt;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/inspections/RsWrongGenericArgumentsNumberInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isPathValid", "path", "Lorg/rust/lang/core/psi/RsPath;", "checkTypeArguments", "", "element", "Lorg/rust/lang/core/psi/ext/RsMethodOrPath;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsWrongGenericArgumentsNumberInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsWrongGenericArgumentsNumberInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitMethodCall(RsMethodCall methodCall) {
                Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
                RsWrongGenericArgumentsNumberInspection.access$checkTypeArguments(this.this$0, this.$holder, methodCall);
            }

            public void visitPath(RsPath path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                if (!RsWrongGenericArgumentsNumberInspection.access$isPathValid(this.this$0, path)) {
                    return;
                }
                RsWrongGenericArgumentsNumberInspection.access$checkTypeArguments(this.this$0, this.$holder, path);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPathValid(RsPath path) {
        RsPath rsPath = path;
        if ((rsPath != null ? rsPath.getValueParameterList() : null) != null) return false;
        RsPath rsPath2 = path;
        if (rsPath2 == null) return true;
        PsiElement psiElement2 = rsPath2.getCself();
        if (psiElement2 != null) return false;
        return true;
    }

    private final void checkTypeArguments(RsProblemsHolder holder, RsMethodOrPath element) {
        Object object;
        int expectedTotalConstParams;
        int expectedTotalTypeParams;
        int expectedTotalParams;
        int actualConstArgs;
        int actualArgs;
        Pair<RsTypeArgumentList, RsGenericDeclaration> pair = RsWrongGenericArgumentsNumberInspectionKt.getTypeArgumentsAndDeclaration(element);
        if (pair == null) {
            return;
        }
        Pair<RsTypeArgumentList, RsGenericDeclaration> pair2 = pair;
        RsTypeArgumentList actualArguments = (RsTypeArgumentList)pair2.component1();
        RsGenericDeclaration declaration = (RsGenericDeclaration)pair2.component2();
        RsTypeArgumentList rsTypeArgumentList = actualArguments;
        List list = rsTypeArgumentList != null ? RsTypeArgumentListKt.getTypeArguments(rsTypeArgumentList) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        int actualTypeArgs = list.size();
        RsTypeArgumentList rsTypeArgumentList2 = actualArguments;
        List list2 = rsTypeArgumentList2 != null ? RsTypeArgumentListKt.getConstArguments(rsTypeArgumentList2) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        if ((actualArgs = actualTypeArgs + (actualConstArgs = list2.size())) == (expectedTotalParams = (expectedTotalTypeParams = RsGenericDeclarationKt.getTypeParameters(declaration).size()) + (expectedTotalConstParams = RsGenericDeclarationKt.getConstParameters(declaration).size()))) {
            return;
        }
        int expectedRequiredParams = RsGenericDeclarationKt.getRequiredGenericParameters(declaration).size();
        PsiElement psiElement2 = element.getParent();
        int minRequiredParams = psiElement2 instanceof RsPathType || psiElement2 instanceof RsTraitRef ? 0 : 1;
        if (actualArgs > expectedTotalParams) {
            object = expectedRequiredParams != expectedTotalParams ? "at most " + expectedTotalParams : String.valueOf(expectedTotalParams);
        } else {
            boolean bl = minRequiredParams <= actualArgs ? actualArgs < expectedRequiredParams : false;
            if (bl) {
                object = expectedRequiredParams != expectedTotalParams ? "at least " + expectedRequiredParams : String.valueOf(expectedTotalParams);
            } else {
                return;
            }
        }
        Object errorText = object;
        boolean haveTypeParams = expectedTotalTypeParams > 0 || actualTypeArgs > 0;
        boolean haveConstParams = expectedTotalConstParams > 0 || actualConstArgs > 0;
        String argumentName = haveTypeParams && !haveConstParams ? "type" : (!haveTypeParams && haveConstParams ? "const" : "generic");
        Object[] objectArray = new Object[]{argumentName, errorText, actualArgs};
        String problemText = RsBundle.INSTANCE.message("inspection.message.wrong.number.arguments.expected.found", objectArray);
        List fixes = RsWrongGenericArgumentsNumberInspectionKt.access$getFixes(declaration, element, actualArgs, expectedTotalParams);
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.WrongNumberOfGenericArguments(element, problemText, fixes), holder, false, null, 6, null);
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkTypeArguments(RsWrongGenericArgumentsNumberInspection $this, RsProblemsHolder holder, RsMethodOrPath element) {
        $this.checkTypeArguments(holder, element);
    }

    public static final /* synthetic */ boolean access$isPathValid(RsWrongGenericArgumentsNumberInspection $this, RsPath path) {
        return $this.isPathValid(path);
    }
}

