/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsReplaceWithQuestionMark;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.resolve.KnownItems;
import org.rust.lang.core.resolve.KnownItemsKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/rust/ide/inspections/RsUnwrapInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "intellij.rustrover.core"})
public final class RsUnwrapInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitMethodCallExpr(RsMethodCallExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsExpr rsExpr = o.getReceiver();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"<get-receiver>(...)");
                Ty ty2 = ExtensionsKt.getType(rsExpr);
                TyAdt tyAdt = ty2 instanceof TyAdt ? (TyAdt)ty2 : null;
                if (tyAdt == null) {
                    return;
                }
                TyAdt receiverTy = tyAdt;
                KnownItems items = KnownItemsKt.getKnownItems(o);
                if (!Intrinsics.areEqual((Object)receiverTy.getItem(), (Object)items.getResult())) {
                    return;
                }
                RsElement rsElement = o.getMethodCall().getReference().resolve();
                RsFunction rsFunction = rsElement instanceof RsFunction ? (RsFunction)rsElement : null;
                if (rsFunction == null) {
                    return;
                }
                RsFunction method = rsFunction;
                if (!Intrinsics.areEqual((Object)method.getName(), (Object)"unwrap")) {
                    return;
                }
                if (ExtensionsKt.getImplLookup(o).isQuestionMarkApplicable(o, receiverTy, null)) {
                    RsMethodCall rsMethodCall = o.getMethodCall();
                    Intrinsics.checkNotNullExpressionValue((Object)rsMethodCall, (String)"getMethodCall(...)");
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RsReplaceWithQuestionMark(o)};
                    RsProblemsHolder.registerProblem$default(this.$holder, rsMethodCall, RsBundle.INSTANCE.message("inspection.message.unwrap.can.be.replaced", new Object[0]), ProblemHighlightType.WEAK_WARNING, localQuickFixArray, null, 16, null);
                }
            }
        };
    }
}

