/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.fixes.AddRequiredDependencyFeaturesFix;
import org.rust.ide.fixes.ToggleFeatureFix;
import org.rust.ide.inspections.RsExperimentalUnresolvedMethodInspection;
import org.rust.ide.inspections.RsExperimentalUnresolvedPathInspection;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsUnresolvedMethodInspection;
import org.rust.ide.inspections.RsUnresolvedPathInspection;
import org.rust.ide.inspections.RsUnresolvedReferenceInspectionBaseKt;
import org.rust.ide.inspections.import.AddCSelfContext;
import org.rust.ide.inspections.import.AddCrateDependencyContext;
import org.rust.ide.inspections.import.AddRequiredFeaturesContext;
import org.rust.ide.inspections.import.AutoImportFix;
import org.rust.ide.inspections.import.AutoImportFixContext;
import org.rust.ide.inspections.import.ConvertToPreludeMacroCall;
import org.rust.ide.inspections.import.CreateUnresolvedSymbolContext;
import org.rust.ide.inspections.import.ImportFromCrateContext;
import org.rust.ide.inspections.import.UnresolvedReferenceResolutionContext;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.ide.refactoring.move.common.RsMoveUtil;
import org.rust.lang.core.macros.proc.ProcMacroApplicationService;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsEnumItem;
import org.rust.lang.core.psi.RsExternCrateItem;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsPathType;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsStructLiteral;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.RsTypeQual;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsUseGroup;
import org.rust.lang.core.psi.RsUseSpeck;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.PathResolveStatus;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsCodeStatus;
import org.rust.lang.core.psi.ext.RsDotExpr;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMethodOrFieldKt;
import org.rust.lang.core.psi.ext.RsPathKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKt;
import org.rust.lang.core.psi.ext.RsReferenceElement;
import org.rust.lang.core.resolve.RsPathResolveResult;
import org.rust.lang.core.resolve.VisibilityStatus;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.RsInferenceContext;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;
import org.rust.lang.utils.RsErrorCode;
import org.rust.lang.utils.Severity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0004J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0004J\"\u0010\u0012\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J*\u0010\u0012\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\u001a\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010\u001a\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002R\u0018\u0010(\u001a\u00020\u001e*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lorg/rust/ide/inspections/RsUnresolvedReferenceInspectionBase;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "doVisitPath", "", "path", "Lorg/rust/lang/core/psi/RsPath;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "doVisitMethodCall", "methodCall", "Lorg/rust/lang/core/psi/RsMethodCall;", "getDiagnostic", "Lorg/rust/lang/utils/RsDiagnostic$UnresolvedReferenceError;", "doVisitExternCrateItem", "externCrate", "Lorg/rust/lang/core/psi/RsExternCrateItem;", "registerProblem", "element", "Lorg/rust/lang/core/psi/ext/RsReferenceElement;", "contexts", "", "Lorg/rust/ide/inspections/import/UnresolvedReferenceResolutionContext;", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "addProperErrorToHolder", "fixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "alwaysShowError", "", "shouldMuteErrorForMethodCall", "Lorg/rust/lang/core/types/infer/RsInferenceContext$MutingReason;", "getFallbackUnresolvedReferenceError", "", "getUseSpeckError", "useSpeck", "Lorg/rust/lang/core/psi/RsUseSpeck;", "highlightedElement", "Lcom/intellij/psi/PsiElement;", "isUnsupportedTypeDependentPath", "(Lorg/rust/lang/core/psi/ext/RsReferenceElement;)Z", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsUnresolvedReferenceInspectionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsUnresolvedReferenceInspectionBase.kt\norg/rust/ide/inspections/RsUnresolvedReferenceInspectionBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psi.kt\norg/rust/openapiext/PsiKt\n*L\n1#1,429:1\n1740#2,3:430\n1761#2,3:433\n1761#2,3:436\n1869#2,2:445\n246#3:439\n246#3:440\n246#3:441\n246#3:442\n246#3:443\n246#3:444\n*S KotlinDebug\n*F\n+ 1 RsUnresolvedReferenceInspectionBase.kt\norg/rust/ide/inspections/RsUnresolvedReferenceInspectionBase\n*L\n44#1:430,3\n105#1:433,3\n110#1:436,3\n309#1:445,2\n138#1:439\n188#1:440\n190#1:441\n250#1:442\n273#1:443\n280#1:444\n*E\n"})
public abstract class RsUnresolvedReferenceInspectionBase
extends RsLocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected final void doVisitPath(@NotNull RsPath path, @NotNull RsProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Companion.PathInfo pathInfo = Companion.processPath(path, true);
        if (pathInfo == null) {
            return;
        }
        Companion.PathInfo pathInfo2 = pathInfo;
        boolean isPathUnresolved = pathInfo2.component1();
        List<UnresolvedReferenceResolutionContext> contexts = pathInfo2.component2();
        if (isPathUnresolved || !((Collection)contexts).isEmpty()) {
            this.registerProblem(holder, path, contexts);
        }
    }

    protected final void doVisitMethodCall(@NotNull RsMethodCall methodCall, @NotNull RsProblemsHolder holder) {
        RsDiagnostic.UnresolvedReferenceError diagnostic;
        boolean bl;
        boolean isMethodResolved;
        block7: {
            Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            List<RsElement> resolve = methodCall.getReference().multiResolve();
            isMethodResolved = !((Collection)resolve).isEmpty();
            Iterable $this$all$iv = resolve;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    RsElement it2 = (RsElement)element$iv;
                    boolean bl2 = false;
                    if (CfgUtilsKt.getCodeStatus(it2, null) == RsCodeStatus.CFG_DISABLED) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        boolean allCfgDisabled = bl;
        RsDiagnostic.UnresolvedReferenceError unresolvedReferenceError = diagnostic = isMethodResolved ? null : this.getDiagnostic(methodCall);
        if (RsUnresolvedReferenceInspectionBaseKt.shouldIgnoreUnresolvedReference(methodCall)) {
            return;
        }
        Object[] objectArray = new UnresolvedReferenceResolutionContext[]{AutoImportFix.Companion.findApplicableContext(methodCall), !isMethodResolved ? CreateUnresolvedSymbolContext.INSTANCE : null, isMethodResolved && allCfgDisabled ? AddRequiredFeaturesContext.INSTANCE : null};
        List contexts = CollectionsKt.listOfNotNull((Object[])objectArray);
        if (diagnostic != null) {
            this.registerProblem(holder, methodCall, contexts, diagnostic);
        } else if (!((Collection)contexts).isEmpty()) {
            this.registerProblem(holder, methodCall, contexts);
        }
    }

    private final RsDiagnostic.UnresolvedReferenceError getDiagnostic(RsMethodCall methodCall) {
        RsDiagnostic.UnresolvedReferenceError unresolvedReferenceError;
        RsInferenceContext.MutingReason muteReason;
        Class inspectionClass;
        Ty receiverType = ExtensionsKt.getType(RsMethodOrFieldKt.getReceiver(methodCall));
        RsInferenceContext.MutingReason mutingReason = RsInferenceContext.Helper.shouldMuteErrorForType$default(RsInferenceContext.Helper.INSTANCE, receiverType, null, 2, null);
        if (mutingReason == null) {
            mutingReason = this.shouldMuteErrorForMethodCall(methodCall);
        }
        Class clazz = inspectionClass = (muteReason = mutingReason) != null ? RsExperimentalUnresolvedMethodInspection.class : RsUnresolvedMethodInspection.class;
        if (Intrinsics.areEqual(inspectionClass, ((Object)((Object)this)).getClass())) {
            RsInferenceContext.MutingReason mutingReason2 = muteReason;
            if (mutingReason2 != null) {
                PsiElement psiElement2 = methodCall.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getIdentifier(...)");
                mutingReason2.report(psiElement2, RsErrorCode.E0599);
            }
            PsiElement psiElement3 = methodCall.getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getIdentifier(...)");
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)methodCall.getIdentifier().getText(), (String)"getText(...)");
            objectArray[1] = TypeRenderingKt.render$default(receiverType, null, 0, null, null, null, null, null, null, null, false, false, false, false, false, false, false, null, 131071, null);
            RsDiagnostic.UnresolvedReferenceError unresolvedReferenceError2 = new RsDiagnostic.UnresolvedReferenceError(psiElement3, RsErrorCode.E0599, Severity.UNKNOWN_SYMBOL, RsBundle.INSTANCE.message("inspection.message.unresolved.method.for.type", objectArray), CollectionsKt.emptyList(), inspectionClass);
            unresolvedReferenceError = unresolvedReferenceError2;
        } else {
            unresolvedReferenceError = null;
        }
        return unresolvedReferenceError;
    }

    protected final void doVisitExternCrateItem(@NotNull RsExternCrateItem externCrate, @NotNull RsProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)externCrate, (String)"externCrate");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (externCrate.getReference().multiResolve().isEmpty() && externCrate.getContainingCrate().getOrigin() == PackageOrigin.WORKSPACE) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.CrateNotFoundError(externCrate.getReferenceNameElement(), externCrate.getReferenceName()), holder, false, null, 6, null);
        }
    }

    private final void registerProblem(RsProblemsHolder $this$registerProblem, RsReferenceElement element, List<? extends UnresolvedReferenceResolutionContext> contexts) {
        boolean showError;
        boolean bl;
        List fixes;
        boolean hasAutoImportFixWithCandidates;
        block8: {
            boolean bl2;
            block7: {
                Iterable $this$any$iv = contexts;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UnresolvedReferenceResolutionContext it2 = (UnresolvedReferenceResolutionContext)element$iv;
                        boolean bl3 = false;
                        if (!(it2 instanceof AutoImportFixContext && (!((Collection)((AutoImportFixContext)it2).getCandidates()).isEmpty() || !((Collection)((AutoImportFixContext)it2).getDocAliasCandidates()).isEmpty()))) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            hasAutoImportFixWithCandidates = bl2;
            fixes = RsUnresolvedReferenceInspectionBaseKt.access$createQuickFixes(element, contexts);
            Iterable $this$any$iv = fixes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LocalQuickFix it3 = (LocalQuickFix)element$iv;
                    boolean bl4 = false;
                    if (!(it3 instanceof ToggleFeatureFix || it3 instanceof AddRequiredDependencyFeaturesFix)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean hasAddOrEnableFeatureFix = bl;
        boolean bl5 = showError = hasAutoImportFixWithCandidates || !this.isUnsupportedTypeDependentPath(element) && Registry.Companion.is("org.rust.insp.unresolved.reference.type.independent") || hasAddOrEnableFeatureFix;
        if (RsUnresolvedReferenceInspectionBaseKt.shouldIgnoreUnresolvedReference(element)) {
            return;
        }
        this.addProperErrorToHolder($this$registerProblem, element, (List<? extends LocalQuickFix>)fixes, showError);
    }

    private final void registerProblem(RsProblemsHolder $this$registerProblem, RsReferenceElement element, List<? extends UnresolvedReferenceResolutionContext> contexts, RsDiagnostic diagnostic) {
        List fixes = RsUnresolvedReferenceInspectionBaseKt.access$createQuickFixes(element, contexts);
        this.addProperErrorToHolder($this$registerProblem, element, (List<? extends LocalQuickFix>)fixes, diagnostic);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void addProperErrorToHolder(RsProblemsHolder $this$addProperErrorToHolder, RsReferenceElement element, List<? extends LocalQuickFix> fixes, boolean alwaysShowError) {
        Pair pair;
        Pair pair2;
        Pair pair3;
        PsiElement context;
        boolean bl;
        RsPath contextPath;
        RsInferenceContext.MutingReason mutingReason;
        Object[] highlightedElement;
        Object[] objectArray = element.getReferenceNameElement();
        if (objectArray == null) {
            objectArray = highlightedElement = (PsiElement)element;
        }
        if ((mutingReason = this.shouldMuteErrorForMethodCall(element)) != null) {
            RsInferenceContext.MutingReason it2 = mutingReason;
            boolean bl2 = false;
            it2.report(element, RsErrorCode.E0599);
            return;
        }
        Object[] $this$contextTryAs$iv = highlightedElement;
        boolean $i$f$contextTryAs = false;
        Object object = $this$contextTryAs$iv != null ? $this$contextTryAs$iv.getContext() : null;
        if (!(object instanceof RsPath)) {
            object = null;
        }
        RsPath rsPath = contextPath = (RsPath)object;
        if (rsPath != null) {
            if (RsPathKt.isSelfImport(rsPath)) {
                return;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return;
        RsPath rsPath2 = contextPath;
        if ((rsPath2 != null ? rsPath2.getSuper() : null) != null) {
            return;
        }
        PsiElement psiElement2 = highlightedElement.getContext();
        Object object2 = context = psiElement2 != null ? psiElement2.getContext() : null;
        if (context instanceof RsTraitRef) {
            bl2 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
            pair3 = TuplesKt.to((Object)((Object)RsErrorCode.E0405), (Object)RsBundle.INSTANCE.message("inspection.message.unresolved.trait", bl2));
        } else if (context instanceof RsPathType) {
            bl2 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
            pair3 = TuplesKt.to((Object)((Object)RsErrorCode.E0412), (Object)RsBundle.INSTANCE.message("inspection.message.unresolved.type", bl2));
        } else if (context instanceof RsStructLiteral) {
            bl2 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
            pair3 = TuplesKt.to((Object)((Object)RsErrorCode.E0422), (Object)RsBundle.INSTANCE.message("inspection.message.unresolved.struct.variant.or.union", bl2));
        } else if (context instanceof RsPathExpr) {
            RsElement resolved;
            Object object3 = ((RsPathExpr)context).getPath().getPath();
            RsElement rsElement = object3 != null && (object3 = object3.getReference()) != null ? object3.resolve() : (resolved = null);
            if (resolved instanceof RsEnumItem) {
                pair2 = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
                String string = ((RsEnumItem)resolved).getName();
                if (string == null) {
                    string = "";
                }
                pair2[1] = string;
                pair3 = TuplesKt.to((Object)((Object)RsErrorCode.E0599), (Object)RsBundle.INSTANCE.message("inspection.message.unresolved.variant.or.associated.item", (Object[])pair2));
            } else if (resolved instanceof RsStructItem) {
                String string;
                String string2 = highlightedElement.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                Character c = StringsKt.firstOrNull((CharSequence)string2);
                boolean bl3 = c != null ? Character.isLowerCase(c.charValue()) : false;
                if (bl3) {
                    pair2 = new Object[2];
                    Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
                    String string3 = ((RsStructItem)resolved).getName();
                    if (string3 == null) {
                        string3 = "";
                    }
                    pair2[1] = string3;
                    string = RsBundle.INSTANCE.message("inspection.message.unresolved.function.or.associated.item", (Object[])pair2);
                } else {
                    pair2 = new Object[2];
                    Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
                    String string4 = ((RsStructItem)resolved).getName();
                    if (string4 == null) {
                        string4 = "";
                    }
                    pair2[1] = string4;
                    string = RsBundle.INSTANCE.message("inspection.message.unresolved.associated.item.for.struct", (Object[])pair2);
                }
                pair3 = TuplesKt.to((Object)((Object)RsErrorCode.E0599), (Object)string);
            } else {
                String string = ((RsPathExpr)context).getContext() instanceof RsCallExpr ? "inspection.message.unresolved.function.name" : "inspection.message.unresolved.value.name";
                pair2 = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
                pair3 = TuplesKt.to((Object)((Object)RsErrorCode.E0425), (Object)RsBundle.INSTANCE.message(string, (Object[])pair2));
            }
        } else if (context instanceof RsDotExpr) {
            TyAdt type;
            pair2 = ExtensionsKt.getType(((RsDotExpr)context).getReceiver());
            TyAdt tyAdt = type = pair2 instanceof TyAdt ? (TyAdt)pair2 : null;
            if (highlightedElement.getContext() instanceof RsMethodCall && type != null) {
                pair2 = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
                pair2[1] = type.toString();
                pair3 = TuplesKt.to((Object)((Object)RsErrorCode.E0599), (Object)RsBundle.INSTANCE.message("inspection.message.unresolved.method", (Object[])pair2));
            } else {
                pair3 = TuplesKt.to(null, (Object)this.getFallbackUnresolvedReferenceError(element));
            }
        } else if (context instanceof RsPath) {
            RsUseSpeck useSpeck;
            PsiElement $this$contextTryAs$iv2 = context;
            boolean $i$f$contextTryAs2 = false;
            PsiElement psiElement3 = $this$contextTryAs$iv2.getContext();
            if (!(psiElement3 instanceof RsUseSpeck)) {
                psiElement3 = null;
            }
            if ((useSpeck = (RsUseSpeck)psiElement3) == null) {
                String string;
                RsPath firstPath;
                Object[] $this$contextTryAs$iv3 = highlightedElement;
                boolean $i$f$contextTryAs3 = false;
                Object object4 = $this$contextTryAs$iv3 != null ? $this$contextTryAs$iv3.getContext() : null;
                if (!(object4 instanceof RsPath)) {
                    object4 = null;
                }
                RsPath rsPath4 = (RsPath)object4;
                rsPath4 = firstPath = rsPath4 != null ? rsPath4.getPath() : null;
                if (firstPath != null) {
                    $this$contextTryAs$iv3 = new Object[2];
                    Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
                    String string5 = firstPath.getReferenceName();
                    if (string5 == null) {
                        string5 = "";
                    }
                    $this$contextTryAs$iv3[1] = string5;
                    string = RsBundle.INSTANCE.message("inspection.message.failed.to.resolve.could.not.find", $this$contextTryAs$iv3);
                } else {
                    String string6 = highlightedElement.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
                    Character c = StringsKt.firstOrNull((CharSequence)string6);
                    boolean bl4 = c != null ? Character.isLowerCase(c.charValue()) : false;
                    if (bl4) {
                        $this$contextTryAs$iv3 = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
                        string = RsBundle.INSTANCE.message("inspection.message.failed.to.resolve.use.undeclared.crate.or.module", $this$contextTryAs$iv3);
                    } else {
                        $this$contextTryAs$iv3 = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)highlightedElement.getText(), (String)"getText(...)");
                        string = RsBundle.INSTANCE.message("inspection.message.failed.to.resolve.use.undeclared.type", $this$contextTryAs$iv3);
                    }
                }
                String errorText = string;
                pair3 = TuplesKt.to((Object)((Object)RsErrorCode.E0433), (Object)errorText);
            } else {
                pair3 = TuplesKt.to((Object)((Object)RsErrorCode.E0432), (Object)this.getUseSpeckError(useSpeck, (PsiElement)highlightedElement));
            }
        } else {
            pair3 = context instanceof RsUseSpeck ? TuplesKt.to((Object)((Object)RsErrorCode.E0432), (Object)this.getUseSpeckError((RsUseSpeck)context, (PsiElement)highlightedElement)) : TuplesKt.to(null, (Object)this.getFallbackUnresolvedReferenceError(element));
        }
        Pair pair4 = pair3;
        RsErrorCode errorCode = (RsErrorCode)((Object)pair4.component1());
        String description = (String)pair4.component2();
        RsReferenceElement errorText = element;
        if (errorText instanceof RsPath) {
            if (alwaysShowError) {
                pair = TuplesKt.to((Object)true, (Object)Reflection.getOrCreateKotlinClass(RsUnresolvedPathInspection.class));
            } else if (new RsExperimentalUnresolvedPathInspection().isEnabled(element)) {
                pair = TuplesKt.to((Object)true, (Object)Reflection.getOrCreateKotlinClass(RsExperimentalUnresolvedPathInspection.class));
            } else {
                if (((Collection)fixes).isEmpty()) return;
                boolean bl5 = true;
                if (!bl5) return;
                pair = TuplesKt.to((Object)false, (Object)Reflection.getOrCreateKotlinClass(RsUnresolvedPathInspection.class));
            }
        } else {
            if (!(errorText instanceof RsMethodCall)) return;
            if (alwaysShowError) {
                pair = TuplesKt.to((Object)true, (Object)Reflection.getOrCreateKotlinClass(RsUnresolvedMethodInspection.class));
            } else if (new RsExperimentalUnresolvedMethodInspection().isEnabled(element)) {
                pair = TuplesKt.to((Object)true, (Object)Reflection.getOrCreateKotlinClass(RsExperimentalUnresolvedMethodInspection.class));
            } else {
                if (((Collection)fixes).isEmpty()) return;
                boolean bl6 = true;
                if (!bl6) return;
                pair = TuplesKt.to((Object)false, (Object)Reflection.getOrCreateKotlinClass(RsUnresolvedMethodInspection.class));
            }
        }
        pair2 = pair;
        boolean addAsError = (Boolean)pair2.component1();
        KClass inspectionClass = (KClass)pair2.component2();
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), (Object)JvmClassMappingKt.getJavaClass((KClass)inspectionClass))) {
            return;
        }
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnresolvedReferenceError((PsiElement)highlightedElement, errorCode, addAsError ? Severity.UNKNOWN_SYMBOL : Severity.INFO, description, fixes, null, 32, null), $this$addProperErrorToHolder, false, null, 6, null);
    }

    private final void addProperErrorToHolder(RsProblemsHolder $this$addProperErrorToHolder, RsReferenceElement element, List<? extends LocalQuickFix> fixes, RsDiagnostic diagnostic) {
        block6: {
            block5: {
                RsPath contextPath;
                PsiElement highlightedElement;
                PsiElement psiElement2 = element.getReferenceNameElement();
                if (psiElement2 == null) {
                    psiElement2 = element;
                }
                PsiElement $this$contextTryAs$iv = highlightedElement = psiElement2;
                boolean $i$f$contextTryAs = false;
                PsiElement psiElement3 = $this$contextTryAs$iv;
                Object object = psiElement3 != null ? psiElement3.getContext() : null;
                if (!(object instanceof RsPath)) {
                    object = null;
                }
                RsPath rsPath = contextPath = (RsPath)object;
                if (rsPath != null ? RsPathKt.isSelfImport(rsPath) : false) break block5;
                RsPath rsPath2 = contextPath;
                if ((rsPath2 != null ? rsPath2.getSuper() : null) == null) break block6;
            }
            return;
        }
        RsDiagnosticKt.addToHolder$default(diagnostic, $this$addProperErrorToHolder, false, fixes, 2, null);
    }

    private final RsInferenceContext.MutingReason shouldMuteErrorForMethodCall(RsReferenceElement element) {
        PsiElement highlightedElement;
        PsiElement psiElement2 = element.getReferenceNameElement();
        if (psiElement2 == null) {
            psiElement2 = element;
        }
        if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(highlightedElement = psiElement2), (Object)RsElementTypes.IDENTIFIER) && Intrinsics.areEqual((Object)highlightedElement.getText(), (Object)"await") || Intrinsics.areEqual((Object)highlightedElement.getText(), (Object)"async")) {
            return new RsInferenceContext.MutingReason(RsInferenceContext.MutingReason.MutingKind.ASYNC_AWAIT, null, 2, null);
        }
        return null;
    }

    private final String getFallbackUnresolvedReferenceError(RsReferenceElement element) {
        String string;
        String referenceName = element.getReferenceName();
        if (referenceName == null) {
            string = RsBundle.INSTANCE.message("inspection.message.unresolved.reference2", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{referenceName};
            string = RsBundle.INSTANCE.message("inspection.message.unresolved.reference", objectArray);
        }
        return string;
    }

    private final String getUseSpeckError(RsUseSpeck useSpeck, PsiElement highlightedElement) {
        Object object;
        if (useSpeck.getContext() instanceof RsUseGroup) {
            RsUseSpeck parentUseSpeck;
            $this$contextTryAs$iv = useSpeck.getContext();
            $i$f$contextTryAs = false;
            PsiElement psiElement2 = $this$contextTryAs$iv;
            Object object2 = psiElement2 != null ? psiElement2.getContext() : null;
            if (!(object2 instanceof RsUseSpeck)) {
                object2 = null;
            }
            if ((parentUseSpeck = (RsUseSpeck)object2) != null) {
                RsPath rsPath = parentUseSpeck.getPath();
                object = (rsPath != null ? RsMoveUtil.INSTANCE.getTextNormalized(rsPath) : null) + "::" + highlightedElement.getText();
            } else {
                object = highlightedElement.getText();
            }
        } else {
            $this$contextTryAs$iv = highlightedElement;
            $i$f$contextTryAs = false;
            PsiElement psiElement3 = $this$contextTryAs$iv;
            Object object3 = psiElement3 != null ? psiElement3.getContext() : null;
            if (!(object3 instanceof RsPath)) {
                object3 = null;
            }
            if ((object = (RsPath)object3) == null || (object = RsMoveUtil.INSTANCE.getTextNormalized((RsPath)object)) == null) {
                object = highlightedElement.getText();
            }
        }
        Object importText = object;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)importText);
        objectArray[0] = importText;
        return RsBundle.INSTANCE.message("inspection.message.unresolved.import", objectArray);
    }

    private final boolean isUnsupportedTypeDependentPath(RsReferenceElement $this$isUnsupportedTypeDependentPath) {
        if (!($this$isUnsupportedTypeDependentPath instanceof RsPath)) {
            return true;
        }
        RsTypeQual typeQual = ((RsPath)$this$isUnsupportedTypeDependentPath).getTypeQual();
        if (typeQual != null) {
            RsTypeReference rsTypeReference = typeQual.getTypeReference();
            Intrinsics.checkNotNullExpressionValue((Object)rsTypeReference, (String)"getTypeReference(...)");
            Ty type = ExtensionsKt.getNormType(rsTypeReference);
            RsInferenceContext.MutingReason mutingReason = RsInferenceContext.Helper.shouldMuteErrorForType$default(RsInferenceContext.Helper.INSTANCE, type, null, 2, null);
            if (mutingReason != null) {
                mutingReason.report($this$isUnsupportedTypeDependentPath, RsErrorCode.E0599);
                return true;
            }
        }
        RsPath rsPath = ((RsPath)$this$isUnsupportedTypeDependentPath).getPath();
        if (rsPath == null) {
            return false;
        }
        RsPath qualifier = rsPath;
        Object object = qualifier.getTypeArgumentList();
        if (object != null && (object = object.getTypeReferenceList()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RsTypeReference it2 = (RsTypeReference)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                Ty type = ExtensionsKt.getNormType(it2);
                RsInferenceContext.MutingReason mutingReason = RsInferenceContext.Helper.shouldMuteErrorForType$default(RsInferenceContext.Helper.INSTANCE, type, null, 2, null);
                if (mutingReason == null) continue;
                mutingReason.report($this$isUnsupportedTypeDependentPath, RsErrorCode.E0599);
                return true;
            }
        }
        RsPathReference rsPathReference = qualifier.getReference();
        return (rsPathReference != null ? rsPathReference.resolve() : null) == null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/inspections/RsUnresolvedReferenceInspectionBase$Companion;", "", "<init>", "()V", "processPath", "Lorg/rust/ide/inspections/RsUnresolvedReferenceInspectionBase$Companion$PathInfo;", "path", "Lorg/rust/lang/core/psi/RsPath;", "searchForDocAliases", "", "PathInfo", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsUnresolvedReferenceInspectionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsUnresolvedReferenceInspectionBase.kt\norg/rust/ide/inspections/RsUnresolvedReferenceInspectionBase$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,429:1\n1#2:430\n1761#3,3:431\n*S KotlinDebug\n*F\n+ 1 RsUnresolvedReferenceInspectionBase.kt\norg/rust/ide/inspections/RsUnresolvedReferenceInspectionBase$Companion\n*L\n374#1:431,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PathInfo processPath(@NotNull RsPath path, boolean searchForDocAliases) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            RsPathReference rsPathReference = path.getReference();
            if (rsPathReference == null) {
                return null;
            }
            RsPathReference reference = rsPathReference;
            RsPath rootPath = RsPathKt.rootPath(path);
            PsiElement rootPathParent = rootPath.getParent();
            if (!(!(rootPathParent instanceof RsMetaItem) || RsPossibleMacroCallKt.isMacroCall((RsPossibleMacroCall)rootPathParent) && ProcMacroApplicationService.Companion.isFullyEnabled())) {
                return null;
            }
            if (RsPathKt.isInsideDocLink(path)) {
                return null;
            }
            boolean isPathUnresolved = RsPathKt.getResolveStatus(path) != PathResolveStatus.RESOLVED;
            RsPath qualifier = RsPathKt.getQualifier(path);
            List contexts = new ArrayList();
            if (qualifier == null && isPathUnresolved) {
                AutoImportFixContext autoImportFix = AutoImportFix.Companion.findApplicableContext$default(AutoImportFix.Companion, path, null, searchForDocAliases, 2, null);
                if (autoImportFix != null) {
                    contexts.add(autoImportFix);
                }
                contexts.add(ConvertToPreludeMacroCall.INSTANCE);
                if (autoImportFix == null || autoImportFix.getCandidates().isEmpty()) {
                    contexts.add(AddCrateDependencyContext.INSTANCE);
                    contexts.add(AddRequiredFeaturesContext.INSTANCE);
                    contexts.add(ImportFromCrateContext.INSTANCE);
                    contexts.add(CreateUnresolvedSymbolContext.INSTANCE);
                }
            } else if (qualifier != null && isPathUnresolved) {
                String string = path.getReferenceName();
                if (string == null) {
                    return null;
                }
                String referenceName = string;
                AutoImportFixContext autoImportFixContext = AutoImportFix.Companion.findApplicableContext(qualifier, referenceName);
                if (autoImportFixContext == null) {
                    return null;
                }
                AutoImportFixContext context = autoImportFixContext;
                contexts.add(context);
                contexts.add(AddRequiredFeaturesContext.INSTANCE);
                contexts.add(CreateUnresolvedSymbolContext.INSTANCE);
            } else if (qualifier != null || path.getTypeQual() != null) {
                UnresolvedReferenceResolutionContext unresolvedReferenceResolutionContext = AutoImportFix.Companion.findApplicableContextForAssocItemPath(path);
                if (unresolvedReferenceResolutionContext != null) {
                    UnresolvedReferenceResolutionContext it2 = unresolvedReferenceResolutionContext;
                    boolean bl = false;
                    contexts.add(it2);
                }
            } else {
                boolean bl;
                block18: {
                    Iterable $this$any$iv = reference.rawMultiResolve();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            RsPathResolveResult it3 = (RsPathResolveResult)element$iv;
                            boolean bl2 = false;
                            if (!(it3.getVisibility() != VisibilityStatus.CfgDisabled && it3.getHasMissingCSelf())) continue;
                            bl = true;
                            break block18;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    contexts.add(AddCSelfContext.INSTANCE);
                }
            }
            return new PathInfo(isPathUnresolved, contexts);
        }

        public static /* synthetic */ PathInfo processPath$default(Companion companion, RsPath rsPath, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.processPath(rsPath, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/inspections/RsUnresolvedReferenceInspectionBase$Companion$PathInfo;", "", "isPathUnresolved", "", "contexts", "", "Lorg/rust/ide/inspections/import/UnresolvedReferenceResolutionContext;", "<init>", "(ZLjava/util/List;)V", "()Z", "getContexts", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class PathInfo {
            private final boolean isPathUnresolved;
            @NotNull
            private final List<UnresolvedReferenceResolutionContext> contexts;

            public PathInfo(boolean isPathUnresolved, @NotNull List<? extends UnresolvedReferenceResolutionContext> contexts) {
                Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
                this.isPathUnresolved = isPathUnresolved;
                this.contexts = contexts;
            }

            public final boolean isPathUnresolved() {
                return this.isPathUnresolved;
            }

            @NotNull
            public final List<UnresolvedReferenceResolutionContext> getContexts() {
                return this.contexts;
            }

            public final boolean component1() {
                return this.isPathUnresolved;
            }

            @NotNull
            public final List<UnresolvedReferenceResolutionContext> component2() {
                return this.contexts;
            }

            @NotNull
            public final PathInfo copy(boolean isPathUnresolved, @NotNull List<? extends UnresolvedReferenceResolutionContext> contexts) {
                Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
                return new PathInfo(isPathUnresolved, contexts);
            }

            public static /* synthetic */ PathInfo copy$default(PathInfo pathInfo, boolean bl, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = pathInfo.isPathUnresolved;
                }
                if ((n & 2) != 0) {
                    list = pathInfo.contexts;
                }
                return pathInfo.copy(bl, list);
            }

            @NotNull
            public String toString() {
                return "PathInfo(isPathUnresolved=" + this.isPathUnresolved + ", contexts=" + this.contexts + ")";
            }

            public int hashCode() {
                int result2 = Boolean.hashCode(this.isPathUnresolved);
                result2 = result2 * 31 + ((Object)this.contexts).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PathInfo)) {
                    return false;
                }
                PathInfo pathInfo = (PathInfo)other;
                if (this.isPathUnresolved != pathInfo.isPathUnresolved) {
                    return false;
                }
                return Intrinsics.areEqual(this.contexts, pathInfo.contexts);
            }
        }
    }
}

