/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsMembers;
import org.rust.lang.core.psi.RsSelfParameter;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsImplItemKt;
import org.rust.lang.core.psi.ext.RsTraitRefKt;
import org.rust.lang.core.psi.ext.TraitImplementationInfo;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/inspections/RsTraitImplementationInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkTraitFnImplParams", "", "fn", "Lorg/rust/lang/core/psi/RsFunction;", "superFn", "traitName", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsTraitImplementationInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder, this){
            final /* synthetic */ RsProblemsHolder $holder;
            final /* synthetic */ RsTraitImplementationInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void visitImplItem2(RsImplItem impl) {
                void $this$mapTo$iv$iv;
                Object object;
                Object $this$mapNotNullTo$iv$iv;
                Collection destination$iv$iv;
                Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
                RsTraitRef rsTraitRef = impl.getTraitRef();
                if (rsTraitRef == null) {
                    return;
                }
                RsTraitRef traitRef = rsTraitRef;
                RsTraitItem rsTraitItem = RsTraitRefKt.resolveToTrait(traitRef);
                if (rsTraitItem == null) {
                    return;
                }
                RsTraitItem trait = rsTraitItem;
                String string = trait.getName();
                if (string == null) {
                    return;
                }
                String traitName = string;
                TraitImplementationInfo traitImplementationInfo = TraitImplementationInfo.Companion.create(trait, impl);
                if (traitImplementationInfo == null) {
                    return;
                }
                TraitImplementationInfo implInfo = traitImplementationInfo;
                if (RsImplItemKt.getHasMissingItems(impl)) {
                    PsiElement $this$mapNotNull$iv;
                    Iterable iterable = implInfo.getMissingImplementations();
                    boolean bl = false;
                    void var9_11 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv$iv$iv.iterator();
                    while (object.hasNext()) {
                        String string2;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = object.next();
                        boolean bl2 = false;
                        RsAbstractable missing = (RsAbstractable)element$iv$iv;
                        boolean bl22 = false;
                        if (missing.getName() != null) {
                            String it2;
                            boolean bl3 = false;
                            string2 = "`" + it2 + "`";
                        } else {
                            string2 = null;
                        }
                        if (string2 == null) continue;
                        String it$iv$iv = string2;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    String missing = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                    RsMembers rsMembers = impl.getMembers();
                    if (rsMembers != null) {
                        RsMembers rsMembers2 = rsMembers;
                        $this$mapNotNullTo$iv$iv = this.$holder;
                        RsMembers members = rsMembers2;
                        boolean bl3 = false;
                        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.TraitItemsMissingImplInfo(members, missing), (RsProblemsHolder)$this$mapNotNullTo$iv$iv, false, null, 6, null);
                    }
                    PsiElement psiElement2 = impl.getImpl();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getImpl(...)");
                    RsTypeReference rsTypeReference = impl.getTypeReference();
                    $this$mapNotNull$iv = rsTypeReference != null ? (PsiElement)rsTypeReference : impl.getImpl();
                    Intrinsics.checkNotNull((Object)$this$mapNotNull$iv);
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.TraitItemsMissingImplError(psiElement2, $this$mapNotNull$iv, missing, impl), this.$holder, false, null, 6, null);
                }
                Iterable $this$mapToSet$iv = implInfo.getDeclared();
                boolean bl = false;
                $this$mapNotNullTo$iv$iv = $this$mapToSet$iv;
                destination$iv$iv = new HashSet<E>(org.rust.stdext.CollectionsKt.mapCapacity(org.rust.stdext.CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10)));
                boolean $i$f$mapTo = false;
                for (E item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    object = (RsAbstractable)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    String string3 = it3.getName();
                    Intrinsics.checkNotNull((Object)string3);
                    collection.add(string3);
                }
                Set traitMembersNames = (Set)destination$iv$iv;
                for (Map.Entry entry2 : implInfo.getImplementedByNameAndType().entrySet()) {
                    Pair key = (Pair)entry2.getKey();
                    RsAbstractable implMember = (RsAbstractable)entry2.getValue();
                    if (!Intrinsics.areEqual((Object)implMember.getContainingFile(), (Object)impl.getContainingFile())) continue;
                    String memberName = (String)key.getFirst();
                    if (traitMembersNames.contains(memberName)) {
                        PsiElement nameIdentifier;
                        RsAbstractable traitMember = implInfo.getDeclaredByNameAndType().get(key);
                        if (implMember instanceof RsFunction && traitMember instanceof RsFunction) {
                            RsTraitImplementationInspection.access$checkTraitFnImplParams(this.this$0, this.$holder, (RsFunction)implMember, (RsFunction)traitMember, traitName);
                        }
                        if (traitMember != null || implMember.getNameIdentifier() == null) continue;
                        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MismatchMemberInTraitImplError(nameIdentifier, implMember, traitName), this.$holder, false, null, 6, null);
                        continue;
                    }
                    PsiElement psiElement3 = implMember.getNameIdentifier();
                    Intrinsics.checkNotNull((Object)psiElement3);
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnknownMemberInTraitError(psiElement3, implMember, traitName), this.$holder, false, null, 6, null);
                }
            }
        };
    }

    private final void checkTraitFnImplParams(RsProblemsHolder holder, RsFunction fn, RsFunction superFn, String traitName) {
        RsValueParameterList rsValueParameterList = fn.getValueParameterList();
        if (rsValueParameterList == null) {
            return;
        }
        RsValueParameterList params = rsValueParameterList;
        RsSelfParameter selfArg = RsFunctionKt.getSelfParameter(fn);
        RsSelfParameter superSelfParameter = RsFunctionKt.getSelfParameter(superFn);
        if (selfArg != null && RsFunctionKt.getSelfParameter(superFn) == null) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.DeclMissingFromTraitError((PsiElement)selfArg, fn, superFn, selfArg), holder, false, null, 6, null);
        } else if (selfArg == null && superSelfParameter != null) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.DeclMissingFromImplError((PsiElement)params, fn, superFn, superSelfParameter), holder, false, null, 6, null);
        }
        int paramsCount = RsFunctionKt.getValueParameters(fn).size();
        int superParamsCount = RsFunctionKt.getValueParameters(superFn).size();
        if (paramsCount != superParamsCount) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.TraitParamCountMismatchError((PsiElement)params, fn, traitName, paramsCount, superParamsCount), holder, false, null, 6, null);
        }
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.NotAutoApplicable;
    }

    public static final /* synthetic */ void access$checkTraitFnImplParams(RsTraitImplementationInspection $this, RsProblemsHolder holder, RsFunction fn, RsFunction superFn, String traitName) {
        $this.checkTraitFnImplParams(holder, fn, superFn, traitName);
    }
}

