/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.SemVer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsReplaceWithThreadLocalStableMethodCall;
import org.rust.ide.inspections.RsThreadLocalStableMethodCanBeUsedInspectionKt;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsLambdaExprKt;
import org.rust.lang.core.resolve.KnownItemsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/inspections/RsThreadLocalStableMethodCanBeUsedInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "isApplicableTo", "", "file", "Lorg/rust/lang/core/psi/RsFile;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "isThreadLocalStableMethodAvailable", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsThreadLocalStableMethodCanBeUsedInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsThreadLocalStableMethodCanBeUsedInspection.kt\norg/rust/ide/inspections/RsThreadLocalStableMethodCanBeUsedInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1740#2,3:75\n*S KotlinDebug\n*F\n+ 1 RsThreadLocalStableMethodCanBeUsedInspection.kt\norg/rust/ide/inspections/RsThreadLocalStableMethodCanBeUsedInspection\n*L\n19#1:75,3\n*E\n"})
public final class RsThreadLocalStableMethodCanBeUsedInspection
extends RsLocalInspectionTool {
    @Override
    protected boolean isApplicableTo(@NotNull RsFile file) {
        block9: {
            block8: {
                boolean bl;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Project project = file.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Collection<CargoProject> allProjects = CargoProjectServiceKt.getCargoProjects(project).getAllProjects();
                    if (allProjects.isEmpty()) break block8;
                    Iterable $this$all$iv = allProjects;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            CargoProject p0 = (CargoProject)element$iv;
                            boolean bl2 = false;
                            if (this.isThreadLocalStableMethodAvailable(p0)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) break block9;
            }
            return false;
        }
        return super.isApplicableTo(file);
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitMethodCallExpr(RsMethodCallExpr o) {
                RsFunction withMethod;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsMethodCall rsMethodCall = o.getMethodCall();
                Intrinsics.checkNotNullExpressionValue((Object)rsMethodCall, (String)"getMethodCall(...)");
                RsMethodCall methodCall = rsMethodCall;
                RsElement rsElement = methodCall.getReference().resolve();
                RsFunction rsFunction = withMethod = rsElement instanceof RsFunction ? (RsFunction)rsElement : null;
                if (withMethod == null || !Intrinsics.areEqual((Object)withMethod, (Object)RsThreadLocalStableMethodCanBeUsedInspectionKt.access$getLocalKeyWith(KnownItemsKt.getKnownItems(o)))) {
                    return;
                }
                List<RsExpr> list = methodCall.getValueArgumentList().getExprList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
                Object object = CollectionsKt.singleOrNull(list);
                RsLambdaExpr rsLambdaExpr = object instanceof RsLambdaExpr ? (RsLambdaExpr)object : null;
                if (rsLambdaExpr == null) {
                    return;
                }
                RsLambdaExpr lambdaCall = rsLambdaExpr;
                RsExpr rsExpr = lambdaCall.getExpr();
                RsMethodCallExpr rsMethodCallExpr = rsExpr instanceof RsMethodCallExpr ? (RsMethodCallExpr)rsExpr : null;
                if (rsMethodCallExpr == null) {
                    return;
                }
                RsMethodCallExpr dotExprInsideLambda = rsMethodCallExpr;
                RsValueParameter rsValueParameter = (RsValueParameter)CollectionsKt.singleOrNull(RsLambdaExprKt.getValueParameters(lambdaCall));
                if (rsValueParameter == null) {
                    return;
                }
                RsValueParameter lambdaParameter = rsValueParameter;
                if (dotExprInsideLambda.getReceiver().textMatches(lambdaParameter.getText())) {
                    RsElement rsElement2 = dotExprInsideLambda.getMethodCall().getReference().resolve();
                    RsFunction rsFunction2 = rsElement2 instanceof RsFunction ? (RsFunction)rsElement2 : null;
                    if (rsFunction2 == null) {
                        return;
                    }
                    RsFunction threadLocalStableMethod = rsFunction2;
                    if (CollectionsKt.contains((Iterable)RsThreadLocalStableMethodCanBeUsedInspectionKt.access$getTHREAD_LOCAL_STABLE_METHODS_NAMES$p(), (Object)threadLocalStableMethod.getName())) {
                        String string = dotExprInsideLambda.getMethodCall().getValueArgumentList().getText();
                        if (string == null) {
                            string = "";
                        }
                        String valueArgumentListText = string;
                        String replaceText = o.getReceiver().getText() + "." + threadLocalStableMethod.getName() + valueArgumentListText;
                        PsiElement psiElement2 = methodCall.getIdentifier();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getIdentifier(...)");
                        Object[] objectArray = new Object[]{replaceText};
                        String string2 = RsBundle.INSTANCE.message("inspection.message.can.be.replaced.with", objectArray);
                        objectArray = new LocalQuickFix[]{new RsReplaceWithThreadLocalStableMethodCall(o, replaceText)};
                        this.$holder.registerProblem(psiElement2, string2, (LocalQuickFix[])objectArray);
                    }
                }
            }
        };
    }

    private final boolean isThreadLocalStableMethodAvailable(CargoProject cargoProject) {
        Object object = cargoProject.getRustcInfo();
        SemVer semver = object != null && (object = ((RustcInfo)object).getVersion()) != null ? ((RustcVersion)object).getSemver() : null;
        return semver != null && semver.compareTo(RsThreadLocalStableMethodCanBeUsedInspectionKt.access$getTHREAD_LOCAL_STABLE_METHODS_VERSION$p()) >= 0;
    }
}

