/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsReplaceFixBase;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsExprKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\f\u0010\u0013\u001a\u00020\u0005*\u00020\u0005H\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u0014\u0010\f\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/inspections/RsSuspiciousAssignmentInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isSyntaxOnly", "()Z", "isDumbAware", "distanceTo", "", "Lcom/intellij/psi/PsiElement;", "other", "compact", "findUnaryExpr", "Lorg/rust/lang/core/psi/RsUnaryExpr;", "el", "Lorg/rust/lang/core/psi/RsExpr;", "RsReplaceSuspiciousAssignmentFix", "Companion", "intellij.rustrover.core"})
public final class RsSuspiciousAssignmentInspection
extends RsLocalInspectionTool {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean isSyntaxOnly;
    @Deprecated
    public static final int LONG_TEXT_THRESHOLD = 10;
    @Deprecated
    @NotNull
    public static final String LONG_TEXT_SUBST = "..";

    public RsSuspiciousAssignmentInspection() {
        this.isSyntaxOnly = true;
    }

    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("suspicious.assignment", new Object[0]);
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsSuspiciousAssignmentInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitBinaryExpr(RsBinaryExpr expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                if (!Intrinsics.areEqual((Object)RsExprKt.getOperator(expr).getText(), (Object)"=")) {
                    return;
                }
                RsUnaryExpr unaryExpr = RsSuspiciousAssignmentInspection.access$findUnaryExpr(this.this$0, expr.getRight());
                if (unaryExpr == null || unaryExpr.getExpr() == null) {
                    return;
                }
                RsExpr unaryBody = unaryExpr.getExpr();
                char op = unaryExpr.getText().charAt(0);
                if (unaryBody != null && (op == '-' || op == '*' || op == '!') && RsSuspiciousAssignmentInspection.access$distanceTo(this.this$0, RsExprKt.getOperator(expr), unaryExpr) == 1 && RsSuspiciousAssignmentInspection.access$distanceTo(this.this$0, RsExprKt.getOperator(expr), unaryBody) > 2) {
                    int n = PsiElementKt.getStartOffset(unaryBody);
                    RsExpr rsExpr = expr.getLeft();
                    Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getLeft(...)");
                    int uExprOffset = n - PsiElementKt.getStartOffset(rsExpr);
                    String string = expr.getLeft().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String left = RsSuspiciousAssignmentInspection.access$compact(this.this$0, string);
                    String string2 = expr.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    String string3 = string2.substring(uExprOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    String right = RsSuspiciousAssignmentInspection.access$compact(this.this$0, string3);
                    String right2 = Intrinsics.areEqual((Object)right, (Object)"..") ? "(" + op + right + ")" : op + right;
                    String subst1 = left + " " + op + "= " + right;
                    String subst2 = left + " = " + right2;
                    RsExpr rsExpr2 = expr.getLeft();
                    Intrinsics.checkNotNullExpressionValue((Object)rsExpr2, (String)"getLeft(...)");
                    TextRange substRange = new TextRange(PsiElementKt.getEndOffset(rsExpr2), PsiElementKt.getStartOffset(unaryBody));
                    PsiFile file = expr.getContainingFile();
                    PsiElement psiElement2 = expr;
                    TextRange textRange = new TextRange(expr.getLeft().getText().length(), uExprOffset);
                    Object[] objectArray = new Object[]{subst1, subst2};
                    String string4 = RsBundle.INSTANCE.message("inspection.message.suspicious.assignment.did.you.mean.or", objectArray);
                    objectArray = new LocalQuickFix[2];
                    Intrinsics.checkNotNull((Object)file);
                    objectArray[0] = new RsReplaceSuspiciousAssignmentFix(subst1, file, substRange, " " + op + "= ");
                    objectArray[1] = new RsReplaceSuspiciousAssignmentFix(subst2, file, substRange, " = " + op);
                    RsProblemsHolder.registerProblem$default(this.$holder, psiElement2, textRange, string4, (LocalQuickFix[])objectArray, false, null, null, 112, null);
                }
            }
        };
    }

    @Override
    public boolean isSyntaxOnly() {
        return this.isSyntaxOnly;
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    private final int distanceTo(PsiElement $this$distanceTo, PsiElement other) {
        return PsiElementKt.getStartOffset(other) - PsiElementKt.getStartOffset($this$distanceTo);
    }

    private final String compact(String $this$compact) {
        return $this$compact.length() <= 10 ? $this$compact : LONG_TEXT_SUBST;
    }

    private final RsUnaryExpr findUnaryExpr(RsExpr el) {
        RsExpr rsExpr = el;
        return rsExpr instanceof RsUnaryExpr ? (RsUnaryExpr)el : (rsExpr instanceof RsBinaryExpr ? this.findUnaryExpr(((RsBinaryExpr)el).getLeft()) : null);
    }

    public static final /* synthetic */ RsUnaryExpr access$findUnaryExpr(RsSuspiciousAssignmentInspection $this, RsExpr el) {
        return $this.findUnaryExpr(el);
    }

    public static final /* synthetic */ int access$distanceTo(RsSuspiciousAssignmentInspection $this, PsiElement $receiver, PsiElement other) {
        return $this.distanceTo($receiver, other);
    }

    public static final /* synthetic */ String access$compact(RsSuspiciousAssignmentInspection $this, String $receiver) {
        return $this.compact($receiver);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/rust/ide/inspections/RsSuspiciousAssignmentInspection$Companion;", "", "<init>", "()V", "LONG_TEXT_THRESHOLD", "", "LONG_TEXT_SUBST", "", "intellij.rustrover.core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/inspections/RsSuspiciousAssignmentInspection$RsReplaceSuspiciousAssignmentFix;", "Lorg/rust/ide/fixes/RsReplaceFixBase;", "subst", "", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "text", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "intellij.rustrover.core"})
    private static final class RsReplaceSuspiciousAssignmentFix
    extends RsReplaceFixBase {
        public RsReplaceSuspiciousAssignmentFix(@NotNull String subst, @NotNull PsiFile file, @NotNull TextRange range, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)subst, (String)"subst");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Object[] objectArray = new Object[]{subst};
            super(RsBundle.INSTANCE.message("intention.name.change.to3", objectArray), file, range, text);
        }
    }
}

