/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsSortImplTraitMembersInspectionKt;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsVis;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsImplItemKt;
import org.rust.lang.core.psi.ext.RsTraitOrImpl;
import org.rust.lang.core.psi.ext.RsTraitOrImplKt;
import org.rust.lang.core.psi.ext.RsTraitRefKt;
import org.rust.lang.core.stubs.RsTraitRefStub;
import org.rust.openapiext.Testmark;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/rust/ide/inspections/RsSortImplTraitMembersInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "SortImplTraitMembersFix", "Testmarks", "intellij.rustrover.core"})
public final class RsSortImplTraitMembersInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitImplItem2(RsImplItem impl) {
                PsiElement psiElement2;
                Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
                StubBasedPsiElement<RsTraitRefStub> stubBasedPsiElement = impl.getTraitRef();
                if (stubBasedPsiElement == null || (stubBasedPsiElement = RsTraitRefKt.resolveToTrait(stubBasedPsiElement)) == null) {
                    return;
                }
                StubBasedPsiElement<RsTraitRefStub> trait = stubBasedPsiElement;
                RsTypeReference rsTypeReference = impl.getTypeReference();
                if (rsTypeReference == null) {
                    return;
                }
                RsTypeReference typeRef = rsTypeReference;
                if (RsSortImplTraitMembersInspectionKt.access$sortedImplItems(RsTraitOrImplKt.getExplicitMembers(impl), RsTraitOrImplKt.getExplicitMembers((RsTraitOrImpl)trait)) == null) {
                    return;
                }
                RsVis rsVis = impl.getVis();
                if (rsVis != null) {
                    psiElement2 = rsVis;
                } else {
                    psiElement2 = RsImplItemKt.getDefault(impl);
                    if (psiElement2 == null && (psiElement2 = impl.getUnsafe()) == null) {
                        psiElement2 = impl.getImpl();
                    }
                }
                TextRange textRange = new TextRange(psiElement2.getStartOffsetInParent(), typeRef.getStartOffsetInParent() + typeRef.getTextLength());
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SortImplTraitMembersFix(impl)};
                RsProblemsHolder.registerProblem$default(this.$holder, (PsiElement)impl, textRange, RsBundle.INSTANCE.message("inspection.message.different.impl.member.order.from.trait", new Object[0]), localQuickFixArray, false, null, null, 112, null);
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/inspections/RsSortImplTraitMembersInspection$SortImplTraitMembersFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsImplItem;", "element", "<init>", "(Lorg/rust/lang/core/psi/RsImplItem;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsSortImplTraitMembersInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsSortImplTraitMembersInspection.kt\norg/rust/ide/inspections/RsSortImplTraitMembersInspection$SortImplTraitMembersFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1878#2,3:75\n*S KotlinDebug\n*F\n+ 1 RsSortImplTraitMembersInspection.kt\norg/rust/ide/inspections/RsSortImplTraitMembersInspection$SortImplTraitMembersFix\n*L\n50#1:75,3\n*E\n"})
    private static final class SortImplTraitMembersFix
    extends RsQuickFixBase<RsImplItem> {
        public SortImplTraitMembersFix(@NotNull RsImplItem element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
        }

        @Override
        @NotNull
        public String getText() {
            return RsBundle.INSTANCE.message("intention.name.apply.same.member.order", new Object[0]);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsImplItem element) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            StubBasedPsiElement<RsTraitRefStub> stubBasedPsiElement = element.getTraitRef();
            if (stubBasedPsiElement == null || (stubBasedPsiElement = RsTraitRefKt.resolveToTrait(stubBasedPsiElement)) == null) {
                return;
            }
            StubBasedPsiElement<RsTraitRefStub> trait = stubBasedPsiElement;
            List<RsAbstractable> implItems = RsTraitOrImplKt.getExplicitMembers(element);
            List<RsAbstractable> traitItems = RsTraitOrImplKt.getExplicitMembers((RsTraitOrImpl)trait);
            List list = RsSortImplTraitMembersInspectionKt.access$sortedImplItems(implItems, traitItems);
            if (list == null) {
                return;
            }
            List sortedImplItems = list;
            Iterable $this$forEachIndexed$iv = CollectionsKt.zip((Iterable)implItems, (Iterable)sortedImplItems);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl = false;
                RsAbstractable implItem = (RsAbstractable)pair.component1();
                RsAbstractable expectedImplItem = (RsAbstractable)pair.component2();
                if (Intrinsics.areEqual((Object)RsSortImplTraitMembersInspectionKt.access$key(implItem), (Object)RsSortImplTraitMembersInspectionKt.access$key(expectedImplItem))) continue;
                implItem.replace(((RsAbstractable)sortedImplItems.get(index)).copy());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/rust/ide/inspections/RsSortImplTraitMembersInspection$Testmarks;", "", "<init>", "()V", "ImplMemberNotInTrait", "intellij.rustrover.core"})
    public static final class Testmarks {
        @NotNull
        public static final Testmarks INSTANCE = new Testmarks();

        private Testmarks() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/ide/inspections/RsSortImplTraitMembersInspection$Testmarks$ImplMemberNotInTrait;", "Lorg/rust/openapiext/Testmark;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class ImplMemberNotInTrait
        extends Testmark {
            @NotNull
            public static final ImplMemberNotInTrait INSTANCE = new ImplMemberNotInTrait();

            private ImplMemberNotInTrait() {
            }
        }
    }
}

