/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsSimplifyPrintInspectionKt;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsFormatMacroArgument;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsMacroCallKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/rust/ide/inspections/RsSimplifyPrintInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "RemoveUnnecessaryPrintlnArgument", "intellij.rustrover.core"})
public final class RsSimplifyPrintInspection
extends RsLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("println.usage", new Object[0]);
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitMacroCall2(RsMacroCall o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                String macroName = RsMacroCallKt.getMacroName(o);
                RsFormatMacroArgument rsFormatMacroArgument = o.getFormatMacroArgument();
                if (rsFormatMacroArgument == null) {
                    return;
                }
                RsFormatMacroArgument formatMacroArg = rsFormatMacroArgument;
                if (!StringsKt.endsWith$default((String)macroName, (String)"println", (boolean)false, (int)2, null)) {
                    return;
                }
                if (RsSimplifyPrintInspectionKt.access$emptyStringArg(formatMacroArg) == null) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveUnnecessaryPrintlnArgument(o)};
                this.$holder.registerProblem((PsiElement)o, RsBundle.INSTANCE.message("inspection.message.println.macro.invocation.can.be.simplified", new Object[0]), localQuickFixArray);
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\r\u0010\b\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/inspections/RsSimplifyPrintInspection$RemoveUnnecessaryPrintlnArgument;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsMacroCall;", "element", "<init>", "(Lorg/rust/lang/core/psi/RsMacroCall;)V", "getText", "", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
    private static final class RemoveUnnecessaryPrintlnArgument
    extends RsQuickFixBase<RsMacroCall> {
        public RemoveUnnecessaryPrintlnArgument(@NotNull RsMacroCall element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
        }

        @Override
        @NotNull
        public String getText() {
            return RsBundle.INSTANCE.message("intention.name.remove.unnecessary.argument", new Object[0]);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @Override
        public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsMacroCall element) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsFormatMacroArgument rsFormatMacroArgument = element.getFormatMacroArgument();
            Intrinsics.checkNotNull((Object)rsFormatMacroArgument);
            PsiElement psiElement2 = RsSimplifyPrintInspectionKt.access$emptyStringArg(rsFormatMacroArgument);
            if (psiElement2 == null) {
                return;
            }
            PsiElement arg = psiElement2;
            arg.delete();
        }
    }
}

