/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.SimplifyBooleanExpressionFix;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.utils.BooleanExprSimplifier;
import org.rust.ide.utils.ExprUtilsKt;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/rust/ide/inspections/RsSimplifyBooleanExpressionInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "intellij.rustrover.core"})
public final class RsSimplifyBooleanExpressionInspection
extends RsLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("intention.name.simplify.boolean.expression", new Object[0]);
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitExpr(RsExpr expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                if (Intrinsics.areEqual((Object)ExprUtilsKt.isPure(expr), (Object)true) && BooleanExprSimplifier.Companion.canBeSimplified(expr)) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SimplifyBooleanExpressionFix(expr)};
                    this.$holder.registerProblem((PsiElement)expr, RsBundle.INSTANCE.message("inspection.message.boolean.expression.can.be.simplified", new Object[0]), localQuickFixArray);
                }
            }
        };
    }
}

