/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.lints.RsUnnecessaryParenthesesInspection;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.openapiext.EditorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/inspections/RsRemoveDbgQuickFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsMacroCall;", "macroCall", "isOnTheFly", "", "<init>", "(Lorg/rust/lang/core/psi/RsMacroCall;Z)V", "()Z", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "intellij.rustrover.core"})
final class RsRemoveDbgQuickFix
extends RsQuickFixBase<RsMacroCall> {
    private final boolean isOnTheFly;

    public RsRemoveDbgQuickFix(@NotNull RsMacroCall macroCall, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)macroCall, (String)"macroCall");
        super((PsiElement)macroCall);
        this.isOnTheFly = isOnTheFly;
    }

    public final boolean isOnTheFly() {
        return this.isOnTheFly;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.name.remove.dbg", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsMacroCall element) {
        RsElement newExpr;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RsElement rsElement = element.getExprMacroArgument();
        if (rsElement == null || (rsElement = rsElement.getExpr()) == null) {
            return;
        }
        RsElement expr = rsElement;
        int cursorOffsetToExpr = editor2 != null ? Math.max(0, editor2.getCaretModel().getOffset() - PsiElementKt.getStartOffset(expr)) : -1;
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof RsExpr && RsUnnecessaryParenthesesInspection.Helper.INSTANCE.needParens((RsExpr)parent2, (RsExpr)expr)) {
            if (editor2 != null) {
                ++cursorOffsetToExpr;
            }
            v1 = RsMacroCallKt.replaceWithExpr(element, new RsPsiFactory(project, false, false, 6, null).createExpression("(" + expr.getText() + ")"));
        } else {
            v1 = newExpr = RsMacroCallKt.replaceWithExpr(element, (RsExpr)expr);
        }
        if (editor2 != null && this.isOnTheFly) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
            EditorKt.moveCaretToOffset(editor2, newExpr, Math.min(PsiElementKt.getStartOffset(newExpr) + cursorOffsetToExpr, PsiElementKt.getEndOffset(newExpr)));
        }
    }
}

