/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.MakePrivateFix;
import org.rust.ide.fixes.RemoveAttrFix;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.MakeAttributeMacroFix;
import org.rust.ide.inspections.MakeBangMacroFix;
import org.rust.ide.inspections.MakeDeriveMacroFix;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMacro;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsVis;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.psi.ext.RsMacroKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsVisibility;
import org.rust.lang.core.psi.ext.RsVisibilityKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/RsPublicItemsInProcMacroCrateInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsPublicItemsInProcMacroCrateInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitElement(RsElement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsElement rsElement = o;
                if (rsElement instanceof RsItemElement) {
                    this.handleItemElement((RsItemElement)o);
                } else if (rsElement instanceof RsMacro) {
                    this.handleMacro((RsMacro)o);
                }
            }

            private final void handleItemElement(RsItemElement item) {
                List list;
                RsVis rsVis = item.getVis();
                if (rsVis == null) {
                    return;
                }
                RsVis vis = rsVis;
                if (!Intrinsics.areEqual((Object)RsVisibilityKt.getVisibility(vis), (Object)RsVisibility.Public.INSTANCE)) {
                    return;
                }
                RsQuickFixBase[] rsQuickFixBaseArray = item.getContext();
                RsMod rsMod = rsQuickFixBaseArray instanceof RsMod ? (RsMod)rsQuickFixBaseArray : null;
                if (rsMod == null) {
                    return;
                }
                RsMod containingMod = rsMod;
                if (!containingMod.isCrateRoot()) {
                    return;
                }
                if (!containingMod.getContainingCrate().getKind().isProcMacro()) {
                    return;
                }
                if (item instanceof RsFunction && RsFunctionKt.isProcMacroDef((RsFunction)item)) {
                    return;
                }
                Collection collection = CollectionsKt.listOf((Object)((Object)new MakePrivateFix(item)));
                if (item instanceof RsFunction) {
                    rsQuickFixBaseArray = new RsQuickFixBase[]{new MakeDeriveMacroFix((RsFunction)item), new MakeAttributeMacroFix((RsFunction)item), new MakeBangMacroFix((RsFunction)item)};
                    list = CollectionsKt.listOf((Object[])rsQuickFixBaseArray);
                } else {
                    list = CollectionsKt.emptyList();
                }
                List fixes = CollectionsKt.plus((Collection)collection, (Iterable)list);
                PsiElement psiElement2 = vis;
                String string = RsBundle.INSTANCE.message("inspection.message.proc.macro.crates.can.export.only.functions", new Object[0]);
                Collection collection2 = fixes;
                Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                rsQuickFixBaseArray = (LocalQuickFix[])UtilKt.toArray((Collection)collection2, (Object[])LocalQuickFix.EMPTY_ARRAY);
                this.$holder.registerProblem(psiElement2, string, Arrays.copyOf(rsQuickFixBaseArray, rsQuickFixBaseArray.length));
            }

            private final void handleMacro(RsMacro macro) {
                if (!RsMacroKt.getHasMacroExport(macro)) {
                    return;
                }
                if (!macro.getContainingCrate().getKind().isProcMacro()) {
                    return;
                }
                RsMetaItem rsMetaItem = (RsMetaItem)SequencesKt.singleOrNull(RsDocAndAttributeOwnerKt.getQueryPsiAttributes(macro).attrsByName("macro_export"));
                if (rsMetaItem == null) {
                    return;
                }
                RsMetaItem metaItem = rsMetaItem;
                PsiElement $this$parentOfType_u24default$iv = metaItem;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                RsOuterAttr rsOuterAttr = (RsOuterAttr)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsOuterAttr.class, (boolean)true);
                if (rsOuterAttr == null) {
                    return;
                }
                RsOuterAttr attribute = rsOuterAttr;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveAttrFix(attribute)};
                this.$holder.registerProblem((PsiElement)attribute, RsBundle.INSTANCE.message("inspection.message.proc.macro.crates.can.export.only.functions", new Object[0]), localQuickFixArray);
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }
}

