/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.AddProcMacroFieldToCargoTomlFix;
import org.rust.ide.fixes.RemoveAttrFix;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.QueryAttributes;
import org.rust.lang.core.psi.ext.RsAttr;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsMetaItemKt;
import org.rust.toml.CrateExtKt;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/inspections/RsProcMacroAttrInNonProcMacroCrateInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "isApplicableTo", "", "file", "Lorg/rust/lang/core/psi/RsFile;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsProcMacroAttrInNonProcMacroCrateInspection
extends RsLocalInspectionTool {
    @Override
    protected boolean isApplicableTo(@NotNull RsFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return super.isApplicableTo(file) && !file.getContainingCrate().getKind().isProcMacro();
    }

    @Override
    @Nullable
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction2(RsFunction o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                QueryAttributes<RsMetaItem> attrs = RsDocAndAttributeOwnerKt.getQueryPsiAttributes(o);
                Sequence procMacroAttrs = SequencesKt.plus((Sequence)SequencesKt.plus(attrs.attrsByName("proc_macro"), attrs.attrsByName("proc_macro_attribute")), attrs.attrsByName("proc_macro_derive"));
                for (RsMetaItem procMacroAttr : procMacroAttrs) {
                    AddProcMacroFieldToCargoTomlFix addProcMacroFieldToCargoTomlFix;
                    RsAttr elementForHighlight;
                    RsQuickFixBase[] rsQuickFixBaseArray = procMacroAttr.getParent();
                    if ((rsQuickFixBaseArray instanceof RsAttr ? (RsAttr)rsQuickFixBaseArray : null) == null) continue;
                    elementForHighlight = elementForHighlight;
                    RsProblemsHolder rsProblemsHolder = this.$holder;
                    PsiElement psiElement2 = elementForHighlight;
                    Object[] objectArray = new Object[1];
                    String string = RsMetaItemKt.getName(procMacroAttr);
                    if (string == null) {
                        string = "";
                    }
                    objectArray[0] = string;
                    String string2 = RsBundle.INSTANCE.message("inspection.message.proc.macro.att.in.non.proc.macro.crate", objectArray);
                    rsQuickFixBaseArray = new RsQuickFixBase[2];
                    rsQuickFixBaseArray[0] = new RemoveAttrFix(elementForHighlight);
                    RsQuickFixBase[] rsQuickFixBaseArray2 = rsQuickFixBaseArray;
                    int n = 1;
                    if (CrateExtKt.getTomlFile(o.getContainingCrate()) != null) {
                        void it2;
                        int n2 = n;
                        RsQuickFixBase[] rsQuickFixBaseArray3 = rsQuickFixBaseArray2;
                        String string3 = string2;
                        PsiElement psiElement3 = psiElement2;
                        RsProblemsHolder rsProblemsHolder2 = rsProblemsHolder;
                        boolean bl = false;
                        AddProcMacroFieldToCargoTomlFix addProcMacroFieldToCargoTomlFix2 = new AddProcMacroFieldToCargoTomlFix((TomlFile)it2, o.getContainingCrate().getPresentableName());
                        rsProblemsHolder = rsProblemsHolder2;
                        psiElement2 = psiElement3;
                        string2 = string3;
                        rsQuickFixBaseArray2 = rsQuickFixBaseArray3;
                        n = n2;
                        addProcMacroFieldToCargoTomlFix = addProcMacroFieldToCargoTomlFix2;
                    } else {
                        addProcMacroFieldToCargoTomlFix = null;
                    }
                    rsQuickFixBaseArray2[n] = addProcMacroFieldToCargoTomlFix;
                    Collection collection = CollectionsKt.listOfNotNull((Object[])rsQuickFixBaseArray);
                    Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    objectArray = (LocalQuickFix[])UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
                    rsProblemsHolder.registerProblem(psiElement2, string2, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
                }
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }
}

