/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsLocalInspectionToolKt;
import org.rust.ide.statistics.IntentionPlace;
import org.rust.ide.utils.ShowInMacroBehavior;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.utils.InlineInspectionMessage;
import org.rust.lang.utils.RangeSpecifier;
import org.rust.lang.utils.RsProblemGroup;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001JB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!\u00a2\u0006\u0002\u0010\"JH\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!2\r\b\u0002\u0010%\u001a\u00070\u001e\u00a2\u0006\u0002\b&\u00a2\u0006\u0002\u0010'Jw\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010\u001e2\u0006\u0010)\u001a\u00020\u00172\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!2\b\b\u0002\u0010*\u001a\u00020+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\n\b\u0001\u00100\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u00101JS\u0010\u0019\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u0002042\u000b\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b52\u0006\u0010#\u001a\u00020$2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!2\r\b\u0002\u0010%\u001a\u00070\u001e\u00a2\u0006\u0002\b&\u00a2\u0006\u0002\u00106Jv\u0010\u0019\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u0002042\u000b\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b52\u0006\u0010#\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!2\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010*\u001a\u00020+2\u0006\u0010.\u001a\u00020/2\n\b\u0003\u00100\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u00107J\\\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\b\b\u0001\u00108\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!2\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010*\u001a\u00020+2\r\b\u0002\u00109\u001a\u00070\u001e\u00a2\u0006\u0002\b&\u00a2\u0006\u0002\u0010:JU\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u00108\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!2\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0003\u0010%\u001a\u00020\u001e\u00a2\u0006\u0002\u0010;J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020=2\u0006\u0010.\u001a\u00020/J\u0010\u0010>\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010?\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J(\u0010@\u001a\u0004\u0018\u00010A*\u00020\u001c2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0002J'\u0010B\u001a\b\u0012\u0004\u0012\u00020!0 *\n\u0012\u0006\b\u0001\u0012\u00020!0 2\u0006\u0010C\u001a\u00020AH\u0002\u00a2\u0006\u0002\u0010DJ\u001d\u0010E\u001a\u00020\u001a2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 H\u0002\u00a2\u0006\u0002\u0010FJ%\u0010G\u001a\u00020\u001a2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 2\u0006\u0010H\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010IR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006K"}, d2={"Lorg/rust/ide/inspections/RsProblemsHolder;", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "inspection", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lorg/rust/ide/inspections/RsLocalInspectionTool;)V", "getInspection", "()Lorg/rust/ide/inspections/RsLocalInspectionTool;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "getManager", "()Lcom/intellij/codeInspection/InspectionManager;", "file", "Lcom/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "isOnTheFly", "", "()Z", "registerProblem", "", "element", "Lcom/intellij/psi/PsiElement;", "descriptionTemplate", "", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "inlineDescription", "Lorg/rust/lang/utils/InlineInspectionMessage;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;[Lcom/intellij/codeInspection/LocalQuickFix;Ljava/lang/String;)V", "reportingToolName", "checkExistsAfterExpansion", "showInMacro", "Lorg/rust/ide/utils/ShowInMacroBehavior;", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "problemGroup", "Lorg/rust/lang/utils/RsProblemGroup;", "tooltip", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;Ljava/lang/String;Z[Lcom/intellij/codeInspection/LocalQuickFix;Lorg/rust/ide/utils/ShowInMacroBehavior;Lcom/intellij/openapi/util/TextRange;Lorg/rust/lang/utils/RsProblemGroup;Ljava/lang/String;)V", "startElement", "rangeSpecifier", "Lorg/rust/lang/utils/RangeSpecifier;", "Lcom/intellij/codeInspection/util/InspectionMessage;", "(Lcom/intellij/psi/PsiElement;Lorg/rust/lang/utils/RangeSpecifier;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;[Lcom/intellij/codeInspection/LocalQuickFix;Ljava/lang/String;)V", "(Lcom/intellij/psi/PsiElement;Lorg/rust/lang/utils/RangeSpecifier;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;Ljava/lang/String;[Lcom/intellij/codeInspection/LocalQuickFix;ZLorg/rust/ide/utils/ShowInMacroBehavior;Lorg/rust/lang/utils/RsProblemGroup;Ljava/lang/String;)V", "message", "inlineMessage", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;[Lcom/intellij/codeInspection/LocalQuickFix;ZLorg/rust/ide/utils/ShowInMacroBehavior;Ljava/lang/String;)V", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;Lcom/intellij/openapi/util/TextRange;[Lcom/intellij/codeInspection/LocalQuickFix;ZLjava/lang/String;)V", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "isProblemWithTypeAllowed", "shouldHighlightMacroIdentifier", "findElementAndRangeExpandedFrom", "Lorg/rust/ide/inspections/RsProblemsHolder$SourceElementWithRange;", "filterSupportingMacros", "mapped", "([Lcom/intellij/codeInspection/LocalQuickFix;Lorg/rust/ide/inspections/RsProblemsHolder$SourceElementWithRange;)[Lcom/intellij/codeInspection/LocalQuickFix;", "setFixesLocationNotMacro", "([Lcom/intellij/codeInspection/LocalQuickFix;)V", "setFixesLocationInsideMacro", "isDeeplyAttrMacro", "([Lcom/intellij/codeInspection/LocalQuickFix;Z)V", "SourceElementWithRange", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsLocalInspectionTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLocalInspectionTool.kt\norg/rust/ide/inspections/RsProblemsHolder\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,570:1\n323#2,5:571\n323#2,5:576\n310#2,5:581\n310#2,5:586\n1#3:591\n4225#4,11:592\n37#5,2:603\n*S KotlinDebug\n*F\n+ 1 RsLocalInspectionTool.kt\norg/rust/ide/inspections/RsProblemsHolder\n*L\n150#1:571,5\n201#1:576,5\n232#1:581,5\n357#1:586,5\n519#1:592,11\n519#1:603,2\n*E\n"})
public final class RsProblemsHolder {
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final RsLocalInspectionTool inspection;

    public RsProblemsHolder(@NotNull ProblemsHolder holder, @NotNull RsLocalInspectionTool inspection) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)((Object)inspection), (String)"inspection");
        this.holder = holder;
        this.inspection = inspection;
    }

    @NotNull
    public final RsLocalInspectionTool getInspection() {
        return this.inspection;
    }

    @NotNull
    public final InspectionManager getManager() {
        InspectionManager inspectionManager = this.holder.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionManager, (String)"getManager(...)");
        return inspectionManager;
    }

    @NotNull
    public final PsiFile getFile() {
        PsiFile psiFile = this.holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        return psiFile;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    public final boolean isOnTheFly() {
        return this.holder.isOnTheFly();
    }

    public final void registerProblem(@NotNull PsiElement element, @InspectionMessage @NotNull String descriptionTemplate, LocalQuickFix ... fixes) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)descriptionTemplate, (String)"descriptionTemplate");
        Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project) || CfgUtilsKt.getExistsAfterExpansion(element)) {
            if (Intrinsics.areEqual((Object)element.getContainingFile(), (Object)this.getFile())) {
                this.setFixesLocationNotMacro(fixes);
                ProblemDescriptor problemDescriptor = this.getManager().createProblemDescriptor(element, descriptionTemplate, this.holder.isOnTheFly(), fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor descriptor = problemDescriptor;
                descriptor.setProblemGroup((ProblemGroup)RsProblemGroup.Companion.create(descriptionTemplate, null, null));
                this.holder.registerProblem(descriptor);
            } else {
                SourceElementWithRange sourceElementWithRange = RsProblemsHolder.findElementAndRangeExpandedFrom$default(this, element, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, ShowInMacroBehavior.OnlyIfMappedToMacroCallBody, 2, null);
                if (sourceElementWithRange == null) {
                    return;
                }
                SourceElementWithRange mapped = sourceElementWithRange;
                if (!Intrinsics.areEqual((Object)mapped.getSourceElement().getContainingFile(), (Object)this.getFile())) {
                    return;
                }
                this.setFixesLocationInsideMacro(fixes, mapped.isDeeplyAttrMacro());
                if (PsiElementKt.getStartOffset(mapped.getSourceElement()) >= PsiElementKt.getEndOffset(mapped.getSourceElement()) && !(mapped.getSourceElement() instanceof RsFile)) {
                    boolean $i$f$weakAssert = false;
                    if (UtilsKt.isUnitTestMode() || UtilsKt.isInternal()) {
                        boolean bl = false;
                        if (!false) {
                            boolean bl2 = false;
                            String message$iv = "Empty element passed to registerProblem: " + element;
                            throw new AssertionError((Object)message$iv);
                        }
                    }
                    return;
                }
                ProblemDescriptor problemDescriptor = this.getManager().createProblemDescriptor(mapped.getSourceElement(), mapped.getSourceRangeInElement(), descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.holder.isOnTheFly(), Arrays.copyOf(fixes, fixes.length));
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor descriptor = problemDescriptor;
                descriptor.setProblemGroup((ProblemGroup)RsProblemGroup.Companion.create(descriptionTemplate, null, null));
                this.holder.registerProblem(descriptor);
            }
        }
    }

    public final void registerProblem(@NotNull PsiElement element, @InspectionMessage @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @NotNull LocalQuickFix[] fixes, @NotNull String inlineDescription) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)descriptionTemplate, (String)"descriptionTemplate");
        Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
        Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
        Intrinsics.checkNotNullParameter((Object)inlineDescription, (String)"inlineDescription");
        RsProblemsHolder.registerProblem$default(this, element, descriptionTemplate, highlightType, null, true, Arrays.copyOf(fixes, fixes.length), ShowInMacroBehavior.OnlyIfMappedToMacroCallBody, null, RsProblemGroup.Companion.create(inlineDescription, null, null), null, 128, null);
    }

    public static /* synthetic */ void registerProblem$default(RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, String string, ProblemHighlightType problemHighlightType, LocalQuickFix[] localQuickFixArray, String string2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = string;
        }
        rsProblemsHolder.registerProblem(psiElement2, string, problemHighlightType, localQuickFixArray, string2);
    }

    private final void registerProblem(PsiElement element, @InspectionMessage String descriptionTemplate, ProblemHighlightType highlightType, String reportingToolName, boolean checkExistsAfterExpansion, LocalQuickFix[] fixes, ShowInMacroBehavior showInMacro, TextRange rangeInElement, RsProblemGroup problemGroup, @NlsContexts.Tooltip String tooltip) {
        block16: {
            block15: {
                if (!checkExistsAfterExpansion) break block15;
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!DumbService.Companion.isDumb(project) && !CfgUtilsKt.getExistsAfterExpansion(element)) break block16;
            }
            if (this.isProblemWithTypeAllowed(highlightType)) {
                ProblemDescriptor problemDescriptor;
                if (PsiElementKt.getStartOffset(element) >= PsiElementKt.getEndOffset(element) && !(element instanceof RsFile)) {
                    boolean $i$f$weakAssert = false;
                    if (UtilsKt.isUnitTestMode() || UtilsKt.isInternal()) {
                        boolean bl = false;
                        if (!false) {
                            boolean bl2 = false;
                            String message$iv = "Empty element passed to registerProblem: " + element;
                            throw new AssertionError((Object)message$iv);
                        }
                    }
                    return;
                }
                if (Intrinsics.areEqual((Object)element.getContainingFile(), (Object)this.getFile())) {
                    this.setFixesLocationNotMacro(fixes);
                    problemDescriptor = this.getManager().createProblemDescriptor(element, descriptionTemplate, this.holder.isOnTheFly(), fixes, highlightType);
                } else {
                    SourceElementWithRange mapped;
                    SourceElementWithRange sourceElementWithRange = mapped = rangeInElement == null ? RsProblemsHolder.findElementAndRangeExpandedFrom$default(this, element, highlightType, null, showInMacro, 2, null) : this.findElementAndRangeExpandedFrom(element, highlightType, rangeInElement, showInMacro);
                    if (mapped == null) {
                        return;
                    }
                    if (!Intrinsics.areEqual((Object)mapped.getSourceElement().getContainingFile(), (Object)this.getFile())) {
                        return;
                    }
                    this.setFixesLocationInsideMacro(fixes, mapped.isDeeplyAttrMacro());
                    LocalQuickFix[] localQuickFixArray = this.filterSupportingMacros(fixes, mapped);
                    problemDescriptor = this.getManager().createProblemDescriptor(mapped.getSourceElement(), mapped.getSourceRangeInElement(), descriptionTemplate, highlightType, this.holder.isOnTheFly(), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
                ProblemDescriptor bl2 = problemDescriptor;
                Intrinsics.checkNotNull((Object)bl2);
                ProblemDescriptor descriptor = bl2;
                if (descriptor instanceof ProblemDescriptorBase && reportingToolName != null) {
                    boolean $i$f$testAssert = false;
                    if (UtilsKt.isUnitTestMode()) {
                        boolean bl = false;
                        if (!(tooltip != null)) {
                            boolean bl3 = false;
                            String message$iv = "Both tooltip and reportingToolName are provided! It is unsupported scenario. Please support it.";
                            throw new AssertionError((Object)message$iv);
                        }
                    }
                    descriptor = (ProblemDescriptor)new ProblemDescriptorWithReporterName((ProblemDescriptorBase)descriptor, reportingToolName);
                }
                if (problemGroup != null) {
                    descriptor.setProblemGroup((ProblemGroup)problemGroup);
                }
                this.holder.registerProblem(RsLocalInspectionToolKt.access$withTooltip(descriptor, tooltip));
            }
        }
    }

    static /* synthetic */ void registerProblem$default(RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, String string, ProblemHighlightType problemHighlightType, String string2, boolean bl, LocalQuickFix[] localQuickFixArray, ShowInMacroBehavior showInMacroBehavior, TextRange textRange, RsProblemGroup rsProblemGroup, String string3, int n, Object object) {
        if ((n & 0x40) != 0) {
            showInMacroBehavior = ShowInMacroBehavior.OnlyIfMappedToMacroCallBody;
        }
        if ((n & 0x80) != 0) {
            textRange = null;
        }
        rsProblemsHolder.registerProblem(psiElement2, string, problemHighlightType, string2, bl, localQuickFixArray, showInMacroBehavior, textRange, rsProblemGroup, string3);
    }

    public final void registerProblem(@NotNull PsiElement startElement, @NotNull RangeSpecifier rangeSpecifier, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @NotNull LocalQuickFix[] fixes, @NotNull String inlineDescription) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)rangeSpecifier, (String)"rangeSpecifier");
        Intrinsics.checkNotNullParameter((Object)descriptionTemplate, (String)"descriptionTemplate");
        Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
        Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
        Intrinsics.checkNotNullParameter((Object)inlineDescription, (String)"inlineDescription");
        ShowInMacroBehavior showInMacroBehavior = ShowInMacroBehavior.OnlyIfMappedToMacroCallBody;
        LocalQuickFix[] localQuickFixArray = Arrays.copyOf(fixes, fixes.length);
        RsProblemGroup rsProblemGroup = RsProblemGroup.Companion.create(inlineDescription, null, null);
        RsProblemsHolder.registerProblem$default(this, startElement, rangeSpecifier, descriptionTemplate, highlightType, null, localQuickFixArray, true, showInMacroBehavior, rsProblemGroup, null, 512, null);
    }

    public static /* synthetic */ void registerProblem$default(RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, RangeSpecifier rangeSpecifier, String string, ProblemHighlightType problemHighlightType, LocalQuickFix[] localQuickFixArray, String string2, int n, Object object) {
        if ((n & 0x20) != 0) {
            string2 = string;
        }
        rsProblemsHolder.registerProblem(psiElement2, rangeSpecifier, string, problemHighlightType, localQuickFixArray, string2);
    }

    public final void registerProblem(@NotNull PsiElement startElement, @NotNull RangeSpecifier rangeSpecifier, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable String reportingToolName, @NotNull LocalQuickFix[] fixes, boolean checkExistsAfterExpansion, @NotNull ShowInMacroBehavior showInMacro, @NotNull RsProblemGroup problemGroup, @NlsContexts.Tooltip @Nullable String tooltip) {
        block19: {
            PsiElement endElement;
            block18: {
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)rangeSpecifier, (String)"rangeSpecifier");
                Intrinsics.checkNotNullParameter((Object)descriptionTemplate, (String)"descriptionTemplate");
                Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
                Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
                Intrinsics.checkNotNullParameter((Object)((Object)showInMacro), (String)"showInMacro");
                Intrinsics.checkNotNullParameter((Object)problemGroup, (String)"problemGroup");
                RangeSpecifier rangeSpecifier2 = rangeSpecifier;
                if (rangeSpecifier2 instanceof RangeSpecifier.Full) {
                    RsProblemsHolder.registerProblem$default(this, startElement, descriptionTemplate, highlightType, reportingToolName, checkExistsAfterExpansion, Arrays.copyOf(fixes, fixes.length), showInMacro, null, problemGroup, tooltip, 128, null);
                    return;
                }
                if (rangeSpecifier2 instanceof RangeSpecifier.RangeInElement) {
                    this.registerProblem(startElement, descriptionTemplate, highlightType, reportingToolName, checkExistsAfterExpansion, Arrays.copyOf(fixes, fixes.length), showInMacro, ((RangeSpecifier.RangeInElement)rangeSpecifier).getRange(), problemGroup, tooltip);
                    return;
                }
                if (rangeSpecifier2 instanceof RangeSpecifier.EndElement) {
                    if (Intrinsics.areEqual((Object)((RangeSpecifier.EndElement)rangeSpecifier).getElement(), (Object)startElement)) {
                        RsProblemsHolder.registerProblem$default(this, startElement, descriptionTemplate, highlightType, reportingToolName, checkExistsAfterExpansion, Arrays.copyOf(fixes, fixes.length), showInMacro, null, problemGroup, tooltip, 128, null);
                        return;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                endElement = ((RangeSpecifier.EndElement)rangeSpecifier).getElement();
                if (!checkExistsAfterExpansion) break block18;
                Project project = startElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!DumbService.Companion.isDumb(project) && !CfgUtilsKt.getExistsAfterExpansion(startElement)) break block19;
            }
            if (this.isProblemWithTypeAllowed(highlightType)) {
                ProblemDescriptor problemDescriptor;
                if (Intrinsics.areEqual((Object)startElement.getContainingFile(), (Object)this.getFile())) {
                    this.setFixesLocationNotMacro(fixes);
                    problemDescriptor = this.holder.getManager().createProblemDescriptor(startElement, endElement, descriptionTemplate, highlightType, this.holder.isOnTheFly(), Arrays.copyOf(fixes, fixes.length));
                } else {
                    PsiElement psiElement2 = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
                    if (psiElement2 == null) {
                        return;
                    }
                    PsiElement commonAncestor = psiElement2;
                    TextRange textRange = new TextRange(PsiElementKt.getStartOffset(startElement), PsiElementKt.getEndOffset(endElement)).shiftLeft(PsiElementKt.getStartOffset(commonAncestor));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
                    SourceElementWithRange sourceElementWithRange = this.findElementAndRangeExpandedFrom(commonAncestor, highlightType, textRange, showInMacro);
                    if (sourceElementWithRange == null) {
                        return;
                    }
                    SourceElementWithRange mapped = sourceElementWithRange;
                    if (!Intrinsics.areEqual((Object)mapped.getSourceElement().getContainingFile(), (Object)this.getFile())) {
                        return;
                    }
                    this.setFixesLocationInsideMacro(fixes, mapped.isDeeplyAttrMacro());
                    LocalQuickFix[] localQuickFixArray = this.filterSupportingMacros(fixes, mapped);
                    problemDescriptor = this.holder.getManager().createProblemDescriptor(mapped.getSourceElement(), mapped.getSourceRangeInElement(), descriptionTemplate, highlightType, this.holder.isOnTheFly(), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
                ProblemDescriptor problemDescriptor2 = problemDescriptor;
                Intrinsics.checkNotNull((Object)problemDescriptor2);
                ProblemDescriptor descriptor = problemDescriptor2;
                if (descriptor instanceof ProblemDescriptorBase && reportingToolName != null) {
                    boolean $i$f$testAssert = false;
                    if (UtilsKt.isUnitTestMode()) {
                        boolean bl = false;
                        if (!(tooltip != null)) {
                            boolean bl2 = false;
                            String message$iv = "Both tooltip and reportingToolName are provided! It is unsupported scenario. Please support it.";
                            throw new AssertionError((Object)message$iv);
                        }
                    }
                    descriptor = (ProblemDescriptor)new ProblemDescriptorWithReporterName((ProblemDescriptorBase)descriptor, reportingToolName);
                }
                descriptor.setProblemGroup((ProblemGroup)problemGroup);
                this.holder.registerProblem(RsLocalInspectionToolKt.access$withTooltip(descriptor, tooltip));
            }
        }
    }

    public static /* synthetic */ void registerProblem$default(RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, RangeSpecifier rangeSpecifier, String string, ProblemHighlightType problemHighlightType, String string2, LocalQuickFix[] localQuickFixArray, boolean bl, ShowInMacroBehavior showInMacroBehavior, RsProblemGroup rsProblemGroup, String string3, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = true;
        }
        if ((n & 0x80) != 0) {
            showInMacroBehavior = ShowInMacroBehavior.OnlyIfMappedToMacroCallBody;
        }
        if ((n & 0x200) != 0) {
            string3 = null;
        }
        rsProblemsHolder.registerProblem(psiElement2, rangeSpecifier, string, problemHighlightType, string2, localQuickFixArray, bl, showInMacroBehavior, rsProblemGroup, string3);
    }

    public final void registerProblem(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @InspectionMessage @NotNull String message, @NotNull LocalQuickFix[] fixes, boolean checkExistsAfterExpansion, @NotNull ShowInMacroBehavior showInMacro, @NotNull String inlineMessage) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)rangeInElement, (String)"rangeInElement");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
                Intrinsics.checkNotNullParameter((Object)((Object)showInMacro), (String)"showInMacro");
                Intrinsics.checkNotNullParameter((Object)inlineMessage, (String)"inlineMessage");
                if (!checkExistsAfterExpansion) break block7;
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!DumbService.Companion.isDumb(project) && !CfgUtilsKt.getExistsAfterExpansion(element)) break block8;
            }
            if (Intrinsics.areEqual((Object)element.getContainingFile(), (Object)this.getFile())) {
                this.setFixesLocationNotMacro(fixes);
                ProblemDescriptor problemDescriptor = this.holder.getManager().createProblemDescriptor(element, rangeInElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.holder.isOnTheFly(), Arrays.copyOf(fixes, fixes.length));
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor descriptor = problemDescriptor;
                descriptor.setProblemGroup((ProblemGroup)RsProblemGroup.Companion.create(inlineMessage, null, null));
                this.holder.registerProblem(descriptor);
            } else {
                SourceElementWithRange sourceElementWithRange = this.findElementAndRangeExpandedFrom(element, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, rangeInElement, showInMacro);
                if (sourceElementWithRange == null) {
                    return;
                }
                SourceElementWithRange mapped = sourceElementWithRange;
                if (!Intrinsics.areEqual((Object)mapped.getSourceElement().getContainingFile(), (Object)this.getFile())) {
                    return;
                }
                this.setFixesLocationInsideMacro(fixes, mapped.isDeeplyAttrMacro());
                LocalQuickFix[] localQuickFixArray = this.filterSupportingMacros(fixes, mapped);
                ProblemDescriptor problemDescriptor = this.holder.getManager().createProblemDescriptor(mapped.getSourceElement(), mapped.getSourceRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.holder.isOnTheFly(), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor descriptor = problemDescriptor;
                descriptor.setProblemGroup((ProblemGroup)RsProblemGroup.Companion.create(inlineMessage, null, null));
                this.holder.registerProblem(descriptor);
            }
        }
    }

    public static /* synthetic */ void registerProblem$default(RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, TextRange textRange, String string, LocalQuickFix[] localQuickFixArray, boolean bl, ShowInMacroBehavior showInMacroBehavior, String string2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            showInMacroBehavior = ShowInMacroBehavior.OnlyIfMappedToMacroCallBody;
        }
        if ((n & 0x40) != 0) {
            string2 = string;
        }
        rsProblemsHolder.registerProblem(psiElement2, textRange, string, localQuickFixArray, bl, showInMacroBehavior, string2);
    }

    public final void registerProblem(@NotNull PsiElement element, @InspectionMessage @NotNull String message, @NotNull ProblemHighlightType highlightType, @NotNull TextRange rangeInElement, @NotNull LocalQuickFix[] fixes, boolean checkExistsAfterExpansion, @InlineInspectionMessage @NotNull String inlineDescription) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
                Intrinsics.checkNotNullParameter((Object)rangeInElement, (String)"rangeInElement");
                Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
                Intrinsics.checkNotNullParameter((Object)inlineDescription, (String)"inlineDescription");
                if (!checkExistsAfterExpansion) break block8;
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!DumbService.Companion.isDumb(project) && !CfgUtilsKt.getExistsAfterExpansion(element)) break block9;
            }
            if (this.isProblemWithTypeAllowed(highlightType)) {
                if (Intrinsics.areEqual((Object)element.getContainingFile(), (Object)this.getFile())) {
                    this.setFixesLocationNotMacro(fixes);
                    ProblemDescriptor problemDescriptor = this.getManager().createProblemDescriptor(element, rangeInElement, message, highlightType, this.holder.isOnTheFly(), Arrays.copyOf(fixes, fixes.length));
                    Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                    ProblemDescriptor descriptor = problemDescriptor;
                    descriptor.setProblemGroup((ProblemGroup)RsProblemGroup.Companion.create(inlineDescription, null, null));
                    this.holder.registerProblem(descriptor);
                } else {
                    SourceElementWithRange sourceElementWithRange = this.findElementAndRangeExpandedFrom(element, highlightType, rangeInElement, ShowInMacroBehavior.OnlyIfMappedToMacroCallBody);
                    if (sourceElementWithRange == null) {
                        return;
                    }
                    SourceElementWithRange mapped = sourceElementWithRange;
                    if (!Intrinsics.areEqual((Object)mapped.getSourceElement().getContainingFile(), (Object)this.getFile())) {
                        return;
                    }
                    this.setFixesLocationInsideMacro(fixes, mapped.isDeeplyAttrMacro());
                    LocalQuickFix[] localQuickFixArray = this.filterSupportingMacros(fixes, mapped);
                    ProblemDescriptor problemDescriptor = this.getManager().createProblemDescriptor(mapped.getSourceElement(), mapped.getSourceRangeInElement(), message, highlightType, this.holder.isOnTheFly(), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                    ProblemDescriptor descriptor = problemDescriptor;
                    descriptor.setProblemGroup((ProblemGroup)RsProblemGroup.Companion.create(inlineDescription, null, null));
                    this.holder.registerProblem(descriptor);
                }
            }
        }
    }

    public static /* synthetic */ void registerProblem$default(RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, String string, ProblemHighlightType problemHighlightType, TextRange textRange, LocalQuickFix[] localQuickFixArray, boolean bl, String string2, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        if ((n & 0x40) != 0) {
            string2 = string;
        }
        rsProblemsHolder.registerProblem(psiElement2, string, problemHighlightType, textRange, localQuickFixArray, bl, string2);
    }

    public final void registerProblem(@NotNull ProblemDescriptor descriptor, @NotNull RsProblemGroup problemGroup) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)problemGroup, (String)"problemGroup");
        descriptor.setProblemGroup((ProblemGroup)problemGroup);
        this.holder.registerProblem(descriptor);
    }

    private final boolean isProblemWithTypeAllowed(ProblemHighlightType highlightType) {
        return highlightType != ProblemHighlightType.INFORMATION || this.holder.isOnTheFly();
    }

    private final boolean shouldHighlightMacroIdentifier(ProblemHighlightType highlightType) {
        if (!Registry.Companion.is("org.rust.lang.highlight.error.macro.ident")) {
            return false;
        }
        return highlightType == ProblemHighlightType.GENERIC_ERROR_OR_WARNING || highlightType == ProblemHighlightType.GENERIC_ERROR || highlightType == ProblemHighlightType.ERROR || highlightType == ProblemHighlightType.WARNING;
    }

    private final SourceElementWithRange findElementAndRangeExpandedFrom(PsiElement $this$findElementAndRangeExpandedFrom, ProblemHighlightType highlightType, TextRange rangeInElement, ShowInMacroBehavior showInMacro) {
        Object v6;
        TextRange sourceRange;
        boolean isAttrMacro;
        block11: {
            RsPossibleMacroCall rsPossibleMacroCall = RsExpandedElementKt.findMacroCallExpandedFromNonRecursive($this$findElementAndRangeExpandedFrom);
            if (rsPossibleMacroCall == null) {
                return null;
            }
            RsPossibleMacroCall macroCall = rsPossibleMacroCall;
            isAttrMacro = macroCall instanceof RsMetaItem;
            PsiElement leaf = RsExpandedElementKt.findElementExpandedFrom$default($this$findElementAndRangeExpandedFrom, false, 1, null);
            if (leaf == null) {
                SourceElementWithRange sourceElementWithRange;
                boolean shouldShow;
                boolean bl = shouldShow = showInMacro == ShowInMacroBehavior.Always || showInMacro == ShowInMacroBehavior.AlwaysInFunctionLikeMacro && !isAttrMacro;
                if (!shouldShow && !this.shouldHighlightMacroIdentifier(highlightType)) {
                    return null;
                }
                RsPath rsPath = macroCall.getPath();
                if (rsPath == null) {
                    return null;
                }
                RsPath macroCallPath = rsPath;
                if (RsExpandedElementKt.isExpandedFromMacro(macroCall)) {
                    SourceElementWithRange sourceElementWithRange2 = RsProblemsHolder.findElementAndRangeExpandedFrom$default(this, macroCallPath, highlightType, null, showInMacro, 2, null);
                    if (sourceElementWithRange2 != null) {
                        SourceElementWithRange it2 = sourceElementWithRange2;
                        boolean bl2 = false;
                        sourceElementWithRange = SourceElementWithRange.copy$default(it2, null, null, it2.isDeeplyAttrMacro() && isAttrMacro, false, 11, null);
                    } else {
                        sourceElementWithRange = null;
                    }
                } else {
                    sourceElementWithRange = new SourceElementWithRange(macroCallPath, new TextRange(0, macroCallPath.getTextLength()), isAttrMacro, false, 8, null);
                }
                SourceElementWithRange sourceElementWithRange3 = sourceElementWithRange;
                return sourceElementWithRange3 != null ? SourceElementWithRange.copy$default(sourceElementWithRange3, null, null, false, true, 7, null) : null;
            }
            TextRange textRange = rangeInElement.shiftRight(PsiElementKt.getStartOffset($this$findElementAndRangeExpandedFrom));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
            TextRange textRange2 = (TextRange)CollectionsKt.singleOrNull(RsExpandedElementKt.mapRangeFromExpansionToCallBody(macroCall, textRange));
            if (textRange2 == null) {
                return null;
            }
            sourceRange = textRange2;
            Sequence<PsiElement> sequence2 = PsiElementKt.getAncestors(leaf);
            for (Object e : sequence2) {
                PsiElement it3 = (PsiElement)e;
                boolean bl = false;
                if (!it3.getTextRange().contains(sourceRange)) continue;
                v6 = e;
                break block11;
            }
            v6 = null;
        }
        PsiElement psiElement2 = v6;
        if (psiElement2 == null) {
            return null;
        }
        PsiElement sourceElement = psiElement2;
        TextRange textRange = sourceRange.shiftLeft(PsiElementKt.getStartOffset(sourceElement));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
        return new SourceElementWithRange(sourceElement, textRange, isAttrMacro, false, 8, null);
    }

    static /* synthetic */ SourceElementWithRange findElementAndRangeExpandedFrom$default(RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, ProblemHighlightType problemHighlightType, TextRange textRange, ShowInMacroBehavior showInMacroBehavior, int n, Object object) {
        if ((n & 2) != 0) {
            textRange = new TextRange(0, psiElement2.getTextLength());
        }
        return rsProblemsHolder.findElementAndRangeExpandedFrom(psiElement2, problemHighlightType, textRange, showInMacroBehavior);
    }

    /*
     * WARNING - void declaration
     */
    private final LocalQuickFix[] filterSupportingMacros(LocalQuickFix[] $this$filterSupportingMacros, SourceElementWithRange mapped) {
        void $this$filterIsInstanceTo$iv$iv;
        if (mapped.getMappedToMacroCallIdentifier()) {
            Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (!this.isOnTheFly()) {
            Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] $this$filterIsInstance$iv = $this$filterSupportingMacros;
        boolean $i$f$filterIsInstance = false;
        LocalQuickFix[] localQuickFixArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RsQuickFixBase)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new LocalQuickFix[0]);
    }

    private final void setFixesLocationNotMacro(LocalQuickFix[] fixes) {
        for (LocalQuickFix fix : fixes) {
            if (!(fix instanceof RsQuickFixBase)) continue;
            ((RsQuickFixBase)fix).setPlace(IntentionPlace.NO_MACRO);
        }
    }

    private final void setFixesLocationInsideMacro(LocalQuickFix[] fixes, boolean isDeeplyAttrMacro) {
        IntentionPlace place = isDeeplyAttrMacro ? IntentionPlace.ATTR_MACRO : IntentionPlace.BANG_MACRO;
        for (LocalQuickFix fix : fixes) {
            if (!(fix instanceof RsQuickFixBase)) continue;
            ((RsQuickFixBase)fix).setPlace(place);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/rust/ide/inspections/RsProblemsHolder$SourceElementWithRange;", "", "sourceElement", "Lcom/intellij/psi/PsiElement;", "sourceRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "isDeeplyAttrMacro", "", "mappedToMacroCallIdentifier", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;ZZ)V", "getSourceElement", "()Lcom/intellij/psi/PsiElement;", "getSourceRangeInElement", "()Lcom/intellij/openapi/util/TextRange;", "()Z", "getMappedToMacroCallIdentifier", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    private static final class SourceElementWithRange {
        @NotNull
        private final PsiElement sourceElement;
        @NotNull
        private final TextRange sourceRangeInElement;
        private final boolean isDeeplyAttrMacro;
        private final boolean mappedToMacroCallIdentifier;

        public SourceElementWithRange(@NotNull PsiElement sourceElement, @NotNull TextRange sourceRangeInElement, boolean isDeeplyAttrMacro, boolean mappedToMacroCallIdentifier) {
            Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
            Intrinsics.checkNotNullParameter((Object)sourceRangeInElement, (String)"sourceRangeInElement");
            this.sourceElement = sourceElement;
            this.sourceRangeInElement = sourceRangeInElement;
            this.isDeeplyAttrMacro = isDeeplyAttrMacro;
            this.mappedToMacroCallIdentifier = mappedToMacroCallIdentifier;
        }

        public /* synthetic */ SourceElementWithRange(PsiElement psiElement2, TextRange textRange, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl2 = false;
            }
            this(psiElement2, textRange, bl, bl2);
        }

        @NotNull
        public final PsiElement getSourceElement() {
            return this.sourceElement;
        }

        @NotNull
        public final TextRange getSourceRangeInElement() {
            return this.sourceRangeInElement;
        }

        public final boolean isDeeplyAttrMacro() {
            return this.isDeeplyAttrMacro;
        }

        public final boolean getMappedToMacroCallIdentifier() {
            return this.mappedToMacroCallIdentifier;
        }

        @NotNull
        public final PsiElement component1() {
            return this.sourceElement;
        }

        @NotNull
        public final TextRange component2() {
            return this.sourceRangeInElement;
        }

        public final boolean component3() {
            return this.isDeeplyAttrMacro;
        }

        public final boolean component4() {
            return this.mappedToMacroCallIdentifier;
        }

        @NotNull
        public final SourceElementWithRange copy(@NotNull PsiElement sourceElement, @NotNull TextRange sourceRangeInElement, boolean isDeeplyAttrMacro, boolean mappedToMacroCallIdentifier) {
            Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
            Intrinsics.checkNotNullParameter((Object)sourceRangeInElement, (String)"sourceRangeInElement");
            return new SourceElementWithRange(sourceElement, sourceRangeInElement, isDeeplyAttrMacro, mappedToMacroCallIdentifier);
        }

        public static /* synthetic */ SourceElementWithRange copy$default(SourceElementWithRange sourceElementWithRange, PsiElement psiElement2, TextRange textRange, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement2 = sourceElementWithRange.sourceElement;
            }
            if ((n & 2) != 0) {
                textRange = sourceElementWithRange.sourceRangeInElement;
            }
            if ((n & 4) != 0) {
                bl = sourceElementWithRange.isDeeplyAttrMacro;
            }
            if ((n & 8) != 0) {
                bl2 = sourceElementWithRange.mappedToMacroCallIdentifier;
            }
            return sourceElementWithRange.copy(psiElement2, textRange, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "SourceElementWithRange(sourceElement=" + this.sourceElement + ", sourceRangeInElement=" + this.sourceRangeInElement + ", isDeeplyAttrMacro=" + this.isDeeplyAttrMacro + ", mappedToMacroCallIdentifier=" + this.mappedToMacroCallIdentifier + ")";
        }

        public int hashCode() {
            int result2 = this.sourceElement.hashCode();
            result2 = result2 * 31 + this.sourceRangeInElement.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isDeeplyAttrMacro);
            result2 = result2 * 31 + Boolean.hashCode(this.mappedToMacroCallIdentifier);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceElementWithRange)) {
                return false;
            }
            SourceElementWithRange sourceElementWithRange = (SourceElementWithRange)other;
            if (!Intrinsics.areEqual((Object)this.sourceElement, (Object)sourceElementWithRange.sourceElement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sourceRangeInElement, (Object)sourceElementWithRange.sourceRangeInElement)) {
                return false;
            }
            if (this.isDeeplyAttrMacro != sourceElementWithRange.isDeeplyAttrMacro) {
                return false;
            }
            return this.mappedToMacroCallIdentifier == sourceElementWithRange.mappedToMacroCallIdentifier;
        }
    }
}

