/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.RsInsertElseFix;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsMissingElseInspection;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u0004\u0018\u00010\r*\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/inspections/RsMissingElseInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "extractIf", "Lorg/rust/lang/core/psi/RsIfExpr;", "Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
public final class RsMissingElseInspection
extends RsLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("missing.else", new Object[0]);
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsMissingElseInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitExprStmt(RsExprStmt expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                RsIfExpr rsIfExpr = RsMissingElseInspection.access$extractIf(this.this$0, expr);
                if (rsIfExpr == null) {
                    return;
                }
                RsIfExpr firstIf = rsIfExpr;
                RsIfExpr rsIfExpr2 = RsMissingElseInspection.access$extractIf(this.this$0, (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile(PsiElementKt.getRightSiblings(expr), buildVisitor.1::visitExprStmt$lambda$0)));
                if (rsIfExpr2 == null) {
                    return;
                }
                RsIfExpr nextIf = rsIfExpr2;
                RsElement rsElement = nextIf.getCondition();
                if (rsElement == null || (rsElement = rsElement.getExpr()) == null) {
                    return;
                }
                RsElement conditionExpr = rsElement;
                int rangeStart = expr.getStartOffsetInParent() + firstIf.getTextLength();
                int rangeLen = PsiElementKt.getStartOffset(conditionExpr) - PsiElementKt.getStartOffset(firstIf) - firstIf.getTextLength();
                PsiElement psiElement2 = expr.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RsInsertElseFix(nextIf, "else ")};
                RsProblemsHolder.registerProblem$default(this.$holder, psiElement2, new TextRange(rangeStart, rangeStart + rangeLen), RsBundle.INSTANCE.message("inspection.message.suspicious.if.did.you.mean.else.if", new Object[0]), localQuickFixArray, false, null, null, 112, null);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static final boolean visitExprStmt$lambda$0(PsiElement it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                if (!(it2 instanceof PsiWhiteSpace)) {
                    if (!(it2 instanceof PsiComment)) return false;
                }
                String string = it2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) return false;
                return true;
            }
        };
    }

    private final RsIfExpr extractIf(PsiElement $this$extractIf) {
        PsiElement psiElement2 = $this$extractIf;
        return psiElement2 instanceof RsIfExpr ? (RsIfExpr)$this$extractIf : (psiElement2 instanceof RsExprStmt ? this.extractIf(((RsExprStmt)$this$extractIf).getFirstChild()) : null);
    }

    public static final /* synthetic */ RsIfExpr access$extractIf(RsMissingElseInspection $this, PsiElement $receiver) {
        return $this.extractIf($receiver);
    }
}

