/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.MissingCargoFeaturesUtil;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.ide.injected.RsDoctestLanguageInjectorKt;
import org.rust.ide.injected.RsMacroDefinitionInjectorKt;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0010\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/rust/ide/inspections/RsLocalInspectionTool;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/openapi/project/PossiblyDumbAware;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isDumbAware", "Lorg/rust/lang/core/psi/RsVisitor;", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isSyntaxOnly", "()Z", "isApplicableTo", "file", "Lorg/rust/lang/core/psi/RsFile;", "isEnabled", "element", "Lcom/intellij/psi/PsiElement;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsLocalInspectionTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLocalInspectionTool.kt\norg/rust/ide/inspections/RsLocalInspectionTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,570:1\n1#2:571\n*E\n"})
public abstract class RsLocalInspectionTool
extends LocalInspectionTool
implements PossiblyDumbAware {
    private final boolean isSyntaxOnly;
    @NotNull
    private final AutoApplicabilityForFullLine useInFullLine = AutoApplicabilityForFullLine.NotSuitable;

    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        PsiFile psiFile = session2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (file instanceof RsFile && this.isApplicableTo((RsFile)file)) {
            PsiElementVisitor psiElementVisitor2 = super.buildVisitor(holder, isOnTheFly, session2);
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        } else {
            PsiElementVisitor psiElementVisitor3 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor3);
            psiElementVisitor = psiElementVisitor3;
        }
        return psiElementVisitor;
    }

    public boolean isDumbAware() {
        if (super.isDumbAware()) {
            return true;
        }
        return this.isSyntaxOnly();
    }

    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        RsVisitor rsVisitor = this.buildVisitor(new RsProblemsHolder(holder, this), isOnTheFly);
        if (rsVisitor != null) {
            psiElementVisitor = rsVisitor;
        } else {
            PsiElementVisitor psiElementVisitor2 = super.buildVisitor(holder, isOnTheFly);
            psiElementVisitor = psiElementVisitor2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"buildVisitor(...)");
        }
        return psiElementVisitor;
    }

    @Nullable
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return null;
    }

    public boolean isSyntaxOnly() {
        return this.isSyntaxOnly;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isApplicableTo(@NotNull RsFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (RsMacroDefinitionInjectorKt.isMacroInjection((PsiFile)file)) {
            return false;
        }
        if (RsDoctestLanguageInjectorKt.isDoctestInjection(file) && !Registry.Companion.is("rust.enabled.inspections.in.doc.comments")) {
            return false;
        }
        if (this.isSyntaxOnly()) {
            return true;
        }
        if (!file.isDeeplyEnabledByCfg()) {
            return false;
        }
        if (UtilsKt.isUnitTestMode()) {
            return true;
        }
        if (file.getCargoWorkspace() == null) return false;
        CargoProject cargoProject = file.getCargoProject();
        Object object = cargoProject;
        if (cargoProject == null) return false;
        RustcInfo rustcInfo = object.getRustcInfo();
        object = rustcInfo;
        if (rustcInfo == null) return false;
        RsToolchainBase rsToolchainBase = ((RustcInfo)object).getToolchain();
        if (rsToolchainBase == null) return false;
        if (file.getCrateRoot() == null) return false;
        CargoWorkspace.Target target = file.getCrate().getCargoTarget();
        if (target == null) return true;
        CargoWorkspace.Target it2 = target;
        boolean bl = false;
        if (MissingCargoFeaturesUtil.INSTANCE.collectMissingFeatureForTarget(it2).isEmpty()) return true;
        return false;
    }

    public final boolean isEnabled(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        if (PsiElementKt.isFullLineCompletionCopy(psiFile)) {
            return true;
        }
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)element.getProject());
        InspectionProfileImpl inspectionProfileImpl = inspectionProjectProfileManager.getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfile inspectionProfile = (InspectionProfile)inspectionProfileImpl;
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.findById((String)this.getID());
        return inspectionProfile.isToolEnabled(highlightDisplayKey);
    }

    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return this.useInFullLine;
    }
}

