/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.fixes.ConvertTypeReferenceFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.lang.core.psi.RsLetDecl;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsNamedFieldDecl;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsStructLiteralField;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyInteger;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;
import org.rust.lang.utils.evaluation.ConstExprEvaluatorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/RsLiteralOutOfRangeInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsLiteralOutOfRangeInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitLitExpr(RsLitExpr expr) {
                long value;
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                Ty expectedTy = ExtensionsKt.getType(expr);
                if (!(expectedTy instanceof TyInteger) || expectedTy instanceof TyInteger.U128 || expectedTy instanceof TyInteger.I128 || expectedTy instanceof TyInteger.I32 || expectedTy instanceof TyInteger.U64 || expectedTy instanceof TyInteger.I64 || expectedTy instanceof TyInteger.USize) {
                    return;
                }
                RsLiteralKind rsLiteralKind = RsLiteralKindKt.getKind(expr);
                RsLiteralKind.Integer integer = rsLiteralKind instanceof RsLiteralKind.Integer ? (RsLiteralKind.Integer)rsLiteralKind : null;
                if (integer == null) {
                    return;
                }
                RsLiteralKind.Integer literal = integer;
                PsiElement psiElement2 = expr.getContext();
                RsUnaryExpr rsUnaryExpr = psiElement2 instanceof RsUnaryExpr ? (RsUnaryExpr)psiElement2 : null;
                boolean isNegative = (rsUnaryExpr != null ? rsUnaryExpr.getMinus() : null) != null;
                Long l = literal.getValue();
                if (l != null) {
                    value = ((Number)l).longValue();
                    boolean bl = false;
                } else {
                    return;
                }
                long numericValue = isNegative ? -value : value;
                LongRange longRange = ConstExprEvaluatorKt.getValidValuesRange((TyInteger)expectedTy);
                long l2 = longRange.getFirst();
                if (!(numericValue <= longRange.getLast() ? l2 <= numericValue : false)) {
                    LocalQuickFix fix = this.findQuickFix(expr, (TyInteger)expectedTy, numericValue);
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.LiteralOutOfRange((PsiElement)expr, String.valueOf(numericValue), TypeRenderingKt.render$default(expectedTy, null, 0, null, null, null, null, null, null, null, false, false, false, false, false, false, false, null, 131071, null), fix), this.$holder, false, null, 6, null);
                }
            }

            private final LocalQuickFix findQuickFix(RsLitExpr expr, TyInteger currentType, long overflownValue) {
                TyInteger tyInteger = this.findTypeUpgrade(currentType, overflownValue);
                if (tyInteger == null) {
                    return null;
                }
                TyInteger proposedTy = tyInteger;
                PsiElement parent2 = expr.getContext();
                if (parent2 instanceof RsLetDecl) {
                    RsPat rsPat = ((RsLetDecl)parent2).getPat();
                    RsPatIdent rsPatIdent = rsPat instanceof RsPatIdent ? (RsPatIdent)rsPat : null;
                    if (rsPatIdent == null) {
                        return null;
                    }
                    RsPatIdent pat = rsPatIdent;
                    RsTypeReference rsTypeReference = ((RsLetDecl)parent2).getTypeReference();
                    if (rsTypeReference == null) {
                        return null;
                    }
                    RsTypeReference typeReference = rsTypeReference;
                    String string = pat.getPatBinding().getIdentifier().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    return new ConvertTypeReferenceFix(typeReference, string, proposedTy);
                }
                if (parent2 instanceof RsStructLiteralField) {
                    RsElement rsElement = ((RsStructLiteralField)parent2).getReference().resolve();
                    RsNamedFieldDecl rsNamedFieldDecl = rsElement instanceof RsNamedFieldDecl ? (RsNamedFieldDecl)rsElement : null;
                    if (rsNamedFieldDecl == null) {
                        return null;
                    }
                    RsNamedFieldDecl fieldDec = rsNamedFieldDecl;
                    RsTypeReference rsTypeReference = fieldDec.getTypeReference();
                    if (rsTypeReference == null) {
                        return null;
                    }
                    RsTypeReference typeReference = rsTypeReference;
                    if (fieldDec.getContainingCrate().getOrigin() != PackageOrigin.WORKSPACE) {
                        return null;
                    }
                    String string = fieldDec.getIdentifier().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    return new ConvertTypeReferenceFix(typeReference, string, proposedTy);
                }
                return null;
            }

            private final TyInteger findTypeUpgrade(TyInteger currentType, long overflownValue) {
                Object v1;
                block1: {
                    int i2 = TyInteger.Companion.getNAMES().indexOf(currentType.getName());
                    Iterable $this$firstOrNull$iv = CollectionsKt.drop((Iterable)TyInteger.Companion.getVALUES(), (int)i2);
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        TyInteger it2 = (TyInteger)element$iv;
                        boolean bl = false;
                        LongRange longRange = ConstExprEvaluatorKt.getValidValuesRange(it2);
                        long l = longRange.getFirst();
                        boolean bl2 = overflownValue <= longRange.getLast() ? l <= overflownValue : false;
                        if (!bl2) continue;
                        v1 = element$iv;
                        break block1;
                    }
                    v1 = null;
                }
                return v1;
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }
}

