/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.FoldableElement;
import org.rust.ide.inspections.RsLiftInspectionKt;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsElseBranch;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsMatchExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsRetExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMatchExprKt;
import org.rust.openapiext.Testmark;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u001c\u0010\r\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\n\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/inspections/RsLiftInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isSyntaxOnly", "()Z", "isDumbAware", "register", "", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "keyword", "Lcom/intellij/psi/PsiElement;", "LiftReturnOutFix", "Testmarks", "intellij.rustrover.core"})
public final class RsLiftInspection
extends RsLocalInspectionTool {
    private final boolean isSyntaxOnly;

    public RsLiftInspection() {
        this.isSyntaxOnly = true;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsLiftInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitIfExpr(RsIfExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (o.getParent() instanceof RsElseBranch) {
                    return;
                }
                RsExpr rsExpr = o;
                PsiElement psiElement2 = o.getIf();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getIf(...)");
                this.checkExpr(rsExpr, psiElement2);
            }

            public void visitMatchExpr(RsMatchExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsExpr rsExpr = o;
                PsiElement psiElement2 = o.getMatch();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getMatch(...)");
                this.checkExpr(rsExpr, psiElement2);
            }

            private final void checkExpr(RsExpr e, PsiElement keyword) {
                if (RsLiftInspectionKt.access$getHasFoldableReturns(e)) {
                    RsLiftInspection.access$register(this.this$0, this.$holder, e, keyword);
                }
            }
        };
    }

    @Override
    public boolean isSyntaxOnly() {
        return this.isSyntaxOnly;
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    private final void register(RsProblemsHolder $this$register, RsExpr expr, PsiElement keyword) {
        String keywordName = keyword.getText();
        PsiElement psiElement2 = expr;
        TextRange textRange = keyword.getTextRangeInParent();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRangeInParent(...)");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)keywordName);
        objectArray[0] = keywordName;
        String string = RsBundle.INSTANCE.message("inspection.message.return.can.be.lifted.out", objectArray);
        objectArray = new LocalQuickFix[]{new LiftReturnOutFix(expr, keywordName)};
        RsProblemsHolder.registerProblem$default($this$register, psiElement2, textRange, string, (LocalQuickFix[])objectArray, false, null, null, 112, null);
    }

    public static final /* synthetic */ void access$register(RsLiftInspection $this, RsProblemsHolder $receiver, RsExpr expr, PsiElement keyword) {
        $this.register($receiver, expr, keyword);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/inspections/RsLiftInspection$LiftReturnOutFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsExpr;", "element", "keyword", "", "<init>", "(Lorg/rust/lang/core/psi/RsExpr;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "addCommaIfNeeded", "Lorg/rust/lang/core/psi/RsMatchArm;", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsLiftInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLiftInspection.kt\norg/rust/ide/inspections/RsLiftInspection$LiftReturnOutFix\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,150:1\n9#2:151\n*S KotlinDebug\n*F\n+ 1 RsLiftInspection.kt\norg/rust/ide/inspections/RsLiftInspection$LiftReturnOutFix\n*L\n75#1:151\n*E\n"})
    private static final class LiftReturnOutFix
    extends RsQuickFixBase<RsExpr> {
        @NotNull
        private final String keyword;

        public LiftReturnOutFix(@NotNull RsExpr element, @NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            super((PsiElement)element);
            this.keyword = keyword;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return RsBundle.INSTANCE.message("intention.family.name.lift.return", new Object[0]);
        }

        @Override
        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.keyword};
            return RsBundle.INSTANCE.message("intention.name.lift.return.out", objectArray);
        }

        @Override
        public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsExpr element) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            List list = RsLiftInspectionKt.access$getFoldableReturns(element);
            if (list == null) {
                return;
            }
            List foldableReturns = list;
            RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
            for (FoldableElement foldableReturn : foldableReturns) {
                RsElement rsElement = foldableReturn.getElementToReplace();
                String string = foldableReturn.getExpr().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                RsLiftInspectionKt.access$replaceWithTailExpr(rsElement, factory2.createExpression(string));
            }
            PsiElement parent2 = element.getContext();
            if (!(parent2 instanceof RsRetExpr)) {
                RsMatchArm rsMatchArm = parent2 instanceof RsMatchArm ? (RsMatchArm)parent2 : null;
                if (rsMatchArm != null) {
                    this.addCommaIfNeeded(rsMatchArm, factory2);
                }
                String string = element.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                element.replace(factory2.createRetExpr(string));
            } else {
                Testmarks.InsideRetExpr.INSTANCE.hit();
            }
        }

        private final void addCommaIfNeeded(RsMatchArm $this$addCommaIfNeeded, RsPsiFactory psiFactory) {
            if ($this$addCommaIfNeeded.getComma() != null) {
                return;
            }
            PsiElement $this$ancestorStrict$iv = $this$addCommaIfNeeded;
            boolean $i$f$ancestorStrict = false;
            Object object = (RsMatchExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsMatchExpr.class, (boolean)true);
            if (object == null || (object = RsMatchExprKt.getArms((RsMatchExpr)object)) == null) {
                return;
            }
            Object arms = object;
            int index = arms.indexOf($this$addCommaIfNeeded);
            if (index == -1 || index == arms.size() - 1) {
                return;
            }
            $this$addCommaIfNeeded.add(psiFactory.createComma());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/rust/ide/inspections/RsLiftInspection$Testmarks;", "", "<init>", "()V", "InsideRetExpr", "intellij.rustrover.core"})
    public static final class Testmarks {
        @NotNull
        public static final Testmarks INSTANCE = new Testmarks();

        private Testmarks() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/ide/inspections/RsLiftInspection$Testmarks$InsideRetExpr;", "Lorg/rust/openapiext/Testmark;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class InsideRetExpr
        extends Testmark {
            @NotNull
            public static final InsideRetExpr INSTANCE = new InsideRetExpr();

            private InsideRetExpr() {
            }
        }
    }
}

