/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.ide.fixes.AddCommaFix;
import org.rust.ide.fixes.AddSemicolonFix;
import org.rust.ide.fixes.ReplaceMacroBindingKind;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.macros.decl.FragmentKind;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsMacro2MatchLikeBody;
import org.rust.lang.core.psi.RsMacroBinding;
import org.rust.lang.core.psi.RsMacroBody;
import org.rust.lang.core.psi.RsMacroCase;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsMacroBindingKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/RsInvalidMacroDefinitionInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsInvalidMacroDefinitionInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        CargoWorkspace.Edition edition = RsElementKt.getContainingCrate((PsiElement)holder.getFile()).getEdition();
        return new RsWithMacrosInspectionVisitor(holder, edition){
            final /* synthetic */ RsProblemsHolder $holder;
            final /* synthetic */ CargoWorkspace.Edition $edition;
            {
                this.$holder = $holder;
                this.$edition = $edition;
            }

            public void visitMacroBinding(RsMacroBinding o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                FragmentKind fragment = RsMacroBindingKt.getFragmentKind(o);
                PsiElement identifier = o.getIdentifier();
                if (identifier != null && fragment == null) {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)identifier.getText(), (String)"getText(...)");
                    this.$holder.registerProblem(identifier, RsBundle.INSTANCE.message("inspection.invalid.macro.def.invalid.fragment.description", objectArray), new LocalQuickFix[0]);
                    return;
                }
                if (fragment == FragmentKind.Pat && this.$edition.compareTo((Enum)CargoWorkspace.Edition.EDITION_2021) >= 0) {
                    PsiElement psiElement2 = PsiElementExtensionsKt.getNextNonCommentSibling(o);
                    if (psiElement2 == null) {
                        return;
                    }
                    PsiElement nextSibling = psiElement2;
                    if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(nextSibling), (Object)RsElementTypes.OR)) {
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceMacroBindingKind(o, FragmentKind.PatParam)};
                        this.$holder.registerProblem(nextSibling, RsBundle.INSTANCE.message("inspection.invalid.macro.def.or.not.allowed.after.pat.description", new Object[0]), localQuickFixArray);
                    }
                }
            }

            public void visitMacroBody(RsMacroBody o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                List<RsMacroCase> list = o.getMacroCaseList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getMacroCaseList(...)");
                for (RsMacroCase rsMacroCase : CollectionsKt.dropLast(list, (int)1)) {
                    PsiElement psiElement2 = PsiElementExtensionsKt.getNextNonCommentSibling(rsMacroCase);
                    if (Intrinsics.areEqual((Object)(psiElement2 != null ? PsiElementExtensionsKt.getElementType(psiElement2) : null), (Object)RsElementTypes.SEMICOLON)) continue;
                    Intrinsics.checkNotNull((Object)rsMacroCase);
                    Object[] objectArray = new Object[]{";"};
                    String string = RsBundle.INSTANCE.message("inspection.invalid.macro.def.missing.semicolon.or.comma.description", objectArray);
                    objectArray = new LocalQuickFix[]{new AddSemicolonFix(rsMacroCase)};
                    this.$holder.registerProblem(PsiTreeUtilKt.lastLeaf((PsiElement)rsMacroCase), string, (LocalQuickFix[])objectArray);
                }
            }

            public void visitMacro2MatchLikeBody(RsMacro2MatchLikeBody o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                List<RsMacroCase> list = o.getMacroCaseList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getMacroCaseList(...)");
                for (RsMacroCase rsMacroCase : CollectionsKt.dropLast(list, (int)1)) {
                    PsiElement psiElement2 = PsiElementExtensionsKt.getNextNonCommentSibling(rsMacroCase);
                    if (Intrinsics.areEqual((Object)(psiElement2 != null ? PsiElementExtensionsKt.getElementType(psiElement2) : null), (Object)RsElementTypes.COMMA)) continue;
                    Intrinsics.checkNotNull((Object)rsMacroCase);
                    Object[] objectArray = new Object[]{","};
                    String string = RsBundle.INSTANCE.message("inspection.invalid.macro.def.missing.semicolon.or.comma.description", objectArray);
                    objectArray = new LocalQuickFix[]{new AddCommaFix(rsMacroCase)};
                    this.$holder.registerProblem(PsiTreeUtilKt.lastLeaf((PsiElement)rsMacroCase), string, (LocalQuickFix[])objectArray);
                }
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }
}

