/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.ConvertImplToStringToImplDisplayFix;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.resolve.KnownItems;
import org.rust.lang.core.resolve.KnownItemsKt;
import org.rust.lang.utils.RangeSpecifier;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/rust/ide/inspections/RsImplToStringInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "intellij.rustrover.core"})
public final class RsImplToStringInspection
extends RsLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("inspection.message.direct.implementation.of.to.string", new Object[0]);
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder, this){
            final /* synthetic */ RsProblemsHolder $holder;
            final /* synthetic */ RsImplToStringInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            public void visitImplItem2(RsImplItem o) {
                PsiElement psiElement2;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsTraitRef rsTraitRef = o.getTraitRef();
                if (rsTraitRef == null) {
                    return;
                }
                RsTraitRef traitRef = rsTraitRef;
                Object object = traitRef.getPath().getReference();
                if (object == null || (object = object.resolve()) == null) {
                    return;
                }
                Object resolvedTrait = object;
                KnownItems items = KnownItemsKt.getKnownItems(o);
                if (!Intrinsics.areEqual((Object)resolvedTrait, (Object)items.getToString())) {
                    return;
                }
                ConvertImplToStringToImplDisplayFix fix = new ConvertImplToStringToImplDisplayFix(o);
                RsTypeReference rsTypeReference = o.getTypeReference();
                if (rsTypeReference != null) {
                    psiElement2 = rsTypeReference;
                } else {
                    psiElement2 = o.getFor();
                    if (psiElement2 == null) {
                        psiElement2 = traitRef;
                    }
                }
                PsiElement right = psiElement2;
                RangeSpecifier.EndElement rangeSpecifier = new RangeSpecifier.EndElement(right);
                PsiElement psiElement3 = o.getImpl();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getImpl(...)");
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                RsProblemsHolder.registerProblem$default(this.$holder, psiElement3, rangeSpecifier, this.this$0.getDisplayName(), ProblemHighlightType.WEAK_WARNING, localQuickFixArray, null, 32, null);
            }
        };
    }
}

