/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.inspections.RemoveDuplicatedInsertStatementFix;
import org.rust.ide.inspections.RemoveDuplicatedKeyFix;
import org.rust.ide.inspections.RsDuplicateHashKeyInspection;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsArrayExpr;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsMacroExpr;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsTupleExpr;
import org.rust.lang.core.psi.RsValueArgumentList;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsLitExprKt;
import org.rust.lang.core.psi.ext.RsMethodOrFieldKt;
import org.rust.lang.core.resolve.KnownItemsKt;
import org.rust.lang.core.stubs.RsPlaceholderStub;
import org.rust.lang.core.stubs.RsStubLiteralKind;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyKt;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/rust/ide/inspections/RsDuplicateHashKeyInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "intellij.rustrover.core"})
public final class RsDuplicateHashKeyInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitBlock(RsBlock o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                PsiElement $this$childOfType$iv = o;
                boolean $i$f$childOfType = false;
                RsExprStmt stmt = (RsExprStmt)PsiTreeUtil.getChildOfType((PsiElement)$this$childOfType$iv, RsExprStmt.class);
                while (stmt != null) {
                    RsExprStmt lastFound = this.findInsertDuplicates(stmt);
                    PsiElement $this$nextSiblingOfType$iv = lastFound;
                    boolean $i$f$nextSiblingOfType = false;
                    stmt = (RsExprStmt)PsiTreeUtil.getNextSiblingOfType((PsiElement)$this$nextSiblingOfType$iv, RsExprStmt.class);
                }
            }

            public void visitExpr(RsExpr o) {
                RsValueArgumentList rsValueArgumentList;
                StubBasedPsiElement<RsPlaceholderStub<?>> stubBasedPsiElement;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsExpr rsExpr = o;
                if (rsExpr instanceof RsMacroExpr) {
                    var5_3 = RsExprKt.unwrapMacroExpr(o);
                    stubBasedPsiElement = var5_3 instanceof RsPathExpr ? (RsPathExpr)var5_3 : null;
                    if (stubBasedPsiElement == null || (stubBasedPsiElement = stubBasedPsiElement.getPath()) == null) {
                        return;
                    }
                } else if (rsExpr instanceof RsCallExpr) {
                    var5_3 = ((RsCallExpr)o).getExpr();
                    stubBasedPsiElement = var5_3 instanceof RsPathExpr ? (StubBasedPsiElement<RsPlaceholderStub<?>>)var5_3 : null;
                    if (stubBasedPsiElement == null || (stubBasedPsiElement = stubBasedPsiElement.getPath()) == null) {
                        return;
                    }
                } else {
                    return;
                }
                StubBasedPsiElement<RsPlaceholderStub<?>> callPath = stubBasedPsiElement;
                RsExpr rsExpr2 = o;
                if (rsExpr2 instanceof RsMacroExpr) {
                    PsiElement psiElement2 = ((RsMacroExpr)o).getNextSibling();
                    rsValueArgumentList = psiElement2 instanceof RsValueArgumentList ? (RsValueArgumentList)psiElement2 : null;
                    if (rsValueArgumentList == null) {
                        return;
                    }
                } else if (rsExpr2 instanceof RsCallExpr) {
                    RsValueArgumentList rsValueArgumentList2 = ((RsCallExpr)o).getValueArgumentList();
                    rsValueArgumentList = rsValueArgumentList2;
                    Intrinsics.checkNotNullExpressionValue((Object)rsValueArgumentList2, (String)"getValueArgumentList(...)");
                } else {
                    throw new IllegalStateException("unreachable!".toString());
                }
                RsValueArgumentList args = rsValueArgumentList;
                if (!Intrinsics.areEqual((Object)callPath.getReferenceName(), (Object)"from")) {
                    return;
                }
                Object object = callPath.getPath();
                if (object == null || (object = object.getReference()) == null || (object = object.resolve()) == null) {
                    return;
                }
                Object receiver = object;
                if (!Intrinsics.areEqual((Object)receiver, (Object)KnownItemsKt.getKnownItems(o).getHashMap())) {
                    return;
                }
                List<RsExpr> list = args.getExprList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
                RsExpr rsExpr3 = (RsExpr)CollectionsKt.singleOrNull(list);
                if (rsExpr3 == null || (rsExpr3 = RsExprKt.unwrapMacroExpr(rsExpr3)) == null) {
                    return;
                }
                RsExpr fromArg = rsExpr3;
                if (!(fromArg instanceof RsArrayExpr)) {
                    return;
                }
                Map tuplesByKey = new LinkedHashMap<K, V>();
                for (RsExpr arg : ((RsArrayExpr)fromArg).getExprList()) {
                    Intrinsics.checkNotNull((Object)arg);
                    RsExpr rsExpr4 = RsExprKt.unwrapMacroExpr(arg);
                    RsTupleExpr rsTupleExpr = rsExpr4 instanceof RsTupleExpr ? (RsTupleExpr)rsExpr4 : null;
                    if (rsTupleExpr == null) {
                        return;
                    }
                    RsTupleExpr tupleExpr = rsTupleExpr;
                    if (tupleExpr.getExprList().size() != 2) {
                        return;
                    }
                    List<RsExpr> list2 = tupleExpr.getExprList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
                    Object object2 = CollectionsKt.first(list2);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first(...)");
                    Object key = this.normalizeKey(RsExprKt.unwrapMacroExpr((RsExpr)object2));
                    if (key == null) continue;
                    tuplesByKey.computeIfAbsent(key, arg_0 -> buildVisitor.1.visitExpr$lambda$1(buildVisitor.1::visitExpr$lambda$0, arg_0)).add(tupleExpr);
                }
                for (List tuples : tuplesByKey.values()) {
                    if (tuples.size() <= 1) continue;
                    for (RsTupleExpr tuple : tuples) {
                        RemoveDuplicatedKeyFix fix = new RemoveDuplicatedKeyFix(tuple);
                        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.DuplicateHashKey(tuple, fix), this.$holder, false, null, 6, null);
                    }
                }
            }

            private final RsExprStmt findInsertDuplicates(RsExprStmt stmt) {
                RsExprStmt current = stmt;
                Map insertsByKey = new LinkedHashMap<K, V>();
                while (this.findHashMapInsertCall(current) != null) {
                    RsExpr keyArg;
                    RsExpr rsExpr;
                    Object object;
                    RsMethodCall insertCall;
                    List<RsExpr> list = insertCall.getValueArgumentList().getExprList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
                    if ((RsExpr)CollectionsKt.firstOrNull(list) == null || (object = (rsExpr = RsMethodOrFieldKt.getReceiver(insertCall)) instanceof RsPathExpr ? (RsPathExpr)rsExpr : null) == null || (object = object.getPath()) == null || (object = object.getReference()) == null || (object = object.resolve()) == null) break;
                    Object receiver = object;
                    Object normalizedKeyArg = this.normalizeKey(keyArg);
                    if (normalizedKeyArg != null) {
                        insertsByKey.computeIfAbsent(TuplesKt.to((Object)receiver, (Object)normalizedKeyArg), arg_0 -> buildVisitor.1.findInsertDuplicates$lambda$3(buildVisitor.1::findInsertDuplicates$lambda$2, arg_0)).add(current);
                    }
                    PsiElement $this$nextSiblingOfType$iv = current;
                    boolean $i$f$nextSiblingOfType = false;
                    if ((RsExprStmt)PsiTreeUtil.getNextSiblingOfType((PsiElement)$this$nextSiblingOfType$iv, RsExprStmt.class) == null) break;
                }
                for (List inserts : insertsByKey.values()) {
                    if (inserts.size() <= 1) continue;
                    for (RsExprStmt insert2 : inserts) {
                        RemoveDuplicatedInsertStatementFix fix = new RemoveDuplicatedInsertStatementFix(insert2);
                        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.DuplicateHashKey(insert2, fix), this.$holder, false, null, 6, null);
                    }
                }
                return current;
            }

            private final RsMethodCall findHashMapInsertCall(RsExprStmt stmt) {
                RsExpr rsExpr = stmt.getExpr();
                RsMethodCallExpr rsMethodCallExpr = rsExpr instanceof RsMethodCallExpr ? (RsMethodCallExpr)rsExpr : null;
                if (rsMethodCallExpr == null) {
                    return null;
                }
                RsMethodCallExpr dotExpr = rsMethodCallExpr;
                RsMethodCall rsMethodCall = dotExpr.getMethodCall();
                Intrinsics.checkNotNullExpressionValue((Object)rsMethodCall, (String)"getMethodCall(...)");
                RsMethodCall methodCall = rsMethodCall;
                if (!Intrinsics.areEqual((Object)methodCall.getReferenceName(), (Object)"insert")) {
                    return null;
                }
                if (methodCall.getValueArgumentList().getExprList().size() != 2) {
                    return null;
                }
                RsExpr rsExpr2 = dotExpr.getReceiver();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr2, (String)"<get-receiver>(...)");
                Ty ty2 = TyKt.stripReferences$default(ExtensionsKt.getType(rsExpr2), null, 1, null);
                TyAdt tyAdt = ty2 instanceof TyAdt ? (TyAdt)ty2 : null;
                if (tyAdt == null) {
                    return null;
                }
                TyAdt receiverTy = tyAdt;
                if (!Intrinsics.areEqual((Object)receiverTy.getItem(), (Object)KnownItemsKt.getKnownItems(stmt).getHashMap())) {
                    return null;
                }
                return methodCall;
            }

            private final Object normalizeKey(RsExpr key) {
                Object object;
                RsExpr rsExpr = key;
                if (rsExpr instanceof RsCallExpr) {
                    RsExpr rsExpr2 = ((RsCallExpr)key).getExpr();
                    StubBasedPsiElement<RsPlaceholderStub<?>> stubBasedPsiElement = rsExpr2 instanceof RsPathExpr ? (RsPathExpr)rsExpr2 : null;
                    if (stubBasedPsiElement == null || (stubBasedPsiElement = stubBasedPsiElement.getPath()) == null) {
                        return null;
                    }
                    StubBasedPsiElement<RsPlaceholderStub<?>> path = stubBasedPsiElement;
                    Object object2 = path.getPath();
                    if (!Intrinsics.areEqual((Object)(object2 != null && (object2 = object2.getReference()) != null ? object2.resolve() : null), (Object)KnownItemsKt.getKnownItems(key).getString())) {
                        return null;
                    }
                    if (Intrinsics.areEqual((Object)path.getReferenceName(), (Object)"from")) {
                        List<RsExpr> list = ((RsCallExpr)key).getValueArgumentList().getExprList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
                        RsExpr arg = (RsExpr)CollectionsKt.firstOrNull(list);
                        RsLitExpr rsLitExpr = arg instanceof RsLitExpr ? (RsLitExpr)arg : null;
                        object = rsLitExpr != null ? RsLitExprKt.getStringValue(rsLitExpr) : null;
                    } else {
                        object = null;
                    }
                } else if (rsExpr instanceof RsLitExpr) {
                    RsStubLiteralKind path = ((RsLitExpr)key).getStubKind();
                    object = path instanceof RsStubLiteralKind.String ? RsLitExprKt.getStringValue((RsLitExpr)key) : (path instanceof RsStubLiteralKind.Boolean ? RsLitExprKt.getBooleanValue((RsLitExpr)key) : (path instanceof RsStubLiteralKind.Integer ? RsLitExprKt.getIntegerValue((RsLitExpr)key) : (path instanceof RsStubLiteralKind.Char ? RsLitExprKt.getCharValue((RsLitExpr)key) : null)));
                } else if (rsExpr instanceof RsMethodCallExpr) {
                    String method = ((RsMethodCallExpr)key).getMethodCall().getReferenceName();
                    if (Intrinsics.areEqual((Object)method, (Object)"to_owned") || Intrinsics.areEqual((Object)method, (Object)"to_string")) {
                        RsExpr rsExpr3 = ((RsMethodCallExpr)key).getReceiver();
                        RsLitExpr rsLitExpr = rsExpr3 instanceof RsLitExpr ? (RsLitExpr)rsExpr3 : null;
                        object = rsLitExpr != null ? RsLitExprKt.getStringValue(rsLitExpr) : null;
                    } else {
                        object = null;
                    }
                } else {
                    object = null;
                }
                return object;
            }

            private static final List visitExpr$lambda$0(Object it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return new ArrayList<E>();
            }

            private static final List visitExpr$lambda$1(Function1 $tmp0, Object p0) {
                return (List)$tmp0.invoke(p0);
            }

            private static final List findInsertDuplicates$lambda$2(Object it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return new ArrayList<E>();
            }

            private static final List findInsertDuplicates$lambda$3(Function1 $tmp0, Object p0) {
                return (List)$tmp0.invoke(p0);
            }
        };
    }
}

