/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.RemoveRefFix;
import org.rust.ide.inspections.RsDropRefInspectionKt;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.TyRef;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/inspections/RsDropRefInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "inspectExpr", "", "expr", "Lorg/rust/lang/core/psi/RsCallExpr;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsDropRefInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDropRefInspection.kt\norg/rust/ide/inspections/RsDropRefInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class RsDropRefInspection
extends RsLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("drop.reference", new Object[0]);
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsDropRefInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitCallExpr(RsCallExpr expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                this.this$0.inspectExpr(expr, this.$holder);
            }
        };
    }

    public final void inspectExpr(@NotNull RsCallExpr expr, @NotNull RsProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        RsExpr rsExpr = RsDropRefInspectionKt.getSingleArgOfDropExpr(expr);
        if (rsExpr == null) {
            return;
        }
        RsExpr arg = rsExpr;
        if (ExtensionsKt.getType(arg) instanceof TyRef) {
            LocalQuickFix[] localQuickFixArray;
            RemoveRefFix removeRefFix = RemoveRefFix.Companion.createIfCompatible(arg);
            if (removeRefFix != null) {
                RemoveRefFix it2 = removeRefFix;
                boolean bl = false;
                RemoveRefFix[] removeRefFixArray = new RemoveRefFix[]{it2};
                localQuickFixArray = removeRefFixArray;
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.registerProblem((PsiElement)expr, RsBundle.INSTANCE.message("inspection.message.call.to.std.mem.drop.with.reference.argument.dropping.reference.does.nothing", new Object[0]), Arrays.copyOf(fixes, fixes.length));
        }
    }
}

