/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.model.impl.CargoSettingsFilesService;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.ide.fixes.AttachFileToModuleFix;
import org.rust.ide.fixes.ReloadProjectQuickFix;
import org.rust.ide.fixes.RenameAndAttachFile;
import org.rust.ide.inspections.RsDetachedFileInspectionKt;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.lang.core.psi.RsFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0014H\u0002R\u0014\u0010\u000e\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/inspections/RsDetachedFileInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isSyntaxOnly", "()Z", "isDumbAware", "isInspectionEnabled", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "SuppressFix", "Helper", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsDetachedFileInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDetachedFileInspection.kt\norg/rust/ide/inspections/RsDetachedFileInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,115:1\n1#2:116\n37#3,2:117\n*S KotlinDebug\n*F\n+ 1 RsDetachedFileInspection.kt\norg/rust/ide/inspections/RsDetachedFileInspection\n*L\n61#1:117,2\n*E\n"})
public final class RsDetachedFileInspection
extends RsLocalInspectionTool {
    private final boolean isSyntaxOnly;

    public RsDetachedFileInspection() {
        this.isSyntaxOnly = true;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file instanceof RsFile)) {
            return null;
        }
        Project project = ((RsFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = ((RsFile)file).getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        if (!this.isInspectionEnabled(project2, virtualFile)) {
            return null;
        }
        if (Helper.INSTANCE.isFileDetached(file) == ThreeState.YES) {
            ProblemDescriptor[] problemDescriptorArray;
            VirtualFile virtualFile2 = ((RsFile)file).getVirtualFile();
            Intrinsics.checkNotNull((Object)virtualFile2);
            Set<VirtualFile> set = Helper.INSTANCE.collectImplicitTargets(project2, virtualFile2);
            if (set == null) {
                return null;
            }
            Set<VirtualFile> implicitTargets = set;
            ProblemDescriptor[] $this$checkFile_u24lambda_u240 = problemDescriptorArray = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (implicitTargets.contains(virtualFile2)) {
                $this$checkFile_u24lambda_u240.add(new ReloadProjectQuickFix());
            } else {
                Object it2;
                String string = ((RsFile)file).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"-", (boolean)false, (int)2, null)) {
                    List<RsFile> list;
                    it2 = list = AttachFileToModuleFix.Companion.findAvailableModulesForFile(project2, (RsFile)file);
                    boolean bl2 = false;
                    List<RsFile> list2 = !((Collection)it2).isEmpty() ? list : null;
                    if (list2 != null) {
                        it2 = list2;
                        boolean bl3 = false;
                        RsFile rsFile = (RsFile)file;
                        String string2 = ((RsFile)file).getVirtualFile().getNameWithoutExtension();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
                        RsFile rsFile2 = (RsFile)CollectionsKt.singleOrNull(it2);
                        $this$checkFile_u24lambda_u240.add(new RenameAndAttachFile(rsFile, StringsKt.replace$default((String)string2, (String)"-", (String)"_", (boolean)false, (int)4, null), rsFile2 != null ? rsFile2.getName() : null));
                    }
                }
                AttachFileToModuleFix attachFileToModuleFix = AttachFileToModuleFix.Companion.createIfCompatible(project2, (RsFile)file);
                if (attachFileToModuleFix != null) {
                    it2 = attachFileToModuleFix;
                    boolean bl4 = false;
                    $this$checkFile_u24lambda_u240.add(it2);
                }
            }
            $this$checkFile_u24lambda_u240.add(new SuppressFix());
            List fixes = CollectionsKt.build((List)problemDescriptorArray);
            problemDescriptorArray = new ProblemDescriptor[1];
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Intrinsics.checkNotNullExpressionValue((Object)manager.createProblemDescriptor((PsiElement)file, RsBundle.INSTANCE.message("inspection.message.file.not.included.in.module.tree.analysis.not.available", new Object[0]), isOnTheFly, thisCollection$iv.toArray(new LocalQuickFix[0]), ProblemHighlightType.WARNING), (String)"createProblemDescriptor(...)");
            return problemDescriptorArray;
        }
        return null;
    }

    @Override
    public boolean isSyntaxOnly() {
        return this.isSyntaxOnly;
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    private final boolean isInspectionEnabled(Project project, VirtualFile file) {
        return !PropertiesComponent.getInstance((Project)project).getBoolean(RsDetachedFileInspectionKt.access$getDisablingKey(file), false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/RsDetachedFileInspection$Helper;", "", "<init>", "()V", "collectImplicitTargets", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "isFileDetached", "Lcom/intellij/util/ThreeState;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.rustrover.core"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        @Nullable
        public final Set<VirtualFile> collectImplicitTargets(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            CargoWorkspace.Package package_ = CargoProjectServiceKt.getCargoProjects(project).findPackageForFile(virtualFile);
            if (package_ == null) {
                return null;
            }
            CargoWorkspace.Package pkg = package_;
            return CargoSettingsFilesService.Companion.collectImplicitTargets(pkg);
        }

        @NotNull
        public final ThreeState isFileDetached(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!(file instanceof RsFile)) {
                return ThreeState.UNSURE;
            }
            Project project = ((RsFile)file).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            CargoProjectsService cargoProjects = CargoProjectServiceKt.getCargoProjects(project);
            if (!cargoProjects.getInitialized()) {
                return ThreeState.UNSURE;
            }
            VirtualFile virtualFile = ((RsFile)file).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            CargoProject cargoProject = cargoProjects.findProjectForFile(virtualFile);
            if (cargoProject == null) {
                return ThreeState.UNSURE;
            }
            CargoProject cargoProject2 = cargoProject;
            if (cargoProject2.getWorkspace() == null) {
                return ThreeState.UNSURE;
            }
            return ((RsFile)file).getCrateRoot() == null ? ThreeState.YES : ThreeState.NO;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/inspections/RsDetachedFileInspection$SuppressFix;", "Lcom/intellij/codeInspection/SuppressQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "isAvailable", "", "context", "Lcom/intellij/psi/PsiElement;", "isSuppressAll", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "intellij.rustrover.core"})
    private static final class SuppressFix
    implements SuppressQuickFix {
        @NotNull
        public String getFamilyName() {
            return RsBundle.INSTANCE.message("intention.family.name.do.not.show.again", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement psiElement2 = descriptor.getStartElement();
            RsFile rsFile = psiElement2 instanceof RsFile ? (RsFile)psiElement2 : null;
            if (rsFile == null) {
                return;
            }
            RsFile file = rsFile;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            VirtualFile virtualFile = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            propertiesComponent.setValue(RsDetachedFileInspectionKt.access$getDisablingKey(virtualFile), true);
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return true;
        }

        public boolean isSuppressAll() {
            return false;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return null;
        }
    }
}

