/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.fixes.AddDefaultAttrFix;
import org.rust.ide.fixes.DeriveTraitsFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RemoveDefaultValueFix;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.presentation.TypeRenderable;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.lang.core.psi.RsEnumItem;
import org.rust.lang.core.psi.RsEnumVariant;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.QueryAttributes;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsEnumItemKt;
import org.rust.lang.core.psi.ext.RsFieldDecl;
import org.rust.lang.core.psi.ext.RsFieldsOwnerKt;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsGenericDeclarationKt;
import org.rust.lang.core.psi.ext.RsMetaItemKt;
import org.rust.lang.core.psi.ext.RsNameIdentifierOwner;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElementKt;
import org.rust.lang.core.resolve.ImplLookup;
import org.rust.lang.core.resolve.KnownItems;
import org.rust.lang.core.resolve.KnownItemsKt;
import org.rust.lang.core.resolve.SelectionResult;
import org.rust.lang.core.stubs.common.RsMetaItemPsiOrStub;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.TraitRef;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/RsDerivableTraitMembersInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsDerivableTraitMembersInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitEnumItem2(RsEnumItem o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.checkAllSuperTraits(o);
                this.checkDefaultMark(o);
                for (RsEnumVariant variant : RsEnumItemKt.getVariants(o)) {
                    this.checkMembers(o, RsFieldsOwnerKt.getExpandedFields(variant));
                }
            }

            public void visitStructItem2(RsStructItem o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.checkAllSuperTraits(o);
                this.checkMembers(o, RsFieldsOwnerKt.getExpandedFields(o));
            }

            private final void checkAllSuperTraits(RsStructOrEnumItemElement item) {
                KnownItems items = KnownItemsKt.getKnownItems(item);
                Ty[] tyArray = new Ty[]{item.getDeclaredType()};
                this.checkSuperTrait(item, items.getEq(), items.getPartialEq(), tyArray);
                tyArray = new Ty[]{item.getDeclaredType()};
                this.checkSuperTrait(item, items.getPartialOrd(), items.getPartialEq(), tyArray);
                tyArray = new Ty[]{item.getDeclaredType()};
                this.checkSuperTrait(item, items.getOrd(), items.getPartialOrd(), tyArray);
                this.checkSuperTrait(item, items.getOrd(), items.getEq(), new Ty[0]);
            }

            private final void checkSuperTrait(RsStructOrEnumItemElement item, RsTraitItem baseTrait, RsTraitItem superTrait, Ty ... subst) {
                TraitRef traitRef;
                Object v1;
                Object superTraitName;
                block5: {
                    if (baseTrait == null) {
                        return;
                    }
                    Object object = superTrait;
                    if (object == null || (object = object.getName()) == null) {
                        return;
                    }
                    superTraitName = object;
                    Sequence<RsMetaItem> $this$firstOrNull$iv = RsStructOrEnumItemElementKt.getDeriveMetaItems(item);
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        RsMetaItem it2 = (RsMetaItem)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)RsMetaItemKt.resolveToDerivedTrait(it2), (Object)baseTrait)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                RsMetaItem rsMetaItem = v1;
                if (rsMetaItem == null) {
                    return;
                }
                RsMetaItem baseDerive = rsMetaItem;
                Ty itemType = item.getDeclaredType();
                ImplLookup lookup2 = ExtensionsKt.getImplLookup(item);
                SelectionResult selectionResult = ImplLookup.probeObligations$default(lookup2, traitRef = new TraitRef(itemType, RsGenericDeclarationKt.withSubst((RsGenericDeclaration)superTrait, Arrays.copyOf(subst, subst.length))), 0, 2, null);
                if (selectionResult instanceof SelectionResult.Err && !lookup2.getCtx().isAnyObligationErrorMuted(baseDerive, traitRef, ((SelectionResult.Err)selectionResult).getFailedObligations())) {
                    String string = TypeRenderingKt.render$default(itemType, null, 0, null, null, null, null, null, null, null, false, false, false, false, false, false, false, null, 131071, null);
                    Class<?> clazz = ((Object)((Object)this)).getClass();
                    List<LocalQuickFix> list = this.createFixes(itemType, (String)superTraitName);
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.TraitIsNotImplemented((PsiElement)baseDerive, (String)superTraitName, string, clazz, list), this.$holder, false, null, 6, null);
                }
            }

            private final void checkMembers(RsStructOrEnumItemElement item, List<? extends RsFieldDecl> fields) {
                Pair<ImplLookup, KnownItems> pair = ExtensionsKt.getImplLookupAndKnownItems(item);
                ImplLookup lookup2 = (ImplLookup)pair.component1();
                KnownItems items = (KnownItems)pair.component2();
                for (RsMetaItem derive : RsStructOrEnumItemElementKt.getDeriveMetaItems(item)) {
                    RsTraitItem trait;
                    if (RsMetaItemKt.resolveToDerivedTrait(derive) == null || trait.getName() == null) continue;
                    for (RsFieldDecl field : fields) {
                        String traitName;
                        TraitRef traitRef;
                        SelectionResult selectionResult;
                        TraitRef traitRef2;
                        Object object;
                        RsNameIdentifierOwner rsNameIdentifierOwner;
                        Object object2 = field.getTypeReference();
                        if (object2 == null || (object2 = ExtensionsKt.getNormType((RsTypeReference)object2)) == null) continue;
                        Object fieldType = object2;
                        if (Intrinsics.areEqual((Object)trait, (Object)items.getDefault()) && item instanceof RsEnumItem) {
                            Sequence<T> sequence2;
                            PsiElement $this$parentOfType_u24default$iv = field;
                            boolean withSelf$iv = false;
                            boolean $i$f$parentOfType = false;
                            rsNameIdentifierOwner = (RsEnumVariant)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsEnumVariant.class, (boolean)true);
                            boolean isDefault = (rsNameIdentifierOwner != null && (object = RsDocAndAttributeOwnerKt.getQueryAttributes(rsNameIdentifierOwner)) != null && (sequence2 = ((QueryAttributes)object).attrsByName("default")) != null ? (RsMetaItemPsiOrStub)SequencesKt.firstOrNull(sequence2) : null) != null;
                            if (!isDefault) continue;
                        }
                        if (Intrinsics.areEqual((Object)(rsNameIdentifierOwner = trait), (Object)items.getPartialEq()) || Intrinsics.areEqual((Object)rsNameIdentifierOwner, (Object)items.getPartialOrd())) {
                            object = new Ty[]{fieldType};
                            traitRef2 = new TraitRef((Ty)fieldType, RsGenericDeclarationKt.withSubst((RsGenericDeclaration)trait, (Ty[])object));
                        } else {
                            traitRef2 = new TraitRef((Ty)fieldType, RsGenericDeclarationKt.withSubst((RsGenericDeclaration)trait, new Ty[0]));
                        }
                        if (!((selectionResult = ImplLookup.probeObligations$default(lookup2, traitRef = traitRef2, 0, 2, null)) instanceof SelectionResult.Err) || lookup2.getCtx().isAnyObligationErrorMuted(field, traitRef, ((SelectionResult.Err)selectionResult).getFailedObligations())) continue;
                        object = TypeRenderingKt.render$default((TypeRenderable)fieldType, null, 0, null, null, null, null, null, null, null, false, false, false, false, false, false, false, null, 131071, null);
                        Class<?> clazz = ((Object)((Object)this)).getClass();
                        List<LocalQuickFix> list = this.createFixes((Ty)fieldType, traitName);
                        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.TraitIsNotImplemented((PsiElement)field, traitName, (String)object, clazz, list), this.$holder, false, null, 6, null);
                    }
                }
            }

            private final List<LocalQuickFix> createFixes(Ty fieldType, String traitName) {
                return fieldType instanceof TyAdt && ((TyAdt)fieldType).getItem().getContainingCrate().getOrigin() == PackageOrigin.WORKSPACE ? CollectionsKt.listOf((Object)((Object)new DeriveTraitsFix(((TyAdt)fieldType).getItem(), traitName))) : CollectionsKt.emptyList();
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            private final void checkDefaultMark(RsEnumItem rsEnumItem) {
                Object element$iv$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                Object v1;
                Object element$iv2;
                block15: {
                    RsTraitItem rsTraitItem = KnownItemsKt.getKnownItems(rsEnumItem).getDefault();
                    if (rsTraitItem == null) {
                        return;
                    }
                    RsTraitItem defaultTrait = rsTraitItem;
                    Sequence<RsMetaItem> $this$firstOrNull$iv = RsStructOrEnumItemElementKt.getDeriveMetaItems(rsEnumItem);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        RsMetaItem it2 = (RsMetaItem)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)RsMetaItemKt.resolveToDerivedTrait(it2), (Object)defaultTrait)) continue;
                        v1 = element$iv2;
                        break block15;
                    }
                    v1 = null;
                }
                RsMetaItem rsMetaItem = v1;
                if (rsMetaItem == null) {
                    return;
                }
                RsMetaItem metaItem = rsMetaItem;
                RsEnumVariant rsEnumVariant = (RsEnumVariant)CollectionsKt.firstOrNull(RsEnumItemKt.getVariants(rsEnumItem));
                if (rsEnumVariant == null) {
                    return;
                }
                RsEnumVariant firstVariant = rsEnumVariant;
                Iterable $this$mapNotNull$iv = RsEnumItemKt.getVariants(rsEnumItem);
                boolean $i$f$mapNotNull = false;
                element$iv2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    RsMetaItem it$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    RsEnumVariant it3 = (RsEnumVariant)element$iv$iv;
                    boolean bl2 = false;
                    if ((RsMetaItem)SequencesKt.firstOrNull(RsDocAndAttributeOwnerKt.getQueryPsiAttributes(it3).attrsByName("default")) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List defaultMarks = (List)destination$iv$iv;
                switch (defaultMarks.size()) {
                    case 0: {
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new AddDefaultAttrFix(firstVariant)};
                        this.$holder.registerProblem((PsiElement)metaItem, RsBundle.INSTANCE.message("inspection.message.no.default.declared", new Object[0]), localQuickFixArray);
                        return;
                    }
                    case 1: {
                        return;
                    }
                }
                Iterator<E> iterator3 = defaultMarks.iterator();
                while (iterator3.hasNext()) {
                    RsOuterAttr attr;
                    PsiElement psiElement2;
                    PsiElement psiElement3;
                    block16: {
                        void $this$findParentInFile$iv$iv;
                        RsMetaItem d = (RsMetaItem)iterator3.next();
                        PsiElement $this$findParentOfType_u24default$iv = d;
                        boolean strict$iv = true;
                        boolean $i$f$findParentOfType = false;
                        element$iv$iv$iv = $this$findParentOfType_u24default$iv;
                        boolean withSelf$iv$iv = false;
                        boolean $i$f$findParentInFile = false;
                        if ($this$findParentInFile$iv$iv instanceof PsiFile) {
                            psiElement3 = null;
                        } else {
                            for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                                PsiElement it$iv = current$iv$iv;
                                boolean bl = false;
                                if (it$iv instanceof RsOuterAttr) {
                                    psiElement3 = current$iv$iv;
                                    break block16;
                                }
                                if (current$iv$iv instanceof PsiFile) break;
                            }
                            psiElement3 = psiElement2 = null;
                        }
                    }
                    if (!(psiElement3 instanceof RsOuterAttr)) {
                        psiElement2 = null;
                    }
                    if ((RsOuterAttr)((PsiElement)((RsOuterAttr)psiElement2)) == null) continue;
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveDefaultValueFix(attr)};
                    this.$holder.registerProblem((PsiElement)attr, RsBundle.INSTANCE.message("inspection.message.multiple.default.variants", new Object[0]), localQuickFixArray);
                }
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }
}

