/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.RsDanglingElseInspection;
import org.rust.ide.inspections.RsDeleteDanglingElseBranchFix;
import org.rust.ide.inspections.RsJoinElseIfFix;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsElseBranch;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016R\u0014\u0010\f\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/inspections/RsDanglingElseInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isSyntaxOnly", "()Z", "isDumbAware", "rightSiblings", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiElement;", "getRightSiblings", "(Lcom/intellij/psi/PsiElement;)Lkotlin/sequences/Sequence;", "intellij.rustrover.core"})
public final class RsDanglingElseInspection
extends RsLocalInspectionTool {
    private final boolean isSyntaxOnly;

    public RsDanglingElseInspection() {
        this.isSyntaxOnly = true;
    }

    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("dangling.else", new Object[0]);
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsDanglingElseInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitElseBranch(RsElseBranch expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                PsiElement psiElement2 = expr.getElse();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElse(...)");
                PsiElement elseEl = psiElement2;
                PsiElement psiElement3 = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)RsDanglingElseInspection.access$getRightSiblings(this.this$0, elseEl), buildVisitor.1::visitElseBranch$lambda$0));
                if (psiElement3 == null) {
                    return;
                }
                PsiElement breakEl = psiElement3;
                PsiElement psiElement4 = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)RsDanglingElseInspection.access$getRightSiblings(this.this$0, breakEl), buildVisitor.1::visitElseBranch$lambda$1));
                if (psiElement4 == null) {
                    return;
                }
                PsiElement ifEl = psiElement4;
                PsiElement psiElement5 = expr;
                TextRange textRange = new TextRange(0, ifEl.getStartOffsetInParent() + 2);
                String string = RsBundle.INSTANCE.message("inspection.message.suspicious.else.if.formatting", new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[2];
                PsiFile psiFile = expr.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                localQuickFixArray[0] = new RsDeleteDanglingElseBranchFix(psiFile, PsiElementKt.rangeWithPrevSpace(elseEl, expr.getPrevSibling()));
                PsiFile psiFile2 = expr.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                localQuickFixArray[1] = new RsJoinElseIfFix(psiFile2, new TextRange(PsiElementKt.getEndOffset(elseEl), PsiElementKt.getStartOffset(ifEl)), " ");
                RsProblemsHolder.registerProblem$default(this.$holder, psiElement5, textRange, string, localQuickFixArray, false, null, null, 112, null);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static final boolean visitElseBranch$lambda$0(PsiElement it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                if (!(it2 instanceof PsiWhiteSpace)) {
                    if (!(it2 instanceof PsiComment)) return false;
                }
                String string = it2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) return false;
                return true;
            }

            private static final boolean visitElseBranch$lambda$1(PsiElement it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return !(it2 instanceof RsIfExpr);
            }
        };
    }

    @Override
    public boolean isSyntaxOnly() {
        return this.isSyntaxOnly;
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    private final Sequence<PsiElement> getRightSiblings(PsiElement $this$rightSiblings) {
        return SequencesKt.generateSequence((Object)$this$rightSiblings.getNextSibling(), RsDanglingElseInspection::_get_rightSiblings_$lambda$0);
    }

    private static final PsiElement _get_rightSiblings_$lambda$0(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getNextSibling();
    }

    public static final /* synthetic */ Sequence access$getRightSiblings(RsDanglingElseInspection $this, PsiElement $receiver) {
        return $this.getRightSiblings($receiver);
    }
}

