/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsInnerAttr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsLitExprKt;
import org.rust.lang.core.psi.ext.RsMetaItemKt;
import org.rust.lang.core.stubs.common.RsMetaItemPsiOrStub;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0018\u0010\n\u001a\u00020\t*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/inspections/RsCrateNameInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isAlphanumeric", "", "(C)Z", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsCrateNameInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder, this){
            final /* synthetic */ RsProblemsHolder $holder;
            final /* synthetic */ RsCrateNameInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void visitLitExpr(RsLitExpr o) {
                String string;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                PsiElement metaItem = o.getParent();
                if (!(metaItem instanceof RsMetaItem) || !Intrinsics.areEqual((Object)RsMetaItemKt.getName((RsMetaItemPsiOrStub)metaItem), (Object)"crate_name")) {
                    return;
                }
                PsiElement innerAttr = ((RsMetaItem)metaItem).getParent();
                if (!(innerAttr instanceof RsInnerAttr)) {
                    return;
                }
                PsiElement file = ((RsInnerAttr)innerAttr).getParent();
                if (!(file instanceof RsFile) || !((RsFile)file).isCrateRoot()) {
                    return;
                }
                String string2 = RsLitExprKt.getStringValue(o);
                if (string2 == null) {
                    return;
                }
                String value = string2;
                if (((CharSequence)value).length() == 0) {
                    string = RsBundle.INSTANCE.message("inspection.message.crate.name.cannot.be.empty.found", new Object[0]);
                } else {
                    boolean bl;
                    block9: {
                        void $this$any$iv;
                        CharSequence charSequence = value;
                        RsCrateNameInspection rsCrateNameInspection = this.this$0;
                        boolean $i$f$any = false;
                        for (int j = 0; j < $this$any$iv.length(); ++j) {
                            char element$iv;
                            char it2 = element$iv = $this$any$iv.charAt(j);
                            boolean bl2 = false;
                            if (!(!RsCrateNameInspection.access$isAlphanumeric(rsCrateNameInspection, it2) && it2 != '_')) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                    if (bl) {
                        string = RsBundle.INSTANCE.message("inspection.message.crate.name.can.only.contain.unicode.alphanumeric.or.underscore.empty.found", new Object[0]);
                    } else {
                        return;
                    }
                }
                String message = string;
                this.$holder.registerProblem((PsiElement)o, message, new LocalQuickFix[0]);
            }
        };
    }

    private final boolean isAlphanumeric(char $this$isAlphanumeric) {
        return Character.isAlphabetic($this$isAlphanumeric) || Character.isDigit($this$isAlphanumeric);
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ boolean access$isAlphanumeric(RsCrateNameInspection $this, char $receiver) {
        return $this.isAlphanumeric($receiver);
    }
}

