/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.fixes.SubstituteTextFix;
import org.rust.ide.inspections.RsConstantConditionIfInspectionKt;
import org.rust.ide.inspections.RsDeleteElseBranchFix;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.SimplifyFix;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsCondition;
import org.rust.lang.core.psi.RsElseBranch;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsLetExpr;
import org.rust.lang.core.psi.RsMacroExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.types.consts.Const;
import org.rust.lang.core.types.consts.CtValueKt;
import org.rust.lang.utils.evaluation.ConstExprEvaluatorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/inspections/RsConstantConditionIfInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "createDeleteElseBranchFix", "Lorg/rust/ide/fixes/SubstituteTextFix;", "ifExpr", "Lorg/rust/lang/core/psi/RsIfExpr;", "Util", "intellij.rustrover.core"})
public final class RsConstantConditionIfInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsConstantConditionIfInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitIfExpr(RsIfExpr ifExpr) {
                Intrinsics.checkNotNullParameter((Object)ifExpr, (String)"ifExpr");
                Boolean bl = Util.INSTANCE.evaluateConstCondition(ifExpr);
                if (bl == null) {
                    return;
                }
                boolean conditionValue = bl;
                RsCondition rsCondition = ifExpr.getCondition();
                if (rsCondition == null) {
                    return;
                }
                RsCondition condition = rsCondition;
                RsQuickFixBase fix = !conditionValue && ifExpr.getElseBranch() == null ? (RsQuickFixBase)RsConstantConditionIfInspection.access$createDeleteElseBranchFix(this.this$0, ifExpr) : (RsQuickFixBase)new SimplifyFix(ifExpr, conditionValue);
                Object[] objectArray = new Object[]{conditionValue};
                String string = RsBundle.INSTANCE.message("inspection.message.condition.always", objectArray);
                objectArray = new LocalQuickFix[]{fix};
                this.$holder.registerProblem((PsiElement)condition, string, (LocalQuickFix[])objectArray);
            }
        };
    }

    private final SubstituteTextFix createDeleteElseBranchFix(RsIfExpr ifExpr) {
        TextRange deletionRange = Util.INSTANCE.ifExprDeletionRange(ifExpr);
        PsiFile psiFile = ifExpr.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return new RsDeleteElseBranchFix(psiFile, deletionRange);
    }

    public static final /* synthetic */ SubstituteTextFix access$createDeleteElseBranchFix(RsConstantConditionIfInspection $this, RsIfExpr ifExpr) {
        return $this.createDeleteElseBranchFix(ifExpr);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/inspections/RsConstantConditionIfInspection$Util;", "", "<init>", "()V", "evaluateConstCondition", "", "ifExpr", "Lorg/rust/lang/core/psi/RsIfExpr;", "(Lorg/rust/lang/core/psi/RsIfExpr;)Ljava/lang/Boolean;", "ifExprDeletionRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsConstantConditionIfInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsConstantConditionIfInspection.kt\norg/rust/ide/inspections/RsConstantConditionIfInspection$Util\n+ 2 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,153:1\n124#2:154\n124#2:155\n*S KotlinDebug\n*F\n+ 1 RsConstantConditionIfInspection.kt\norg/rust/ide/inspections/RsConstantConditionIfInspection$Util\n*L\n50#1:154\n54#1:155\n*E\n"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @Nullable
        public final Boolean evaluateConstCondition(@NotNull RsIfExpr ifExpr) {
            RsMacroExpr rsMacroExpr;
            RsLetExpr rsLetExpr;
            boolean $i$f$descendantOfTypeOrSelf;
            PsiElement $this$descendantOfTypeOrSelf$iv;
            Intrinsics.checkNotNullParameter((Object)ifExpr, (String)"ifExpr");
            RsCondition rsCondition = ifExpr.getCondition();
            if (rsCondition == null) {
                return null;
            }
            RsCondition condition = rsCondition;
            RsExpr rsExpr = condition.getExpr();
            if (rsExpr != null) {
                $this$descendantOfTypeOrSelf$iv = rsExpr;
                $i$f$descendantOfTypeOrSelf = false;
                rsLetExpr = (RsLetExpr)PsiTreeUtil.findChildOfType((PsiElement)$this$descendantOfTypeOrSelf$iv, RsLetExpr.class, (boolean)false);
            } else {
                rsLetExpr = null;
            }
            if (rsLetExpr != null) {
                return null;
            }
            RsExpr rsExpr2 = condition.getExpr();
            if (rsExpr2 != null) {
                $this$descendantOfTypeOrSelf$iv = rsExpr2;
                $i$f$descendantOfTypeOrSelf = false;
                rsMacroExpr = (RsMacroExpr)PsiTreeUtil.findChildOfType((PsiElement)$this$descendantOfTypeOrSelf$iv, RsMacroExpr.class, (boolean)false);
            } else {
                rsMacroExpr = null;
            }
            if (rsMacroExpr != null) {
                return null;
            }
            Object object = condition.getExpr();
            if (object == null || (object = ConstExprEvaluatorKt.evaluate$default((RsExpr)object, null, null, 3, null)) == null || (object = CtValueKt.asBool((Const)object)) == null) {
                return null;
            }
            boolean conditionValue = (Boolean)object;
            boolean isUsedAsExpression = RsConstantConditionIfInspectionKt.access$isUsedAsExpression(ifExpr);
            if (!conditionValue && ifExpr.getElseBranch() == null) {
                boolean isInsideCascadeIf = RsConstantConditionIfInspectionKt.access$isInsideCascadeIf(ifExpr);
                if (isUsedAsExpression && !isInsideCascadeIf) {
                    return null;
                }
            }
            if (RsExpandedElementKt.isExpandedFromDifferentMacroCalls(ifExpr)) {
                return null;
            }
            return conditionValue;
        }

        @NotNull
        public final TextRange ifExprDeletionRange(@NotNull RsIfExpr ifExpr) {
            TextRange textRange;
            Intrinsics.checkNotNullParameter((Object)ifExpr, (String)"ifExpr");
            boolean isInsideCascadeIf = RsConstantConditionIfInspectionKt.access$isInsideCascadeIf(ifExpr);
            TextRange ifRange = PsiElementKt.getRangeWithPrevSpace(ifExpr);
            if (isInsideCascadeIf) {
                PsiElement psiElement2 = ifExpr.getParent();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsElseBranch");
                PsiElement psiElement3 = ((RsElseBranch)psiElement2).getElse();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getElse(...)");
                PsiElement parentElse = psiElement3;
                TextRange elseRange = PsiElementKt.rangeWithPrevSpace(parentElse, PsiTreeUtilKt.prevLeaf$default((PsiElement)parentElse, (boolean)false, (int)1, null));
                textRange = elseRange.union(ifRange);
            } else {
                textRange = ifRange;
            }
            TextRange textRange2 = textRange;
            Intrinsics.checkNotNull((Object)textRange2);
            TextRange deletionRange = textRange2;
            return deletionRange;
        }
    }
}

