/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.fixes.AddRequiredDependencyFeaturesFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.utils.ShowInMacroBehavior;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsMacroArgument;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.lang.core.psi.ext.RsMacroDefinitionBase;
import org.rust.lang.core.psi.ext.RsReferenceElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/inspections/RsCompileErrorMacroInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "createFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "o", "Lorg/rust/lang/core/psi/RsMacroCall;", "message", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "Companion", "intellij.rustrover.core"})
public final class RsCompileErrorMacroInspection
extends RsLocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TOKIO_MISSING_RT = "The #[tokio::main] macro requires rt or rt-multi-thread.";

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsCompileErrorMacroInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitMacroCall2(RsMacroCall o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsMacroDefinitionBase rsMacroDefinitionBase = RsMacroCallKt.resolveToMacro(o);
                if (rsMacroDefinitionBase == null) {
                    return;
                }
                RsMacroDefinitionBase resolvedTo = rsMacroDefinitionBase;
                if (!Intrinsics.areEqual((Object)resolvedTo.getName(), (Object)"compile_error") || resolvedTo.getContainingCrate().getOrigin() != PackageOrigin.STDLIB) {
                    return;
                }
                RsMacroArgument rsMacroArgument = o.getMacroArgument();
                if (rsMacroArgument == null) {
                    return;
                }
                RsMacroArgument macroArgument = rsMacroArgument;
                List<RsLitExpr> list = macroArgument.getLitExprList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getLitExprList(...)");
                RsLitExpr rsLitExpr = (RsLitExpr)CollectionsKt.singleOrNull(list);
                if (rsLitExpr == null) {
                    return;
                }
                RsLitExpr messageLiteral = rsLitExpr;
                RsLiteralKind rsLiteralKind = RsLiteralKindKt.getKind(messageLiteral);
                Object object = rsLiteralKind instanceof RsLiteralKind.String ? (RsLiteralKind.String)rsLiteralKind : null;
                if (object == null || (object = ((RsLiteralKind.String)object).getValue()) == null) {
                    return;
                }
                Object message = object;
                TextRange textRange = o.getPath().getTextRange().union(macroArgument.getTextRange()).shiftLeft(PsiElementKt.getStartOffset(o));
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
                TextRange errorRange = textRange;
                List fixes = RsCompileErrorMacroInspection.access$createFixes(this.this$0, o, (String)message);
                Collection $this$toTypedArray$iv = fixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                RsProblemsHolder.registerProblem$default(this.$holder, (PsiElement)o, errorRange, (String)message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length), false, ShowInMacroBehavior.Always, null, 80, null);
            }
        };
    }

    private final List<LocalQuickFix> createFixes(RsMacroCall o, String message) {
        if (!Intrinsics.areEqual((Object)message, (Object)TOKIO_MISSING_RT)) {
            return CollectionsKt.emptyList();
        }
        RsElement rsElement = RsExpandedElementKt.getExpandedFrom(o);
        if (rsElement == null || (rsElement = rsElement.getPath()) == null) {
            return CollectionsKt.emptyList();
        }
        RsElement path = rsElement;
        AddRequiredDependencyFeaturesFix addRequiredDependencyFeaturesFix = AddRequiredDependencyFeaturesFix.Companion.createFixForTokioMain((RsReferenceElement)path);
        if (addRequiredDependencyFeaturesFix == null) {
            return CollectionsKt.emptyList();
        }
        AddRequiredDependencyFeaturesFix fix = addRequiredDependencyFeaturesFix;
        return CollectionsKt.listOf((Object)((Object)fix));
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ List access$createFixes(RsCompileErrorMacroInspection $this, RsMacroCall o, String message) {
        return $this.createFixes(o, message);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/inspections/RsCompileErrorMacroInspection$Companion;", "", "<init>", "()V", "TOKIO_MISSING_RT", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

