/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.fixes.AddTokioMainFix;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsRemoveAsyncFromMainFix;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.KnownProcMacroKind;
import org.rust.lang.core.psi.ProcMacroAttribute;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/RsAsyncMainFunctionInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsAsyncMainFunctionInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitFunction2(RsFunction o) {
                PsiElement async;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                ASTNode aSTNode = o.getNode().findChildByType(RsElementTypes.ASYNC);
                Object object = async = aSTNode != null ? aSTNode.getPsi() : null;
                if (RsFunctionKt.isMain(o) && async != null) {
                    boolean bl;
                    block7: {
                        List<KnownProcMacroKind> hardcodedProMacros = ProcMacroAttribute.Companion.getHardcodedProcMacroAttributes(o);
                        Iterable $this$any$iv = hardcodedProMacros;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                KnownProcMacroKind it2 = (KnownProcMacroKind)((Object)element$iv);
                                boolean bl2 = false;
                                if (!(it2 == KnownProcMacroKind.ASYNC_MAIN)) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    }
                    boolean hasAsyncMainMacro = bl;
                    String entryPointName = o.getName();
                    if (!hasAsyncMainMacro && entryPointName != null) {
                        List list;
                        if (RsFunctionKt.isConst(o)) {
                            list = CollectionsKt.emptyList();
                        } else {
                            RsQuickFixBase[] rsQuickFixBaseArray = new RsQuickFixBase[]{new RsRemoveAsyncFromMainFix(async), new AddTokioMainFix(o)};
                            list = CollectionsKt.listOf((Object[])rsQuickFixBaseArray);
                        }
                        List fixes = list;
                        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.AsyncMainFunction(async, entryPointName, fixes), this.$holder, false, null, 6, null);
                    }
                }
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }
}

