/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.fixes.AddMutableFix;
import org.rust.ide.fixes.ChangeIterToIterMutFix;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsFixMapIndexExprAssignFix;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsIndexExpr;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsDotExpr;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsIndexExprKt;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.psi.ext.RsUnaryExprKt;
import org.rust.lang.core.resolve.KnownItems;
import org.rust.lang.core.resolve.KnownItemsKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyRawPtr;
import org.rust.lang.core.types.ty.TyRef;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J,\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/rust/ide/inspections/RsAssignToImmutableInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkAssignment", "", "expr", "Lorg/rust/lang/core/psi/RsBinaryExpr;", "registerDereferenceProblem", "left", "Lorg/rust/lang/core/psi/RsUnaryExpr;", "registerProblem", "message", "", "Lorg/rust/lang/core/psi/RsExpr;", "assigneeExpr", "checkAssignToMapIndexExpr", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsAssignToImmutableInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsAssignToImmutableInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitBinaryExpr(RsBinaryExpr expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                if (RsExprKt.isAssignBinaryExpr(expr)) {
                    RsAssignToImmutableInspection.access$checkAssignment(this.this$0, expr, this.$holder);
                }
            }
        };
    }

    private final void checkAssignment(RsBinaryExpr expr, RsProblemsHolder holder) {
        RsExpr rsExpr = expr.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getLeft(...)");
        RsExpr left = RsExprKt.unwrapParenExprs(rsExpr);
        if (this.checkAssignToMapIndexExpr(expr, holder)) {
            return;
        }
        if (!ExtensionsKt.isImmutable(left)) {
            return;
        }
        RsExpr rsExpr2 = left;
        if (rsExpr2 instanceof RsDotExpr) {
            this.registerProblem(holder, "field of immutable binding", expr, ((RsDotExpr)left).getReceiver());
        } else if (rsExpr2 instanceof RsIndexExpr) {
            this.registerProblem(holder, "indexed content of immutable binding", expr, RsIndexExprKt.getContainerExpr((RsIndexExpr)left));
        } else if (rsExpr2 instanceof RsUnaryExpr && RsUnaryExprKt.isDereference((RsUnaryExpr)left)) {
            this.registerDereferenceProblem((RsUnaryExpr)left, holder, expr);
        }
    }

    private final void registerDereferenceProblem(RsUnaryExpr left, RsProblemsHolder holder, RsBinaryExpr expr) {
        Ty ty2;
        RsExpr rsExpr = left.getExpr();
        Ty ty3 = ty2 = rsExpr != null ? ExtensionsKt.getType(rsExpr) : null;
        if (ty2 instanceof TyRef) {
            this.registerProblem(holder, "immutable borrowed content", expr, left);
        } else if (ty2 instanceof TyRawPtr) {
            this.registerProblem(holder, "immutable dereference of raw pointer", expr, left);
        }
    }

    private final void registerProblem(RsProblemsHolder holder, String message, RsExpr expr, RsExpr assigneeExpr) {
        Object object;
        block3: {
            block2: {
                object = assigneeExpr;
                if (object == null) break block2;
                RsExpr it2 = object;
                boolean bl = false;
                RsQuickFixBase[] rsQuickFixBaseArray = new RsQuickFixBase[]{AddMutableFix.Companion.createIfCompatible(it2), ChangeIterToIterMutFix.Companion.createIfCompatible(it2)};
                List list = CollectionsKt.listOfNotNull((Object[])rsQuickFixBaseArray);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        Object fixes = object;
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.CannotAssignToImmutable(expr, message, (List<? extends LocalQuickFix>)fixes), holder, false, null, 6, null);
    }

    static /* synthetic */ void registerProblem$default(RsAssignToImmutableInspection rsAssignToImmutableInspection, RsProblemsHolder rsProblemsHolder, String string, RsExpr rsExpr, RsExpr rsExpr2, int n, Object object) {
        if ((n & 8) != 0) {
            rsExpr2 = null;
        }
        rsAssignToImmutableInspection.registerProblem(rsProblemsHolder, string, rsExpr, rsExpr2);
    }

    private final boolean checkAssignToMapIndexExpr(RsBinaryExpr expr, RsProblemsHolder holder) {
        RsExpr rsExpr = expr.getLeft();
        RsIndexExpr rsIndexExpr = rsExpr instanceof RsIndexExpr ? (RsIndexExpr)rsExpr : null;
        if (rsIndexExpr == null) {
            return false;
        }
        RsIndexExpr left = rsIndexExpr;
        RsExpr container = RsIndexExprKt.getContainerExpr(left);
        Object[] objectArray = ExtensionsKt.getType(container);
        TyAdt tyAdt = objectArray instanceof TyAdt ? (TyAdt)objectArray : null;
        if (tyAdt == null) {
            return false;
        }
        TyAdt containerTy = tyAdt;
        KnownItems knownItems = KnownItemsKt.getKnownItems(left);
        objectArray = new RsStructOrEnumItemElement[]{knownItems.getHashMap(), knownItems.getBTreeMap()};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(containerTy.getItem())) {
            return false;
        }
        RsFixMapIndexExprAssignFix fix = new RsFixMapIndexExprAssignFix(expr);
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.CannotAssignToImmutable(expr, "indexed content of immutable binding", CollectionsKt.listOf((Object)((Object)fix))), holder, false, null, 6, null);
        return true;
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkAssignment(RsAssignToImmutableInspection $this, RsBinaryExpr expr, RsProblemsHolder holder) {
        $this.checkAssignment(expr, holder);
    }
}

