/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.macros.MacroExpansionKt;
import org.rust.lang.core.psi.MacroBraces;
import org.rust.lang.core.psi.RsAssertMacroArgument;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFormatMacroArg;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.EqualityOp;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.lang.core.resolve.ImplLookup;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.openapiext.Testmark;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/rust/ide/inspections/RsAssertEqualInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "SpecializedAssertQuickFix", "Testmarks", "intellij.rustrover.core"})
public final class RsAssertEqualInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitMacroCall2(RsMacroCall o) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (!Intrinsics.areEqual((Object)RsMacroCallKt.getMacroName(o), (Object)"assert")) {
                    return;
                }
                RsAssertMacroArgument rsAssertMacroArgument = o.getAssertMacroArgument();
                if (rsAssertMacroArgument == null) {
                    return;
                }
                RsAssertMacroArgument assertMacroArg = rsAssertMacroArgument;
                Object object = assertMacroArg.getExpr();
                RsBinaryExpr rsBinaryExpr = object instanceof RsBinaryExpr ? (RsBinaryExpr)object : null;
                if (rsBinaryExpr == null) {
                    return;
                }
                RsBinaryExpr expr = rsBinaryExpr;
                object = RsExprKt.getOperatorType(expr);
                if (Intrinsics.areEqual((Object)object, (Object)EqualityOp.EQ.INSTANCE)) {
                    pair = TuplesKt.to((Object)"assert_eq", (Object)"==");
                } else if (Intrinsics.areEqual((Object)object, (Object)EqualityOp.EXCLEQ.INSTANCE)) {
                    pair = TuplesKt.to((Object)"assert_ne", (Object)"!=");
                } else {
                    return;
                }
                Pair pair2 = pair;
                String macroName = (String)pair2.component1();
                String operator = (String)pair2.component2();
                if (!this.isExprSuitable(expr)) {
                    return;
                }
                Object[] objectArray = new Object[]{operator, macroName};
                String string = RsBundle.INSTANCE.message("inspection.message.assert.b.can.be.b", objectArray);
                objectArray = new LocalQuickFix[]{new SpecializedAssertQuickFix(o, macroName)};
                this.$holder.registerProblem((PsiElement)o, string, (LocalQuickFix[])objectArray);
            }

            private final boolean isExprSuitable(RsBinaryExpr expr) {
                if (RsExprKt.isInConstContext(expr)) {
                    return false;
                }
                RsExpr rsExpr = expr.getLeft();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getLeft(...)");
                Ty leftType = ExtensionsKt.getType(rsExpr);
                Object object = expr.getRight();
                if (object == null || (object = ExtensionsKt.getType((RsExpr)object)) == null) {
                    return false;
                }
                Object rightType = object;
                ImplLookup lookup2 = ImplLookup.Companion.relativeTo(expr);
                if (!lookup2.isDebug(leftType).isTrue() || !lookup2.isDebug((Ty)rightType).isTrue()) {
                    Testmarks.DebugTraitIsNotImplemented.INSTANCE.hit();
                    return false;
                }
                if (!lookup2.isPartialEq(leftType, (Ty)rightType).isTrue()) {
                    Testmarks.PartialEqTraitIsNotImplemented.INSTANCE.hit();
                    return false;
                }
                return true;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/inspections/RsAssertEqualInspection$SpecializedAssertQuickFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsMacroCall;", "element", "assertName", "", "<init>", "(Lorg/rust/lang/core/psi/RsMacroCall;Ljava/lang/String;)V", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "comparedAssertArgs", "Lkotlin/Pair;", "Lorg/rust/lang/core/psi/RsExpr;", "arg", "Lorg/rust/lang/core/psi/RsAssertMacroArgument;", "intellij.rustrover.core"})
    private static final class SpecializedAssertQuickFix
    extends RsQuickFixBase<RsMacroCall> {
        @NotNull
        private final String assertName;

        public SpecializedAssertQuickFix(@NotNull RsMacroCall element, @NotNull String assertName) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)assertName, (String)"assertName");
            super((PsiElement)element);
            this.assertName = assertName;
        }

        @Override
        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.assertName};
            return RsBundle.INSTANCE.message("intention.name.convert.to.macro", objectArray);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsMacroCall element) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsAssertMacroArgument rsAssertMacroArgument = element.getAssertMacroArgument();
            if (rsAssertMacroArgument == null) {
                return;
            }
            RsAssertMacroArgument assertArg = rsAssertMacroArgument;
            Pair<RsExpr, RsExpr> pair = this.comparedAssertArgs(assertArg);
            if (pair == null) {
                return;
            }
            Pair<RsExpr, RsExpr> pair2 = pair;
            RsExpr left = (RsExpr)pair2.component1();
            RsExpr right = (RsExpr)pair2.component2();
            List<RsFormatMacroArg> list = assertArg.getFormatMacroArgList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"<get-formatMacroArgList>(...)");
            List<RsFormatMacroArg> formatArgs = list;
            String appendix = !((Collection)formatArgs).isEmpty() ? CollectionsKt.joinToString$default((Iterable)formatArgs, (CharSequence)", ", (CharSequence)",", null, (int)0, null, SpecializedAssertQuickFix::invoke$lambda$0, (int)28, null) : "";
            MacroBraces macroBraces = RsMacroCallKt.getBracesKind(element);
            if (macroBraces == null) {
                return;
            }
            RsMacroCall newAssert = new RsPsiFactory(project, false, false, 6, null).createMacroCall(MacroExpansionKt.getExpansionContext(element), macroBraces, this.assertName, left.getText() + ", " + right.getText() + appendix);
            element.replace(newAssert);
        }

        private final Pair<RsExpr, RsExpr> comparedAssertArgs(RsAssertMacroArgument arg) {
            RsExpr rsExpr = arg.getExpr();
            RsBinaryExpr rsBinaryExpr = rsExpr instanceof RsBinaryExpr ? (RsBinaryExpr)rsExpr : null;
            if (rsBinaryExpr == null) {
                return null;
            }
            RsBinaryExpr expr = rsBinaryExpr;
            RsExpr rsExpr2 = expr.getRight();
            if (rsExpr2 == null) {
                return null;
            }
            RsExpr right = rsExpr2;
            return new Pair((Object)expr.getLeft(), (Object)right);
        }

        private static final CharSequence invoke$lambda$0(RsFormatMacroArg it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            String string = it2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/inspections/RsAssertEqualInspection$Testmarks;", "", "<init>", "()V", "PartialEqTraitIsNotImplemented", "DebugTraitIsNotImplemented", "intellij.rustrover.core"})
    public static final class Testmarks {
        @NotNull
        public static final Testmarks INSTANCE = new Testmarks();

        private Testmarks() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/ide/inspections/RsAssertEqualInspection$Testmarks$DebugTraitIsNotImplemented;", "Lorg/rust/openapiext/Testmark;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class DebugTraitIsNotImplemented
        extends Testmark {
            @NotNull
            public static final DebugTraitIsNotImplemented INSTANCE = new DebugTraitIsNotImplemented();

            private DebugTraitIsNotImplemented() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/ide/inspections/RsAssertEqualInspection$Testmarks$PartialEqTraitIsNotImplemented;", "Lorg/rust/openapiext/Testmark;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class PartialEqTraitIsNotImplemented
        extends Testmark {
            @NotNull
            public static final PartialEqTraitIsNotImplemented INSTANCE = new PartialEqTraitIsNotImplemented();

            private PartialEqTraitIsNotImplemented() {
            }
        }
    }
}

