/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.PredefinedConstant;
import org.rust.ide.inspections.RsApproxConstantInspection;
import org.rust.ide.inspections.RsApproxConstantInspectionKt;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.utils.import.ImportUtilsKt;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyFloat;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/inspections/RsApproxConstantInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "ReplaceWithPredefinedQuickFix", "intellij.rustrover.core"})
public final class RsApproxConstantInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitLitExpr(RsLitExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsLiteralKind literal = RsLiteralKindKt.getKind(o);
                if (literal instanceof RsLiteralKind.Float) {
                    String string;
                    Object v1;
                    Object object2;
                    block9: {
                        Double d = ((RsLiteralKind.Float)literal).getValue();
                        if (d == null) {
                            return;
                        }
                        double value = d;
                        Iterable iterable = RsApproxConstantInspectionKt.access$getKNOWN_CONSTS$p();
                        for (Object object2 : iterable) {
                            PredefinedConstant it2 = (PredefinedConstant)object2;
                            boolean bl = false;
                            if (!it2.matches(value)) continue;
                            v1 = object2;
                            break block9;
                        }
                        v1 = null;
                    }
                    PredefinedConstant predefinedConstant = v1;
                    if (predefinedConstant == null) {
                        return;
                    }
                    PredefinedConstant constant = predefinedConstant;
                    switch (buildVisitor.WhenMappings.$EnumSwitchMapping$0[ImportUtilsKt.getStdlibAttributes(o).ordinal()]) {
                        case 1: {
                            string = "std";
                            break;
                        }
                        case 2: {
                            string = "core";
                            break;
                        }
                        case 3: {
                            return;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    String lib = string;
                    Ty type = ExtensionsKt.getType(o);
                    String type2 = type instanceof TyFloat ? ((TyFloat)type).getName() : "f64";
                    Object[] objectArray = new Object[]{lib, type2, constant.getName()};
                    String path = RsBundle.INSTANCE.message("inspection.message.consts", objectArray);
                    ReplaceWithPredefinedQuickFix fix = new ReplaceWithPredefinedQuickFix(o, path);
                    object2 = new Object[]{path};
                    String string2 = RsBundle.INSTANCE.message("inspection.message.approximate.value.found.consider.using.it.directly", object2);
                    object2 = new LocalQuickFix[]{fix};
                    this.$holder.registerProblem((PsiElement)o, string2, (LocalQuickFix)object2);
                }
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/inspections/RsApproxConstantInspection$ReplaceWithPredefinedQuickFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsLitExpr;", "element", "path", "", "<init>", "(Lorg/rust/lang/core/psi/RsLitExpr;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
    private static final class ReplaceWithPredefinedQuickFix
    extends RsQuickFixBase<RsLitExpr> {
        @NotNull
        private final String path;

        public ReplaceWithPredefinedQuickFix(@NotNull RsLitExpr element, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super((PsiElement)element);
            this.path = path;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return RsBundle.INSTANCE.message("intention.family.name.replace.with.predefined.constant", new Object[0]);
        }

        @Override
        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.path};
            return RsBundle.INSTANCE.message("intention.name.replace.with2", objectArray);
        }

        @Override
        public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsLitExpr element) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsExpr pathExpr = new RsPsiFactory(project, false, false, 6, null).createExpression(this.path);
            element.replace(pathExpr);
        }
    }
}

