/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections;

import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.RsProjectTaskQueueService;
import org.rust.RsProjectTaskQueueServiceKt;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.lang.core.macros.MacroExpansionTaskListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/inspections/CargoCommandLineInspectionProjectConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator;", "<init>", "()V", "getName", "", "getDescription", "isApplicable", "", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "configureEnvironment", "", "preConfigureProject", "project", "Lcom/intellij/openapi/project/Project;", "configureProject", "LoggerWrapper", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoCommandLineInspectionProjectConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoCommandLineInspectionProjectConfigurator.kt\norg/rust/ide/inspections/CargoCommandLineInspectionProjectConfigurator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,134:1\n13#2:135\n*S KotlinDebug\n*F\n+ 1 CargoCommandLineInspectionProjectConfigurator.kt\norg/rust/ide/inspections/CargoCommandLineInspectionProjectConfigurator\n*L\n51#1:135\n*E\n"})
public final class CargoCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "cargo";
    }

    @NotNull
    public String getDescription() {
        return RsBundle.INSTANCE.message("cargo.commandline.description", new Object[0]);
    }

    public boolean isApplicable(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path path = context.getProjectPath().resolve("Cargo.toml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        System.setProperty("cargo.disable.project.refresh.on.creation", "true");
        Registry.Companion.get("external.system.auto.import.disabled").setValue(true);
    }

    public void preConfigureProject(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RustProjectSettingsServiceKt.getRustSettings(project).modify(CargoCommandLineInspectionProjectConfigurator::preConfigureProject$lambda$0);
    }

    public void configureProject(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CommandLineInspectionProgressReporter commandLineInspectionProgressReporter = context.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)commandLineInspectionProgressReporter, (String)"getLogger(...)");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CargoCommandLineInspectionProjectConfigurator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LoggerWrapper logger2 = new LoggerWrapper(commandLineInspectionProgressReporter, logger);
        CountDownLatch refreshStarted = new CountDownLatch(1);
        CountDownLatch refreshFinished = new CountDownLatch(1);
        CountDownLatch macroExpansionFinished = new CountDownLatch(1);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(CargoProjectsService.Companion.getCARGO_PROJECTS_REFRESH_TOPIC(), (Object)new CargoProjectsService.CargoProjectsRefreshListener(logger2, refreshStarted, refreshFinished){
            final /* synthetic */ LoggerWrapper $logger;
            final /* synthetic */ CountDownLatch $refreshStarted;
            final /* synthetic */ CountDownLatch $refreshFinished;
            {
                this.$logger = $logger;
                this.$refreshStarted = $refreshStarted;
                this.$refreshFinished = $refreshFinished;
            }

            public void onRefreshStarted(boolean isImplicitReload) {
                this.$logger.info("Cargo project model loading...");
                this.$refreshStarted.countDown();
            }

            public void onRefreshFinished(CargoProjectsService.CargoRefreshStatus status, List<? extends CargoProject> projects, boolean isImplicitReload) {
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                Intrinsics.checkNotNullParameter(projects, (String)"projects");
                this.$logger.info("Cargo project model loading finished: " + status);
                this.$refreshFinished.countDown();
            }
        });
        connection.subscribe(MacroExpansionTaskListener.Companion.getMACRO_EXPANSION_TASK_TOPIC(), (Object)new MacroExpansionTaskListener(macroExpansionFinished){
            final /* synthetic */ CountDownLatch $macroExpansionFinished;
            {
                this.$macroExpansionFinished = $macroExpansionFinished;
            }

            public void onMacroExpansionTaskFinished() {
                this.$macroExpansionFinished.countDown();
            }
        });
        CargoProjectsService cargoProjectsService = CargoProjectServiceKt.getCargoProjects(project);
        boolean result2 = CargoProjectServiceKt.guessAndSetupRustProject$default(project, true, false, 4, null);
        if (!result2) {
            if (cargoProjectsService.getHasAtLeastOneValidProject()) {
                CargoProjectsService.refreshAllProjects$default(cargoProjectsService, false, 1, null);
            } else {
                logger2.error("Cargo project model loading failed to start");
                return;
            }
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)refreshStarted);
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)refreshFinished);
        for (CargoProject cargoProject : cargoProjectsService.getAllProjects()) {
            CargoProject.UpdateStatus status = cargoProject.getMergedStatus();
            if (!(status instanceof CargoProject.UpdateStatus.UpdateFailed)) continue;
            logger2.error(((CargoProject.UpdateStatus.UpdateFailed)status).getReason() + ": " + ((CargoProject.UpdateStatus.UpdateFailed)status).getMessage());
        }
        logger2.info("Expanding Rust macros...");
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)macroExpansionFinished);
        RsProjectTaskQueueService taskQueue = RsProjectTaskQueueServiceKt.getTaskQueue(project);
        if (!taskQueue.isEmpty()) {
            while (!taskQueue.isEmpty()) {
                Thread.sleep(10L);
            }
        }
        logger2.info("Rust macro expansion has been finished");
    }

    private static final Unit preConfigureProject$lambda$0(RustProjectSettingsService.RustProjectSettings it2) {
        Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
        it2.setAutoUpdateEnabled(false);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/rust/ide/inspections/CargoCommandLineInspectionProjectConfigurator$LoggerWrapper;", "", "inspectionProgressReporter", "Lcom/intellij/ide/CommandLineInspectionProgressReporter;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/ide/CommandLineInspectionProgressReporter;Lcom/intellij/openapi/diagnostic/Logger;)V", "info", "", "message", "", "error", "intellij.rustrover.core"})
    private static final class LoggerWrapper {
        @NotNull
        private final CommandLineInspectionProgressReporter inspectionProgressReporter;
        @NotNull
        private final Logger logger;

        public LoggerWrapper(@NotNull CommandLineInspectionProgressReporter inspectionProgressReporter, @NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)inspectionProgressReporter, (String)"inspectionProgressReporter");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.inspectionProgressReporter = inspectionProgressReporter;
            this.logger = logger;
        }

        public final void info(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.logger.info(message);
            this.inspectionProgressReporter.reportMessage(1, message);
        }

        public final void error(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.logger.error(message);
            this.inspectionProgressReporter.reportError(message);
        }
    }
}

