/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.idea;

import com.intellij.ide.wizard.AbstractNewProjectWizardStep;
import com.intellij.ide.wizard.GitNewProjectWizardData;
import com.intellij.ide.wizard.NewProjectWizardBaseData;
import com.intellij.ide.wizard.NewProjectWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.module.RsModuleBuilder;
import org.rust.ide.newProject.RsProjectGeneratorPeer;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/idea/Step;", "Lcom/intellij/ide/wizard/AbstractNewProjectWizardStep;", "parent", "Lcom/intellij/ide/wizard/NewProjectWizardStep;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/ide/wizard/NewProjectWizardStep;Lkotlinx/coroutines/CoroutineScope;)V", "peer", "Lorg/rust/ide/newProject/RsProjectGeneratorPeer;", "setupUI", "", "builder", "Lcom/intellij/ui/dsl/builder/Panel;", "setupProject", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.rustrover.idea"})
final class Step
extends AbstractNewProjectWizardStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final RsProjectGeneratorPeer peer;
    @NotNull
    private static final String GITIGNORE = ".gitignore";

    public Step(@NotNull NewProjectWizardStep parent2, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(parent2);
        this.cs = cs;
        Object object = NewProjectWizardBaseData.Companion.getBaseData(parent2);
        if (object == null || (object = object.getPath()) == null || (object = UtilsKt.toPathOrNull((String)object)) == null) {
            object = Paths.get(".", new String[0]);
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        this.peer = new RsProjectGeneratorPeer((Path)object2, this.cs);
        Disposer.register((Disposable)this.getContext().getDisposable(), (Disposable)this.peer);
    }

    public void setupUI(@NotNull Panel builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Panel $this$setupUI_u24lambda_u240 = builder;
        boolean bl = false;
        Panel.row$default((Panel)$this$setupUI_u24lambda_u240, null, arg_0 -> Step.setupUI$lambda$0$0(this, arg_0), (int)1, null);
    }

    public void setupProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RsModuleBuilder builder = new RsModuleBuilder(this.cs);
        List list = builder.commit(project);
        if (list == null || (list = (Module)CollectionsKt.firstOrNull((List)list)) == null) {
            return;
        }
        List module = list;
        ModuleRootModificationUtil.updateModel((Module)module, arg_0 -> Step.setupProject$lambda$1(arg_0 -> Step.setupProject$lambda$0(builder, this, (Module)module, arg_0), arg_0));
    }

    private static final Unit setupUI$lambda$0$0(Step this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell(this$0.peer.getComponent()).align((Align)AlignX.FILL.INSTANCE).validationRequestor(arg_0 -> Step.setupUI$lambda$0$0$0(this$0, arg_0)).validationInfo((arg_0, arg_1) -> Step.setupUI$lambda$0$0$1(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$0$0$0(Step this$0, Function0 it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        this$0.peer.setCheckValid(() -> Step.setupUI$lambda$0$0$0$0(it2));
        return Unit.INSTANCE;
    }

    private static final void setupUI$lambda$0$0$0$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final ValidationInfo setupUI$lambda$0$0$1(Step this$0, ValidationInfoBuilder $this$validationInfo, JComponent it2) {
        Intrinsics.checkNotNullParameter((Object)$this$validationInfo, (String)"$this$validationInfo");
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this$0.peer.validate();
    }

    private static final Unit setupProject$lambda$0(RsModuleBuilder $builder, Step this$0, Module $module, ModifiableRootModel rootModel) {
        $builder.setConfigurationData(this$0.peer.getSettings());
        Intrinsics.checkNotNull((Object)rootModel);
        $builder.createProject(rootModel, "none");
        GitNewProjectWizardData gitNewProjectWizardData = GitNewProjectWizardData.Companion.getGitData((NewProjectWizardStep)this$0);
        boolean bl = gitNewProjectWizardData != null ? gitNewProjectWizardData.getGit() : false;
        if (bl) {
            ActionsKt.runWriteAction(() -> Step.setupProject$lambda$0$0(this$0, $module));
        }
        return Unit.INSTANCE;
    }

    private static final Unit setupProject$lambda$0$0(Step this$0, Module $module) {
        Path path = this$0.getContext().getProjectDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getProjectDirectory(...)");
        Step.Companion.createGitIgnoreFile(path, $module);
        return Unit.INSTANCE;
    }

    private static final void setupProject$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/rust/ide/idea/Step$Companion;", "", "<init>", "()V", "GITIGNORE", "", "createGitIgnoreFile", "", "projectDir", "Ljava/nio/file/Path;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.rustrover.idea"})
    public static final class Companion {
        private Companion() {
        }

        private final void createGitIgnoreFile(Path projectDir, Module module) {
            VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((String)((Object)projectDir).toString());
            if (virtualFile == null) {
                return;
            }
            VirtualFile directory = virtualFile;
            VirtualFile existingFile = directory.findChild(Step.GITIGNORE);
            if (existingFile != null) {
                return;
            }
            VirtualFile virtualFile2 = directory.createChildData((Object)module, Step.GITIGNORE);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildData(...)");
            VirtualFile file = virtualFile2;
            VfsUtil.saveText((VirtualFile)file, (String)"/target\n");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

