/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.hints.type;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.hints.type.MyFakePsiElement;
import org.rust.ide.hints.type.RsExpressionTypeProviderKt;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatField;
import org.rust.lang.core.psi.RsStructLiteralField;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.Adjustment;
import org.rust.lang.core.types.ty.Ty;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\"\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\b0\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000eH\u0003J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J2\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/rust/ide/hints/type/RsExpressionTypeProvider;", "Lcom/intellij/lang/ExpressionTypeProvider;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "getErrorHint", "", "getExpressionsAt", "", "pivot", "getInformationHint", "element", "getType", "Lkotlin/Pair;", "Lorg/rust/lang/core/types/ty/Ty;", "Lorg/rust/ide/hints/type/RsExpressionTypeProvider$AdjustedType;", "getTypeAndAdjustments", "Lorg/rust/lang/core/types/infer/Adjustment;", "renderTy", "ty", "renderAndAlignTypes", "type", "adjustedType", "alignTypes", "Lkotlin/Triple;", "Lorg/rust/ide/hints/type/RsExpressionTypeProvider$AlignedType;", "ty1", "ty2", "ty3", "AdjustedType", "AlignedType", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsExpressionTypeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsExpressionTypeProvider.kt\norg/rust/ide/hints/type/RsExpressionTypeProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class RsExpressionTypeProvider
extends ExpressionTypeProvider<PsiElement> {
    @NotNull
    public String getErrorHint() {
        return RsBundle.INSTANCE.message("hint.text.select.expression", new Object[0]);
    }

    @NotNull
    public List<PsiElement> getExpressionsAt(@NotNull PsiElement pivot) {
        Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.takeWhile(PsiElementKt.getContexts(RsExpandedElementKt.findExpansionElementOrSelf(pivot)), RsExpressionTypeProvider::getExpressionsAt$lambda$0), RsExpressionTypeProvider::getExpressionsAt$lambda$1), RsExpressionTypeProvider::getExpressionsAt$lambda$2));
    }

    @NotNull
    public String getInformationHint(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Pair<Ty, AdjustedType> pair = this.getType(element);
        Ty type = (Ty)pair.component1();
        AdjustedType adjustedType = (AdjustedType)pair.component2();
        if (adjustedType != null) {
            String hint2;
            Pair<String, String> pair2 = this.renderAndAlignTypes(type, adjustedType);
            String alignedType = (String)pair2.component1();
            String alignedCoerced = (String)pair2.component2();
            string = hint2 = StringsKt.trimIndent((String)("\n                <html>\n                    <table>\n                        <tr>\n                            <td style=\"color: #909090\">" + RsBundle.INSTANCE.message("type", new Object[0]) + ":</td>\n                            <td style=\"font-family: monospace;\">" + alignedType + "</td>\n                        </tr>\n                        <tr>\n                            <td style=\"color: #909090\">" + RsBundle.INSTANCE.message("coerced.type", new Object[0]) + ":</td>\n                            <td style=\"font-family: monospace;\">" + alignedCoerced + "</td>\n                        </tr>\n                    </table>\n                </html>\n            "));
        } else {
            string = UtilsKt.getEscaped(this.renderTy(type));
        }
        return string;
    }

    private final Pair<Ty, AdjustedType> getType(PsiElement element) {
        Ty ty2;
        Pair<Ty, List<Adjustment>> pair = this.getTypeAndAdjustments(element);
        Ty type = (Ty)pair.component1();
        List adjustments = (List)pair.component2();
        Adjustment adjustment = (Adjustment)SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)CollectionsKt.asSequence((Iterable)adjustments), RsExpressionTypeProvider::getType$lambda$0));
        Ty derefTy = adjustment != null && (ty2 = adjustment.getTarget()) != null ? ty2 : type;
        Adjustment adjustment2 = (Adjustment)CollectionsKt.lastOrNull((List)adjustments);
        Ty finalTy = adjustment2 != null ? adjustment2.getTarget() : null;
        return finalTy == null ? TuplesKt.to((Object)type, null) : TuplesKt.to((Object)type, (Object)new AdjustedType(derefTy, finalTy));
    }

    private final Pair<Ty, List<Adjustment>> getTypeAndAdjustments(PsiElement element) {
        Pair pair;
        PsiElement psiElement2 = element;
        if (psiElement2 instanceof MyFakePsiElement) {
            pair = this.getTypeAndAdjustments(((MyFakePsiElement)element).getElementInMacroExpansion());
        } else if (psiElement2 instanceof RsExpr) {
            pair = TuplesKt.to((Object)ExtensionsKt.getType((RsExpr)element), ExtensionsKt.getAdjustments((RsExpr)element));
        } else if (psiElement2 instanceof RsPat) {
            pair = TuplesKt.to((Object)ExtensionsKt.getType((RsPat)element), (Object)CollectionsKt.emptyList());
        } else if (psiElement2 instanceof RsPatField) {
            pair = TuplesKt.to((Object)ExtensionsKt.getType((RsPatField)element), (Object)CollectionsKt.emptyList());
        } else if (psiElement2 instanceof RsStructLiteralField) {
            pair = TuplesKt.to((Object)ExtensionsKt.getType((RsStructLiteralField)element), ExtensionsKt.getAdjustments((RsStructLiteralField)element));
        } else {
            throw new IllegalStateException(("Unexpected element type: " + element).toString());
        }
        return pair;
    }

    @NlsContexts.HintText
    private final String renderTy(Ty ty2) {
        return TypeRenderingKt.render$default(ty2, null, 0, null, null, null, null, null, null, null, false, false, false, false, false, false, false, null, 126975, null);
    }

    private final Pair<String, String> renderAndAlignTypes(Ty type, AdjustedType adjustedType) {
        Triple<AlignedType, AlignedType, AlignedType> triple = this.alignTypes(this.renderTy(type), this.renderTy(adjustedType.getDerefTy()), this.renderTy(adjustedType.getFinalTy()));
        AlignedType l1 = (AlignedType)triple.component1();
        AlignedType l3 = (AlignedType)triple.component3();
        String ty1aligned = StringsKt.repeat((CharSequence)"\u00a0", (int)l1.getAlignment()) + UtilsKt.getEscaped(l1.getText());
        String ty3aligned = StringsKt.repeat((CharSequence)"\u00a0", (int)l3.getAlignment()) + UtilsKt.getEscaped(l3.getText());
        return TuplesKt.to((Object)ty1aligned, (Object)ty3aligned);
    }

    private final Triple<AlignedType, AlignedType, AlignedType> alignTypes(String ty1, String ty2, String ty3) {
        Pair<AlignedType, AlignedType> pair = this.alignTypes(ty1, ty2);
        AlignedType t1 = (AlignedType)pair.component1();
        AlignedType t2 = (AlignedType)pair.component2();
        Pair<AlignedType, AlignedType> pair2 = this.alignTypes(ty2, ty3);
        AlignedType t2a = (AlignedType)pair2.component1();
        AlignedType t3 = (AlignedType)pair2.component2();
        int diff = t2a.getAlignment() - t2.getAlignment();
        return diff > 0 ? new Triple((Object)t1.adjust(diff), (Object)t2a, (Object)t3) : new Triple((Object)t1, (Object)t2, (Object)t3.adjust(-diff));
    }

    private final Pair<AlignedType, AlignedType> alignTypes(String ty1, String ty2) {
        Integer n = StringsKt.indexOf$default((CharSequence)ty2, (String)ty1, (int)0, (boolean)false, (int)6, null);
        int it2 = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it2 != -1 ? n : null;
        int ty1alignment = n2 != null ? n2 : 0;
        Integer n3 = StringsKt.indexOf$default((CharSequence)ty1, (String)ty2, (int)0, (boolean)false, (int)6, null);
        int it3 = ((Number)n3).intValue();
        boolean bl2 = false;
        Integer n4 = it3 != -1 ? n3 : null;
        int ty2alignment = n4 != null ? n4 : 0;
        return TuplesKt.to((Object)new AlignedType(ty1, ty1alignment), (Object)new AlignedType(ty2, ty2alignment));
    }

    private static final boolean getExpressionsAt$lambda$0(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return !(it2 instanceof RsItemElement);
    }

    private static final boolean getExpressionsAt$lambda$1(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2 instanceof RsExpr || it2 instanceof RsPat || it2 instanceof RsPatField || it2 instanceof RsStructLiteralField;
    }

    private static final PsiElement getExpressionsAt$lambda$2(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return RsExpressionTypeProviderKt.access$wrapExpandedElements(it2);
    }

    private static final boolean getType$lambda$0(Adjustment it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2 instanceof Adjustment.Deref;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/hints/type/RsExpressionTypeProvider$AdjustedType;", "", "derefTy", "Lorg/rust/lang/core/types/ty/Ty;", "finalTy", "<init>", "(Lorg/rust/lang/core/types/ty/Ty;Lorg/rust/lang/core/types/ty/Ty;)V", "getDerefTy", "()Lorg/rust/lang/core/types/ty/Ty;", "getFinalTy", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    private static final class AdjustedType {
        @NotNull
        private final Ty derefTy;
        @NotNull
        private final Ty finalTy;

        public AdjustedType(@NotNull Ty derefTy, @NotNull Ty finalTy) {
            Intrinsics.checkNotNullParameter((Object)derefTy, (String)"derefTy");
            Intrinsics.checkNotNullParameter((Object)finalTy, (String)"finalTy");
            this.derefTy = derefTy;
            this.finalTy = finalTy;
        }

        @NotNull
        public final Ty getDerefTy() {
            return this.derefTy;
        }

        @NotNull
        public final Ty getFinalTy() {
            return this.finalTy;
        }

        @NotNull
        public final Ty component1() {
            return this.derefTy;
        }

        @NotNull
        public final Ty component2() {
            return this.finalTy;
        }

        @NotNull
        public final AdjustedType copy(@NotNull Ty derefTy, @NotNull Ty finalTy) {
            Intrinsics.checkNotNullParameter((Object)derefTy, (String)"derefTy");
            Intrinsics.checkNotNullParameter((Object)finalTy, (String)"finalTy");
            return new AdjustedType(derefTy, finalTy);
        }

        public static /* synthetic */ AdjustedType copy$default(AdjustedType adjustedType, Ty ty2, Ty ty3, int n, Object object) {
            if ((n & 1) != 0) {
                ty2 = adjustedType.derefTy;
            }
            if ((n & 2) != 0) {
                ty3 = adjustedType.finalTy;
            }
            return adjustedType.copy(ty2, ty3);
        }

        @NotNull
        public String toString() {
            return "AdjustedType(derefTy=" + this.derefTy + ", finalTy=" + this.finalTy + ")";
        }

        public int hashCode() {
            int result2 = this.derefTy.hashCode();
            result2 = result2 * 31 + this.finalTy.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdjustedType)) {
                return false;
            }
            AdjustedType adjustedType = (AdjustedType)other;
            if (!Intrinsics.areEqual((Object)this.derefTy, (Object)adjustedType.derefTy)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.finalTy, (Object)adjustedType.finalTy);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/hints/type/RsExpressionTypeProvider$AlignedType;", "", "text", "", "alignment", "", "<init>", "(Ljava/lang/String;I)V", "getText", "()Ljava/lang/String;", "getAlignment", "()I", "adjust", "offset", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.rustrover.core"})
    private static final class AlignedType {
        @NotNull
        private final String text;
        private final int alignment;

        public AlignedType(@NotNull String text, int alignment) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
            this.alignment = alignment;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final int getAlignment() {
            return this.alignment;
        }

        @NotNull
        public final AlignedType adjust(int offset) {
            return new AlignedType(this.text, this.alignment + offset);
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        public final int component2() {
            return this.alignment;
        }

        @NotNull
        public final AlignedType copy(@NotNull String text, int alignment) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new AlignedType(text, alignment);
        }

        public static /* synthetic */ AlignedType copy$default(AlignedType alignedType, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = alignedType.text;
            }
            if ((n2 & 2) != 0) {
                n = alignedType.alignment;
            }
            return alignedType.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "AlignedType(text=" + this.text + ", alignment=" + this.alignment + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.alignment);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AlignedType)) {
                return false;
            }
            AlignedType alignedType = (AlignedType)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)alignedType.text)) {
                return false;
            }
            return this.alignment == alignedType.alignment;
        }
    }
}

