/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.hints.parameter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.hints.parameter.HintLine;
import org.rust.ide.hints.parameter.RsAsyncParameterInfoHandler;
import org.rust.ide.hints.parameter.RsGenericParameterInfoHandlerKt;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsTypeArgumentList;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsGenericDeclarationKt;
import org.rust.lang.core.psi.ext.RsReferenceElement;
import org.rust.lang.core.resolve.ref.RsReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001d\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/hints/parameter/RsGenericParameterInfoHandler;", "Lorg/rust/ide/hints/parameter/RsAsyncParameterInfoHandler;", "Lorg/rust/lang/core/psi/RsTypeArgumentList;", "Lorg/rust/ide/hints/parameter/HintLine;", "<init>", "()V", "findTargetElement", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "calculateParameterInfo", "", "element", "(Lorg/rust/lang/core/psi/RsTypeArgumentList;)[Lorg/rust/ide/hints/parameter/HintLine;", "showParameterInfo", "", "context", "Lcom/intellij/lang/parameterInfo/CreateParameterInfoContext;", "updateParameterInfo", "parameterOwner", "Lcom/intellij/lang/parameterInfo/UpdateParameterInfoContext;", "updateUI", "p", "Lcom/intellij/lang/parameterInfo/ParameterInfoUIContext;", "findExceptColonColon", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsGenericParameterInfoHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsGenericParameterInfoHandler.kt\norg/rust/ide/hints/parameter/RsGenericParameterInfoHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,135:1\n37#2,2:136\n9#3:138\n*S KotlinDebug\n*F\n+ 1 RsGenericParameterInfoHandler.kt\norg/rust/ide/hints/parameter/RsGenericParameterInfoHandler\n*L\n36#1:136,2\n70#1:138\n*E\n"})
public final class RsGenericParameterInfoHandler
extends RsAsyncParameterInfoHandler<RsTypeArgumentList, HintLine> {
    @Override
    @Nullable
    public RsTypeArgumentList findTargetElement(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.findExceptColonColon(file, offset);
    }

    @Nullable
    public HintLine[] calculateParameterInfo(@NotNull RsTypeArgumentList element) {
        RsGenericDeclaration rsGenericDeclaration;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof RsMethodCall || parent2 instanceof RsPath) {
            RsReference rsReference = ((RsReferenceElement)parent2).getReference();
            objectArray = rsReference != null ? rsReference.resolve() : null;
            rsGenericDeclaration = objectArray instanceof RsGenericDeclaration ? (RsGenericDeclaration)objectArray : null;
            if (rsGenericDeclaration == null) {
                return null;
            }
        } else {
            return null;
        }
        RsGenericDeclaration genericDeclaration = rsGenericDeclaration;
        List paramsWithBounds = RsGenericDeclarationKt.getExpandedGenericParameters$default(genericDeclaration, false, false, false, 6, null);
        if (paramsWithBounds.isEmpty()) {
            return null;
        }
        objectArray = new HintLine[]{RsGenericParameterInfoHandlerKt.access$firstLine(paramsWithBounds), RsGenericParameterInfoHandlerKt.access$secondLine(paramsWithBounds)};
        Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new HintLine[0]);
    }

    @Override
    public void showParameterInfo(@NotNull RsTypeArgumentList element, @NotNull CreateParameterInfoContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.setHighlightedElement(null);
        super.showParameterInfo((PsiElement)element, context);
    }

    public void updateParameterInfo(@NotNull RsTypeArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        Intrinsics.checkNotNullParameter((Object)parameterOwner, (String)"parameterOwner");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Intrinsics.areEqual((Object)context.getParameterOwner(), (Object)parameterOwner)) {
            context.removeHint();
            return;
        }
        int curParam = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)RsElementTypes.COMMA);
        context.setCurrentParameter(curParam);
    }

    public void updateUI(@NotNull HintLine p, @NotNull ParameterInfoUIContext context) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.setupUIComponentPresentation(p.getPresentText(), p.getRange(context.getCurrentParameterIndex()).getStartOffset(), p.getRange(context.getCurrentParameterIndex()).getEndOffset(), false, false, false, context.getDefaultParameterColor());
    }

    private final RsTypeArgumentList findExceptColonColon(PsiFile file, int offset) {
        PsiElement psiElement2 = file.findElementAt(offset);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement element = psiElement2;
        if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(element), (Object)RsElementTypes.COLONCOLON)) {
            return null;
        }
        PsiElement $this$ancestorStrict$iv = element;
        boolean $i$f$ancestorStrict = false;
        return (RsTypeArgumentList)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsTypeArgumentList.class, (boolean)true);
    }
}

