/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.hints.codeVision;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.InheritorsCodeVisionProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.lineMarkers.RsImplsPopupHandler;
import org.rust.ide.statistics.RsCodeVisionUsageCollector;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsTraitItemKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\fH\u0016R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lorg/rust/ide/hints/codeVision/RsImplementationsCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/codeVision/InheritorsCodeVisionProvider;", "<init>", "()V", "acceptsFile", "", "file", "Lcom/intellij/psi/PsiFile;", "acceptsElement", "element", "Lcom/intellij/psi/PsiElement;", "getHint", "", "handleClick", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "event", "Ljava/awt/event/MouseEvent;", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "id", "getId", "()Ljava/lang/String;", "logClickToFUS", "hint", "Companion", "intellij.rustrover.core"})
public final class RsImplementationsCodeVisionProvider
extends InheritorsCodeVisionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    public static final String ID = "rust.inheritors";

    public RsImplementationsCodeVisionProvider() {
        this.id = ID;
    }

    public boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof RsFile;
    }

    public boolean acceptsElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!UtilsKt.isUnitTestMode() && !Registry.Companion.is("org.rust.code.vision.implementation", false)) {
            return false;
        }
        PsiElement psiElement2 = element;
        return psiElement2 instanceof RsTraitItem ? true : (psiElement2 instanceof RsAbstractable ? RsAbstractableKt.getOwner((RsAbstractable)element) instanceof RsAbstractableOwner.Trait : false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getHint(@NotNull PsiElement element, @NotNull PsiFile file) {
        String string;
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)file.getViewProvider().getVirtualFile().getPath(), (Object)"/dummy")) {
            String string2;
            PsiElement psiElement2 = element;
            if (psiElement2 instanceof RsTraitItem) {
                Object[] objectArray2 = new Object[]{2};
                string2 = RsBundle.INSTANCE.message("rust.code.vision.implementation.hint", objectArray2);
                return string2;
            } else {
                if (!(psiElement2 instanceof RsFunction)) return null;
                Object[] objectArray3 = new Object[]{1};
                string2 = RsBundle.INSTANCE.message("rust.code.vision.implementation.hint", objectArray3);
            }
            return string2;
        }
        PsiElement psiElement3 = element;
        if (psiElement3 instanceof RsTraitItem) {
            n = RsTraitItemKt.getCachedImplementationCount((RsTraitItem)element).getTraitImplsCount();
        } else {
            if (!(psiElement3 instanceof RsAbstractable)) return null;
            RsAbstractableOwner owner = RsAbstractableKt.getOwner((RsAbstractable)element);
            if (!(owner instanceof RsAbstractableOwner.Trait)) return null;
            n = RsTraitItemKt.getCachedImplementationCount(((RsAbstractableOwner.Trait)owner).getTrait()).getOverridesCountOfMember((RsAbstractable)element);
        }
        int implementationCount = n;
        if (implementationCount == 0) {
            return null;
        }
        psiElement3 = (RsElement)element;
        if (psiElement3 instanceof RsTraitItem) {
            objectArray = new Object[]{implementationCount};
            return RsBundle.INSTANCE.message("rust.code.vision.implementation.hint", objectArray);
        }
        if (!(psiElement3 instanceof RsAbstractable)) return null;
        if (((RsAbstractable)element).isAbstract()) {
            objectArray = new Object[]{implementationCount};
            string = RsBundle.INSTANCE.message("rust.code.vision.implementation.hint", objectArray);
            return string;
        } else {
            objectArray = new Object[]{implementationCount};
            string = RsBundle.INSTANCE.message("rust.code.vision.overrides.hint", objectArray);
        }
        return string;
    }

    public void handleClick(@NotNull Editor editor2, @NotNull PsiElement element, @Nullable MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof PsiNameIdentifierOwner) || event == null) {
            return;
        }
        PsiElement psiElement2 = ((PsiNameIdentifierOwner)element).getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = element;
        }
        RsImplsPopupHandler.INSTANCE.navigate(event, psiElement2);
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.listOf((Object)new CodeVisionRelativeOrdering.CodeVisionRelativeOrderingAfter("rust.references"));
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public void logClickToFUS(@NotNull PsiElement element, @NotNull String hint2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hint2, (String)"hint");
        RsCodeVisionUsageCollector.INSTANCE.logImplementationsClicked(element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/hints/codeVision/RsImplementationsCodeVisionProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

