/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.highlight.multispot.lifetime;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.IndentsModelImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.highlight.multispot.RsMultispotUtil;
import org.rust.lang.utils.SecondarySpot;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004$%&'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u0011*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001f\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017H\u0082\bJ\u001e\u0010\u0018\u001a\u00020\u0007*\u00020\u00192\u0006\u0010\f\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0014\u0010\u0018\u001a\u00020\u0007*\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0015H\u0002J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ8\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "charIsWhitespace", "", "offset", "", "getLineIndent", "line", "withAA", "Ljava/awt/Graphics2D;", "block", "Lkotlin/Function0;", "draw", "Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$StripeInfo;", "color", "Ljava/awt/Color;", "Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$QuestionMarkInfo;", "getConnectionInfo", "Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$ConnectionInfo;", "startLine", "indent", "endLine", "width", "", "ConnectionInfo", "StripeInfo", "DoublePoint", "QuestionMarkInfo", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsLifetimeConnectionRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLifetimeConnectionRenderer.kt\norg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,228:1\n76#1,7:229\n774#2:236\n865#2,2:237\n1999#2,14:239\n1#3:253\n13#4:254\n*S KotlinDebug\n*F\n+ 1 RsLifetimeConnectionRenderer.kt\norg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer\n*L\n44#1:229,7\n125#1:236\n125#1:237,2\n126#1:239,14\n25#1:254\n*E\n"})
public final class RsMultispotConnectionRenderer
implements CustomHighlighterRenderer {
    @NotNull
    public static final RsMultispotConnectionRenderer INSTANCE = new RsMultispotConnectionRenderer();
    @NotNull
    private static final Logger LOG;

    private RsMultispotConnectionRenderer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!(g instanceof Graphics2D)) {
            return;
        }
        RsMultispotConnectionRenderer rsMultispotConnectionRenderer = this;
        try {
            RsMultispotConnectionRenderer $this$paint_u24lambda_u240 = rsMultispotConnectionRenderer;
            boolean bl = false;
            ConnectionInfo connectionInfo = $this$paint_u24lambda_u240.getConnectionInfo(editor2, highlighter);
            if (connectionInfo == null) {
                return;
            }
            ConnectionInfo shapeInfo = connectionInfo;
            Color color = editor2.getColorsScheme().getAttributes(SecondarySpot.Companion.getATTRIBUTES()).getEffectColor();
            if (color == null) {
                return;
            }
            Color lifetimeStripeColor = color;
            Color errorSubStripeColor = editor2.getColorsScheme().getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getEffectColor();
            RsMultispotConnectionRenderer rsMultispotConnectionRenderer2 = $this$paint_u24lambda_u240;
            Graphics2D g$iv = (Graphics2D)g;
            boolean $i$f$withAA = false;
            GraphicsConfig config$iv = GraphicsUtil.setupAAPainting((Graphics)g$iv);
            try {
                boolean bl2 = false;
                $this$paint_u24lambda_u240.draw(shapeInfo.getLifetimeStripe(), (Graphics2D)g, lifetimeStripeColor);
                StripeInfo stripeInfo = shapeInfo.getErrorSubStripe();
                if (stripeInfo != null) {
                    $this$paint_u24lambda_u240.draw(stripeInfo, (Graphics2D)g, errorSubStripeColor);
                }
                QuestionMarkInfo questionMarkInfo = shapeInfo.getQuestionMark();
                if (questionMarkInfo != null) {
                    $this$paint_u24lambda_u240.draw(questionMarkInfo, (Graphics2D)g);
                }
            }
            finally {
                config$iv.restore();
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final boolean charIsWhitespace(Editor $this$charIsWhitespace, int offset) {
        CharSequence charSequence = $this$charIsWhitespace.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence chars = charSequence;
        Character c = StringsKt.getOrNull((CharSequence)chars, (int)offset);
        return c != null ? CharsKt.isWhitespace((char)c.charValue()) : false;
    }

    private final int getLineIndent(Editor $this$getLineIndent, int line) {
        int startOffset = $this$getLineIndent.getDocument().getLineStartOffset(line);
        int endOffset = $this$getLineIndent.getDocument().getLineEndOffset(line);
        int tabSize = EditorUtil.getTabSize((Editor)$this$getLineIndent);
        CharSequence charSequence = $this$getLineIndent.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence chars = charSequence;
        int column = 0;
        block4: for (int i2 = startOffset; i2 < endOffset; ++i2) {
            switch (chars.charAt(i2)) {
                case ' ': {
                    ++column;
                    continue block4;
                }
                case '\t': {
                    int cfr_ignored_0 = (column / tabSize + 1) * tabSize;
                    continue block4;
                }
            }
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withAA(Graphics2D g, Function0<Unit> block) {
        boolean $i$f$withAA = false;
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            config.restore();
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final void draw(StripeInfo $this$draw, Graphics2D g, Color color) {
        if (color == null) {
            return;
        }
        g.setColor(color);
        RectanglePainter2D.FILL.paint(g, $this$draw.getTopLeft().getX(), $this$draw.getTopLeft().getY(), $this$draw.getWidth(), $this$draw.getHeight(), (Object)$this$draw.getArch());
    }

    private final void draw(QuestionMarkInfo $this$draw, Graphics2D g) {
        $this$draw.getIcon().paintIcon(null, g, (int)$this$draw.getTopLeft().getX(), (int)$this$draw.getTopLeft().getY());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConnectionInfo getConnectionInfo(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter) {
        int indent;
        Object v3;
        void $this$maxByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        int startLine = editor2.getDocument().getLineNumber(highlighter.getStartOffset());
        int endLine = editor2.getDocument().getLineNumber(highlighter.getEndOffset());
        double width = JBUIScale.scale((int)2);
        int startLineOffset = editor2.getDocument().getLineStartOffset(startLine);
        int endLineOffset = editor2.getDocument().getLineEndOffset(endLine);
        List list = editor2.getSoftWrapModel().getSoftWrapsForRange(startLineOffset, endLineOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSoftWrapsForRange(...)");
        if (!((Collection)list).isEmpty()) {
            return null;
        }
        Object object = editor2.getIndentsModel();
        IndentsModelImpl indentsModelImpl = object instanceof IndentsModelImpl ? (IndentsModelImpl)object : null;
        if (indentsModelImpl == null) {
            return null;
        }
        IndentsModelImpl indentsModelImpl2 = indentsModelImpl;
        List list2 = indentsModelImpl2.getIndents();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIndents(...)");
        object = list2;
        boolean $i$f$filter = false;
        void var13_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IndentGuideDescriptor it2 = (IndentGuideDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it2.startLine <= startLine && it2.endLine >= endLine)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = maxElem$iv;
            } else {
                IndentGuideDescriptor it3 = (IndentGuideDescriptor)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it3.indentLevel;
                do {
                    Object e$iv = iterator$iv.next();
                    IndentGuideDescriptor it4 = (IndentGuideDescriptor)e$iv;
                    $i$a$-maxByOrNull-RsMultispotConnectionRenderer$getConnectionInfo$indentGuideDescriptor$2 = false;
                    int v$iv = it4.indentLevel;
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = maxElem$iv;
            }
        }
        IndentGuideDescriptor indentGuideDescriptor = v3;
        IndentGuideDescriptor indentGuideDescriptor2 = indentGuideDescriptor;
        int startLineToUse = (indentGuideDescriptor2 != null ? indentGuideDescriptor2.startLine == startLine : false) ? startLine + 1 : (indentGuideDescriptor == null && !this.charIsWhitespace(editor2, startLineOffset) ? startLine + 1 : startLine);
        IndentGuideDescriptor indentGuideDescriptor3 = indentGuideDescriptor;
        int endLineToUse = (indentGuideDescriptor3 != null ? indentGuideDescriptor3.endLine == endLine : false) ? endLine - 1 : (indentGuideDescriptor == null && !this.charIsWhitespace(editor2, endLineOffset) ? endLine - 1 : endLine);
        IndentGuideDescriptor indentGuideDescriptor4 = indentGuideDescriptor;
        int blockIndent = indentGuideDescriptor4 != null ? indentGuideDescriptor4.indentLevel : 0;
        int lineIndent = this.getLineIndent(editor2, startLineToUse);
        if (lineIndent < blockIndent) {
            return null;
        }
        int n = indent = lineIndent - blockIndent >= 4 ? blockIndent + 3 : blockIndent + (lineIndent - blockIndent) / 2;
        if (startLineToUse >= endLineToUse) {
            return null;
        }
        return this.getConnectionInfo(editor2, highlighter, startLineToUse, indent, endLineToUse, width);
    }

    private final ConnectionInfo getConnectionInfo(Editor editor2, RangeHighlighter highlighter, int startLine, int indent, int endLine, double width) {
        QuestionMarkInfo questionMarkInfo;
        StripeInfo stripeInfo;
        int lineHeight = editor2.getLineHeight();
        RsMultispotConnectionRenderer $this$getConnectionInfo_u24lambda_u242 = this;
        boolean bl = false;
        int startLineOffset = editor2.getDocument().getLineStartOffset(startLine);
        Point point = editor2.offsetToXY(startLineOffset + indent);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Serializable start2 = point;
        int endLineOffset = editor2.getDocument().getLineStartOffset(endLine);
        Point point2 = editor2.offsetToXY(endLineOffset + indent);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
        Point end = point2;
        int shift = lineHeight - editor2.getAscent();
        StripeInfo lifetimeStripeInfo = new StripeInfo(new DoublePoint(start2.x, (double)start2.y + (double)shift), new DoublePoint((double)start2.x + width, (double)end.y + (double)lineHeight - (double)shift), width);
        RsMultispotConnectionRenderer $this$getConnectionInfo_u24lambda_u243 = this;
        boolean bl2 = false;
        start2 = RsMultispotUtil.INSTANCE.getOriginalErrorOffset(highlighter);
        if (start2 == null) {
            stripeInfo = null;
        } else {
            int it2 = ((Number)start2).intValue();
            boolean bl3 = false;
            int errorLine = editor2.getDocument().getLineNumber(it2);
            if (!(startLine + 1 <= errorLine ? errorLine < endLine : false)) {
                stripeInfo = null;
            } else {
                int errorLineOffset = editor2.getDocument().getLineStartOffset(errorLine);
                Point point3 = editor2.offsetToXY(errorLineOffset + indent);
                Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"offsetToXY(...)");
                Point error = point3;
                stripeInfo = new StripeInfo(new DoublePoint(error.x, error.y), new DoublePoint((double)error.x + width, (double)error.y + (double)lineHeight), null);
            }
        }
        StripeInfo errorSubStripeInfo = stripeInfo;
        RsMultispotConnectionRenderer $this$getConnectionInfo_u24lambda_u244 = this;
        boolean bl4 = false;
        if (!RsMultispotUtil.INSTANCE.isQuestionMarkNeeded()) {
            questionMarkInfo = null;
        } else {
            int charWidth = editor2.getContentComponent().getFontMetrics(editor2.getColorsScheme().getFont(EditorFontType.PLAIN)).charWidth('m');
            double targetWidth = (double)(2 * charWidth) - (double)3 * lifetimeStripeInfo.getWidth();
            Icon icon = AllIcons.General.ContextHelp;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ContextHelp");
            Icon unscaledIcon = icon;
            Icon icon2 = IconUtil.scale((Icon)unscaledIcon, null, (float)((float)targetWidth / (float)unscaledIcon.getIconWidth()));
            questionMarkInfo = new QuestionMarkInfo(icon2, new DoublePoint(lifetimeStripeInfo.getTopLeft().getX() - (double)icon2.getIconWidth() - lifetimeStripeInfo.getWidth(), lifetimeStripeInfo.getBottomRight().getY() - (double)icon2.getIconHeight()));
        }
        QuestionMarkInfo questionMarkInfo2 = questionMarkInfo;
        return new ConnectionInfo(lifetimeStripeInfo, errorSubStripeInfo, questionMarkInfo2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsMultispotConnectionRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J+\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$ConnectionInfo;", "", "lifetimeStripe", "Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$StripeInfo;", "errorSubStripe", "questionMark", "Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$QuestionMarkInfo;", "<init>", "(Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$StripeInfo;Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$StripeInfo;Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$QuestionMarkInfo;)V", "getLifetimeStripe", "()Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$StripeInfo;", "getErrorSubStripe", "getQuestionMark", "()Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$QuestionMarkInfo;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class ConnectionInfo {
        @NotNull
        private final StripeInfo lifetimeStripe;
        @Nullable
        private final StripeInfo errorSubStripe;
        @Nullable
        private final QuestionMarkInfo questionMark;

        public ConnectionInfo(@NotNull StripeInfo lifetimeStripe, @Nullable StripeInfo errorSubStripe, @Nullable QuestionMarkInfo questionMark) {
            Intrinsics.checkNotNullParameter((Object)lifetimeStripe, (String)"lifetimeStripe");
            this.lifetimeStripe = lifetimeStripe;
            this.errorSubStripe = errorSubStripe;
            this.questionMark = questionMark;
        }

        @NotNull
        public final StripeInfo getLifetimeStripe() {
            return this.lifetimeStripe;
        }

        @Nullable
        public final StripeInfo getErrorSubStripe() {
            return this.errorSubStripe;
        }

        @Nullable
        public final QuestionMarkInfo getQuestionMark() {
            return this.questionMark;
        }

        @NotNull
        public final StripeInfo component1() {
            return this.lifetimeStripe;
        }

        @Nullable
        public final StripeInfo component2() {
            return this.errorSubStripe;
        }

        @Nullable
        public final QuestionMarkInfo component3() {
            return this.questionMark;
        }

        @NotNull
        public final ConnectionInfo copy(@NotNull StripeInfo lifetimeStripe, @Nullable StripeInfo errorSubStripe, @Nullable QuestionMarkInfo questionMark) {
            Intrinsics.checkNotNullParameter((Object)lifetimeStripe, (String)"lifetimeStripe");
            return new ConnectionInfo(lifetimeStripe, errorSubStripe, questionMark);
        }

        public static /* synthetic */ ConnectionInfo copy$default(ConnectionInfo connectionInfo, StripeInfo stripeInfo, StripeInfo stripeInfo2, QuestionMarkInfo questionMarkInfo, int n, Object object) {
            if ((n & 1) != 0) {
                stripeInfo = connectionInfo.lifetimeStripe;
            }
            if ((n & 2) != 0) {
                stripeInfo2 = connectionInfo.errorSubStripe;
            }
            if ((n & 4) != 0) {
                questionMarkInfo = connectionInfo.questionMark;
            }
            return connectionInfo.copy(stripeInfo, stripeInfo2, questionMarkInfo);
        }

        @NotNull
        public String toString() {
            return "ConnectionInfo(lifetimeStripe=" + this.lifetimeStripe + ", errorSubStripe=" + this.errorSubStripe + ", questionMark=" + this.questionMark + ")";
        }

        public int hashCode() {
            int result2 = this.lifetimeStripe.hashCode();
            result2 = result2 * 31 + (this.errorSubStripe == null ? 0 : this.errorSubStripe.hashCode());
            result2 = result2 * 31 + (this.questionMark == null ? 0 : this.questionMark.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionInfo)) {
                return false;
            }
            ConnectionInfo connectionInfo = (ConnectionInfo)other;
            if (!Intrinsics.areEqual((Object)this.lifetimeStripe, (Object)connectionInfo.lifetimeStripe)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.errorSubStripe, (Object)connectionInfo.errorSubStripe)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.questionMark, (Object)connectionInfo.questionMark);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$DoublePoint;", "", "x", "", "y", "<init>", "(DD)V", "getX", "()D", "getY", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class DoublePoint {
        private final double x;
        private final double y;

        public DoublePoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double component1() {
            return this.x;
        }

        public final double component2() {
            return this.y;
        }

        @NotNull
        public final DoublePoint copy(double x, double y) {
            return new DoublePoint(x, y);
        }

        public static /* synthetic */ DoublePoint copy$default(DoublePoint doublePoint, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                d = doublePoint.x;
            }
            if ((n & 2) != 0) {
                d2 = doublePoint.y;
            }
            return doublePoint.copy(d, d2);
        }

        @NotNull
        public String toString() {
            return "DoublePoint(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result2 = Double.hashCode(this.x);
            result2 = result2 * 31 + Double.hashCode(this.y);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DoublePoint)) {
                return false;
            }
            DoublePoint doublePoint = (DoublePoint)other;
            if (Double.compare(this.x, doublePoint.x) != 0) {
                return false;
            }
            return Double.compare(this.y, doublePoint.y) == 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$QuestionMarkInfo;", "", "icon", "Ljavax/swing/Icon;", "topLeft", "Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$DoublePoint;", "<init>", "(Ljavax/swing/Icon;Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$DoublePoint;)V", "getIcon", "()Ljavax/swing/Icon;", "getTopLeft", "()Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$DoublePoint;", "bottomRight", "getBottomRight", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class QuestionMarkInfo {
        @NotNull
        private final Icon icon;
        @NotNull
        private final DoublePoint topLeft;

        public QuestionMarkInfo(@NotNull Icon icon, @NotNull DoublePoint topLeft) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
            this.icon = icon;
            this.topLeft = topLeft;
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public final DoublePoint getTopLeft() {
            return this.topLeft;
        }

        @NotNull
        public final DoublePoint getBottomRight() {
            return new DoublePoint(this.topLeft.getX() + (double)this.icon.getIconWidth(), this.topLeft.getY() + (double)this.icon.getIconHeight());
        }

        @NotNull
        public final Icon component1() {
            return this.icon;
        }

        @NotNull
        public final DoublePoint component2() {
            return this.topLeft;
        }

        @NotNull
        public final QuestionMarkInfo copy(@NotNull Icon icon, @NotNull DoublePoint topLeft) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
            return new QuestionMarkInfo(icon, topLeft);
        }

        public static /* synthetic */ QuestionMarkInfo copy$default(QuestionMarkInfo questionMarkInfo, Icon icon, DoublePoint doublePoint, int n, Object object) {
            if ((n & 1) != 0) {
                icon = questionMarkInfo.icon;
            }
            if ((n & 2) != 0) {
                doublePoint = questionMarkInfo.topLeft;
            }
            return questionMarkInfo.copy(icon, doublePoint);
        }

        @NotNull
        public String toString() {
            return "QuestionMarkInfo(icon=" + this.icon + ", topLeft=" + this.topLeft + ")";
        }

        public int hashCode() {
            int result2 = this.icon.hashCode();
            result2 = result2 * 31 + this.topLeft.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuestionMarkInfo)) {
                return false;
            }
            QuestionMarkInfo questionMarkInfo = (QuestionMarkInfo)other;
            if (!Intrinsics.areEqual((Object)this.icon, (Object)questionMarkInfo.icon)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.topLeft, (Object)questionMarkInfo.topLeft);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ.\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006 "}, d2={"Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$StripeInfo;", "", "topLeft", "Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$DoublePoint;", "bottomRight", "arch", "", "<init>", "(Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$DoublePoint;Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$DoublePoint;Ljava/lang/Double;)V", "getTopLeft", "()Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$DoublePoint;", "getBottomRight", "getArch", "()Ljava/lang/Double;", "Ljava/lang/Double;", "width", "getWidth", "()D", "height", "getHeight", "component1", "component2", "component3", "copy", "(Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$DoublePoint;Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$DoublePoint;Ljava/lang/Double;)Lorg/rust/ide/highlight/multispot/lifetime/RsMultispotConnectionRenderer$StripeInfo;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class StripeInfo {
        @NotNull
        private final DoublePoint topLeft;
        @NotNull
        private final DoublePoint bottomRight;
        @Nullable
        private final Double arch;

        public StripeInfo(@NotNull DoublePoint topLeft, @NotNull DoublePoint bottomRight, @Nullable Double arch) {
            Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
            Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
            this.arch = arch;
        }

        @NotNull
        public final DoublePoint getTopLeft() {
            return this.topLeft;
        }

        @NotNull
        public final DoublePoint getBottomRight() {
            return this.bottomRight;
        }

        @Nullable
        public final Double getArch() {
            return this.arch;
        }

        public final double getWidth() {
            return this.bottomRight.getX() - this.topLeft.getX();
        }

        public final double getHeight() {
            return this.bottomRight.getY() - this.topLeft.getY();
        }

        @NotNull
        public final DoublePoint component1() {
            return this.topLeft;
        }

        @NotNull
        public final DoublePoint component2() {
            return this.bottomRight;
        }

        @Nullable
        public final Double component3() {
            return this.arch;
        }

        @NotNull
        public final StripeInfo copy(@NotNull DoublePoint topLeft, @NotNull DoublePoint bottomRight, @Nullable Double arch) {
            Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
            Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
            return new StripeInfo(topLeft, bottomRight, arch);
        }

        public static /* synthetic */ StripeInfo copy$default(StripeInfo stripeInfo, DoublePoint doublePoint, DoublePoint doublePoint2, Double d, int n, Object object) {
            if ((n & 1) != 0) {
                doublePoint = stripeInfo.topLeft;
            }
            if ((n & 2) != 0) {
                doublePoint2 = stripeInfo.bottomRight;
            }
            if ((n & 4) != 0) {
                d = stripeInfo.arch;
            }
            return stripeInfo.copy(doublePoint, doublePoint2, d);
        }

        @NotNull
        public String toString() {
            return "StripeInfo(topLeft=" + this.topLeft + ", bottomRight=" + this.bottomRight + ", arch=" + this.arch + ")";
        }

        public int hashCode() {
            int result2 = this.topLeft.hashCode();
            result2 = result2 * 31 + this.bottomRight.hashCode();
            result2 = result2 * 31 + (this.arch == null ? 0 : ((Object)this.arch).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StripeInfo)) {
                return false;
            }
            StripeInfo stripeInfo = (StripeInfo)other;
            if (!Intrinsics.areEqual((Object)this.topLeft, (Object)stripeInfo.topLeft)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bottomRight, (Object)stripeInfo.bottomRight)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.arch, (Object)stripeInfo.arch);
        }
    }
}

