/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.highlight.multispot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.highlight.multispot.lifetime.RsMultispotHighlightingConnectionTooltipService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/rust/ide/highlight/multispot/RsMultispotEditorMouseMotionListener;", "Ljava/awt/event/MouseMotionListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "register", "", "mouseDragged", "e", "Ljava/awt/event/MouseEvent;", "mouseMoved", "intellij.rustrover.core"})
public final class RsMultispotEditorMouseMotionListener
implements MouseMotionListener {
    @NotNull
    private final Editor editor;

    public RsMultispotEditorMouseMotionListener(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }

    public final void register() {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        EditorUtil.disposeWithEditor((Editor)this.editor, (Disposable)disposable2);
        this.editor.getContentComponent().addMouseMotionListener(this);
        Disposer.register((Disposable)disposable2, () -> RsMultispotEditorMouseMotionListener.register$lambda$0(this));
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = this.editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        RsMultispotHighlightingConnectionTooltipService.Companion.getInstance(project2).fireMouseMoved(this.editor, e);
    }

    private static final void register$lambda$0(RsMultispotEditorMouseMotionListener this$0) {
        this$0.editor.getContentComponent().removeMouseMotionListener(this$0);
    }
}

