/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.formatter.settings;

import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"sample", "", "code", "INDENT_SAMPLE", "SPACING_SAMPLE", "WRAPPING_AND_BRACES_SAMPLE", "BLANK_LINES_SAMPLE", "intellij.rustrover.core"})
public final class RsLanguageCodeStyleSettingsProviderKt {
    @NotNull
    private static final String INDENT_SAMPLE = RsLanguageCodeStyleSettingsProviderKt.sample("\nstruct Vector {\n    x: f64,\n    y: f64,\n    z: f64\n}\n\nimpl Vector {\n    fn add(&self, other: &Vector) -> Vector {\n        Vector {\n            x: self.x + other.x,\n            y: self.y + other.y,\n            z: self.z + other.z,\n        }\n    }\n}\n");
    @NotNull
    private static final String SPACING_SAMPLE = RsLanguageCodeStyleSettingsProviderKt.sample("\ntrait Trait0<A, B, T: Trait1<A>> {\n    type Output;\n}\n\ntrait Trait1<T> {}\n\nfn method<A, B, T, C>(value: T) where T: Trait0<A, B, T, Output=C> {}\n");
    @NotNull
    private static final String WRAPPING_AND_BRACES_SAMPLE = RsLanguageCodeStyleSettingsProviderKt.sample("\nfn concat<X, Y, I>(xs: X,\n                   ys: Y)\n                   -> Box<Iterator<Item=I>>\n    where X: Iterator<Item=I>,\n          Y: Iterator<Item=I>\n{\n    unimplemented!()\n}\n\n\nstruct Point {\n    x: i32, // first coordinate\n    y: i32, // second coordinate\n}\n\n\nfn main() {\n    let xs = vec![1, 2, 3].into_iter()\n        .map(|x| x * 2)\n        .filter(|x| x > 2);\n\n    let ys = vec![1,\n                  2,\n                  3].into_iter();\n\n    let zs = concat(xs,\n                    ys);\n\n    let is_even = match zs.next { Some(x) => x % 2 == 0, None => false, };\n\n    match is_even {\n        true => {\n            // comment\n        },\n        _ => println(\"false\"),\n    }\n    return\n}\n");
    @NotNull
    private static final String BLANK_LINES_SAMPLE = RsLanguageCodeStyleSettingsProviderKt.sample("\n#![allow(dead_code)]\n\n\n\nuse std::cmp::{max, min};\n\n\n\nstruct Rectangle {\n    p1: (i32, i32),\n\n\n\n    p2: (i32, i32),\n}\n\n\n\nimpl Rectangle {\n    fn dimensions(&self) -> (i32, i32) {\n        let Rectangle {\n            p1,\n\n\n            p2,\n        } = self;\n\n\n\n        let (x1, y1) = p1;\n        let (x2, y2) = p2;\n\n\n\n        ((x1 - x2).abs(), (y1 - y2).abs())\n    }\n\n\n\n    fn area(&self) -> i32 {\n        let (a, b) = self.dimensions();\n        a * b\n    }\n\n\n\n    fn do_four_intersect(\n        first_rectangle: &Rectangle,\n        second_rectangle: &Rectangle,\n\n\n        third_rectangle: &Rectangle,\n        fourth_rectangle: &Rectangle,\n    ) -> bool {\n        todo!()\n    }\n}\n");

    private static final String sample(@Language(value="Rust") String code) {
        return ((Object)StringsKt.trim((CharSequence)code)).toString();
    }

    public static final /* synthetic */ String access$getINDENT_SAMPLE$p() {
        return INDENT_SAMPLE;
    }

    public static final /* synthetic */ String access$getSPACING_SAMPLE$p() {
        return SPACING_SAMPLE;
    }

    public static final /* synthetic */ String access$getWRAPPING_AND_BRACES_SAMPLE$p() {
        return WRAPPING_AND_BRACES_SAMPLE;
    }

    public static final /* synthetic */ String access$getBLANK_LINES_SAMPLE$p() {
        return BLANK_LINES_SAMPLE;
    }
}

