/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.formatter.settings;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.formatter.settings.RsCodeStyleMainPanel;
import org.rust.ide.formatter.settings.RsCodeStyleSettings;
import org.rust.ide.formatter.settings.RsLanguageCodeStyleSettingsProviderKt;
import org.rust.lang.RsLanguage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014\u00a8\u0006\u001e"}, d2={"Lorg/rust/ide/formatter/settings/RsLanguageCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "<init>", "()V", "getLanguage", "Lcom/intellij/lang/Language;", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "baseSettings", "modelSettings", "getConfigurableDisplayName", "", "getCodeSample", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "customizeSettings", "", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "getIndentOptionsEditor", "Lcom/intellij/application/options/IndentOptionsEditor;", "customizeDefaults", "commonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "indentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "intellij.rustrover.core"})
public final class RsLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        return RsLanguage.INSTANCE;
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new RsCodeStyleSettings(settings);
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        Intrinsics.checkNotNullParameter((Object)baseSettings, (String)"baseSettings");
        Intrinsics.checkNotNullParameter((Object)modelSettings, (String)"modelSettings");
        String string = this.getConfigurableDisplayName();
        return (CodeStyleConfigurable)new CodeStyleAbstractConfigurable(baseSettings, modelSettings, string){

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                CodeStyleSettings codeStyleSettings = this.getCurrentSettings();
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCurrentSettings(...)");
                return (CodeStyleAbstractPanel)new RsCodeStyleMainPanel(codeStyleSettings, settings);
            }
        };
    }

    @NotNull
    public String getConfigurableDisplayName() {
        return RsBundle.INSTANCE.message("settings.rust.code.style.name", new Object[0]);
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        return switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1 -> RsLanguageCodeStyleSettingsProviderKt.access$getINDENT_SAMPLE$p();
            case 2 -> RsLanguageCodeStyleSettingsProviderKt.access$getSPACING_SAMPLE$p();
            case 3 -> RsLanguageCodeStyleSettingsProviderKt.access$getWRAPPING_AND_BRACES_SAMPLE$p();
            case 4 -> RsLanguageCodeStyleSettingsProviderKt.access$getBLANK_LINES_SAMPLE$p();
            default -> "";
        };
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 4: {
                String[] stringArray = new String[]{"KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE"};
                consumer.showStandardOptions(stringArray);
                consumer.showCustomOption(RsCodeStyleSettings.class, "MIN_NUMBER_OF_BLANKS_BETWEEN_ITEMS", RsBundle.INSTANCE.message("settings.rust.code.style.between.declarations", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "MAX_NUMBER_OF_BLANKS_BETWEEN_VALUE_PARAMETERS", RsBundle.INSTANCE.message("settings.rust.code.style.between.value.parameters", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "MAX_NUMBER_OF_BLANKS_BETWEEN_FIELD_PATTERNS", RsBundle.INSTANCE.message("settings.rust.code.style.between.field.patterns", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP, new Object[0]);
                break;
            }
            case 2: {
                consumer.showCustomOption(RsCodeStyleSettings.class, "SPACE_AROUND_ASSOC_TYPE_BINDING", RsBundle.INSTANCE.message("settings.rust.code.style.around.associated.type.bindings", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_IN_TYPE_PARAMETERS, new Object[0]);
                break;
            }
            case 3: {
                String[] stringArray = new String[]{"KEEP_LINE_BREAKS", "RIGHT_MARGIN", "ALIGN_MULTILINE_CHAINED_METHODS", "ALIGN_MULTILINE_PARAMETERS", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "KEEP_FIRST_COLUMN_COMMENT"};
                consumer.showStandardOptions(stringArray);
                consumer.showCustomOption(RsCodeStyleSettings.class, "ALLOW_ONE_LINE_MATCH", RsBundle.INSTANCE.message("settings.rust.code.style.match.expressions.in.one.line", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_KEEP, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "PRESERVE_PUNCTUATION", RsBundle.INSTANCE.message("settings.rust.code.style.punctuation", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_KEEP, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "ALIGN_RET_TYPE", RsBundle.INSTANCE.message("settings.rust.code.style.align.return.type", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_METHOD_PARAMETERS, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "ALIGN_WHERE_CLAUSE", RsBundle.INSTANCE.message("settings.rust.code.style.align.where.clause", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_METHOD_PARAMETERS, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "ALIGN_TYPE_PARAMS", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_IN_TYPE_PARAMETERS, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "INDENT_WHERE_CLAUSE", RsBundle.INSTANCE.message("settings.rust.code.style.indent.where.clause", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_IN_TYPE_PARAMETERS, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "ALIGN_WHERE_BOUNDS", RsBundle.INSTANCE.message("settings.rust.code.style.align.where.clause.bounds", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_IN_TYPE_PARAMETERS, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "PRESERVE_END_OF_LINE_COMMENTS_ON_THE_SAME_LINE", RsBundle.INSTANCE.message("settings.rust.code.style.end.of.line.comments.on.the.same.line", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_COMMENTS, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "WHERE_ON_NEW_LINE", RsBundle.INSTANCE.message("settings.rust.code.style.put.where.on.new.line", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_IN_TYPE_PARAMETERS, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "NEW_LINE_AFTER_WHERE", RsBundle.INSTANCE.message("settings.rust.code.style.new.line.after.where", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_IN_TYPE_PARAMETERS, new Object[0]);
                consumer.showCustomOption(RsCodeStyleSettings.class, "DO_NOT_FORMAT_RUSTFMT_SKIP", RsBundle.INSTANCE.message("settings.rust.code.style.elements.with.rustfmt.skip", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_KEEP, new Object[0]);
                break;
            }
            case 5: {
                String[] stringArray = new String[]{"LINE_COMMENT_AT_FIRST_COLUMN", "LINE_COMMENT_ADD_SPACE", "BLOCK_COMMENT_AT_FIRST_COLUMN"};
                consumer.showStandardOptions(stringArray);
                break;
            }
        }
    }

    @NotNull
    public IndentOptionsEditor getIndentOptionsEditor() {
        return (IndentOptionsEditor)new SmartIndentOptionsEditor();
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)commonSettings, (String)"commonSettings");
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        commonSettings.RIGHT_MARGIN = 100;
        commonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = true;
        commonSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        commonSettings.LINE_COMMENT_ADD_SPACE = true;
        commonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = false;
        commonSettings.KEEP_FIRST_COLUMN_COMMENT = false;
        indentOptions.CONTINUATION_INDENT_SIZE = indentOptions.INDENT_SIZE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageCodeStyleSettingsProvider.SettingsType.values().length];
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

