/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.formatter.processors;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.formatter.settings.RsCodeStyleSettings;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"shouldRunPunctuationProcessor", "", "element", "Lcom/intellij/lang/ASTNode;", "containsLineBreakBetween", "left", "Lcom/intellij/psi/PsiElement;", "right", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)Ljava/lang/Boolean;", "intellij.rustrover.core"})
public final class UtilKt {
    public static final boolean shouldRunPunctuationProcessor(@NotNull ASTNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psi = element.getPsi();
        if (!psi.isValid()) {
            return false;
        }
        return !((RsCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)psi.getContainingFile(), RsCodeStyleSettings.class)).PRESERVE_PUNCTUATION;
    }

    @Nullable
    public static final Boolean containsLineBreakBetween(@NotNull PsiElement left, @NotNull PsiElement right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        PsiFile psiFile = left.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Document document = UtilsKt.getDocument(psiFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return document2.getLineNumber(PsiElementKt.getEndOffset(left)) != document2.getLineNumber(PsiElementKt.getStartOffset(right));
    }
}

