/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.formatter.processors;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.formatter.impl.CommaList;
import org.rust.lang.core.psi.RsBlockFields;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsWhereClause;
import org.rust.lang.core.psi.RsWherePred;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"removeTrailingComma", "", "Lorg/rust/ide/formatter/impl/CommaList;", "list", "Lcom/intellij/psi/PsiElement;", "addTrailingCommaInWhereClause", "clause", "Lorg/rust/lang/core/psi/RsWhereClause;", "addTrailingCommaForElement", "isOnSameLineAsLastElement", "element", "intellij.rustrover.core"})
public final class RsTrailingCommaFormatProcessorKt {
    public static final boolean removeTrailingComma(@NotNull CommaList $this$removeTrailingComma, @NotNull PsiElement list) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$removeTrailingComma, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        if (!Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(list), (Object)$this$removeTrailingComma.getList())) {
            throw new IllegalStateException("Check failed.");
        }
        if (PostFormatProcessorHelper.isMultiline((PsiElement)list)) {
            return false;
        }
        PsiElement rbrace = list.getLastChild();
        Intrinsics.checkNotNull((Object)rbrace);
        if (!Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(rbrace), (Object)$this$removeTrailingComma.getClosingBrace())) {
            return false;
        }
        PsiElement psiElement2 = PsiElementExtensionsKt.getPrevNonCommentSibling(rbrace);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement comma = psiElement2;
        if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(comma), (Object)RsElementTypes.COMMA)) {
            comma.delete();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean addTrailingCommaInWhereClause(RsWhereClause clause) {
        if (!PostFormatProcessorHelper.isMultiline((PsiElement)clause)) {
            return false;
        }
        PsiElement psiElement2 = PsiElementExtensionsKt.getNextNonCommentSibling(clause);
        if (Intrinsics.areEqual((Object)(psiElement2 != null ? PsiElementExtensionsKt.getElementType(psiElement2) : null), (Object)RsElementTypes.SEMICOLON)) {
            return false;
        }
        PsiElement psiElement3 = clause.getLastChild();
        RsWherePred rsWherePred = psiElement3 instanceof RsWherePred ? (RsWherePred)psiElement3 : null;
        if (rsWherePred == null) {
            return false;
        }
        RsWherePred pred = rsWherePred;
        Project project = clause.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement comma = new RsPsiFactory(project, false, false, 6, null).createComma();
        clause.addAfter(comma, pred);
        return true;
    }

    public static final boolean addTrailingCommaForElement(@NotNull CommaList $this$addTrailingCommaForElement, @NotNull PsiElement list) {
        Intrinsics.checkNotNullParameter((Object)$this$addTrailingCommaForElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        if (!Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(list), (Object)$this$addTrailingCommaForElement.getList())) {
            throw new IllegalStateException("Check failed.");
        }
        if (!PostFormatProcessorHelper.isMultiline((PsiElement)list)) {
            return false;
        }
        PsiElement rbrace = list.getLastChild();
        Intrinsics.checkNotNull((Object)rbrace);
        if (!Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(rbrace), (Object)$this$addTrailingCommaForElement.getClosingBrace())) {
            return false;
        }
        PsiElement psiElement2 = PsiElementExtensionsKt.getPrevNonCommentSibling(rbrace);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement lastElement = psiElement2;
        if (!((Boolean)$this$addTrailingCommaForElement.isElement().invoke((Object)lastElement)).booleanValue()) {
            return false;
        }
        CharSequence trailingSpace = list.getNode().getChars().subSequence(lastElement.getStartOffsetInParent() + lastElement.getTextLength(), rbrace.getStartOffsetInParent());
        if (!StringsKt.contains$default((CharSequence)trailingSpace, (char)'\n', (boolean)false, (int)2, null)) {
            return false;
        }
        if (!(!Intrinsics.areEqual((Object)PsiElementExtensionsKt.getNextNonCommentSibling(list.getFirstChild()), (Object)lastElement) || list instanceof RsBlockFields && ((RsBlockFields)list).getParent() instanceof RsStructItem)) {
            return false;
        }
        Project project = list.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement comma = new RsPsiFactory(project, false, false, 6, null).createComma();
        list.addAfter(comma, lastElement);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOnSameLineAsLastElement(@NotNull CommaList $this$isOnSameLineAsLastElement, @NotNull PsiElement list, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnSameLineAsLastElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(list), (Object)$this$isOnSameLineAsLastElement.getList()) && (Boolean)$this$isOnSameLineAsLastElement.isElement().invoke((Object)element) != false)) {
            throw new IllegalStateException("Check failed.");
        }
        PsiElement rbrace = list.getLastChild();
        Intrinsics.checkNotNull((Object)rbrace);
        if (!Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(rbrace), (Object)$this$isOnSameLineAsLastElement.getClosingBrace())) {
            return false;
        }
        PsiElement psiElement3 = PsiElementExtensionsKt.getPrevNonCommentSibling(rbrace);
        psiElement3 = psiElement3;
        if (psiElement2 == null) return false;
        PsiElement psiElement4 = psiElement3;
        if ((Boolean)$this$isOnSameLineAsLastElement.isElement().invoke((Object)psiElement4) == false) return false;
        PsiElement psiElement3 = psiElement4;
        psiElement3 = psiElement3;
        if (psiElement5 == null) {
            return false;
        }
        PsiElement lastElement = psiElement3;
        if (Intrinsics.areEqual((Object)element, (Object)lastElement)) return true;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Document document = UtilsKt.getDocument(psiFile);
        if (document == null) return false;
        Document it2 = document;
        boolean bl = false;
        if (it2.getLineNumber(PsiElementKt.getEndOffset(element)) != it2.getLineNumber(PsiElementKt.getEndOffset(lastElement))) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$addTrailingCommaInWhereClause(RsWhereClause clause) {
        return RsTrailingCommaFormatProcessorKt.addTrailingCommaInWhereClause(clause);
    }
}

