/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.formatter.processors;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.formatter.UtilKt;
import org.rust.ide.formatter.impl.CommaList;
import org.rust.ide.formatter.processors.RsFormatterRecursiveElementVisitor;
import org.rust.ide.formatter.processors.RsTrailingCommaFormatProcessorKt;
import org.rust.ide.formatter.settings.RsCodeStyleSettings;
import org.rust.lang.core.psi.RsWhereClause;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/formatter/processors/RsTrailingCommaFormatProcessor;", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessor;", "<init>", "()V", "processElement", "Lcom/intellij/psi/PsiElement;", "source", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "processText", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "doProcess", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessorHelper;", "range", "intellij.rustrover.core"})
public final class RsTrailingCommaFormatProcessor
implements PostFormatProcessor {
    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.doProcess(source, settings, null);
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        TextRange textRange = this.doProcess((PsiElement)source, settings, rangeToReformat).getResultTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getResultTextRange(...)");
        return textRange;
    }

    private final PostFormatProcessorHelper doProcess(PsiElement source, CodeStyleSettings settings, TextRange range) {
        PostFormatProcessorHelper helper = new PostFormatProcessorHelper(UtilKt.getRustCommonSettings(settings));
        helper.setResultTextRange(range);
        if (UtilKt.getRustCustomSettings((CodeStyleSettings)settings).PRESERVE_PUNCTUATION) {
            return helper;
        }
        RsCodeStyleSettings rsCodeStyleSettings = UtilKt.getRustCustomSettings(settings);
        source.accept((PsiElementVisitor)new RsFormatterRecursiveElementVisitor(helper, rsCodeStyleSettings){
            final /* synthetic */ PostFormatProcessorHelper $helper;
            {
                this.$helper = $helper;
                super($super_call_param$1);
            }

            public void doVisitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.doVisitElement(element);
                if (!this.$helper.isElementFullyInRange(element)) {
                    return;
                }
                if (element instanceof RsWhereClause) {
                    if (RsTrailingCommaFormatProcessorKt.access$addTrailingCommaInWhereClause((RsWhereClause)element)) {
                        this.$helper.updateResultRange(0, 1);
                    }
                    return;
                }
                CommaList commaList = CommaList.Companion.forElement(element);
                if (commaList == null) {
                    return;
                }
                CommaList commaList2 = commaList;
                if (RsTrailingCommaFormatProcessorKt.removeTrailingComma(commaList2, element)) {
                    this.$helper.updateResultRange(1, 0);
                } else if (RsTrailingCommaFormatProcessorKt.addTrailingCommaForElement(commaList2, element)) {
                    this.$helper.updateResultRange(0, 1);
                }
            }
        });
        return helper;
    }

    static /* synthetic */ PostFormatProcessorHelper doProcess$default(RsTrailingCommaFormatProcessor rsTrailingCommaFormatProcessor, PsiElement psiElement2, CodeStyleSettings codeStyleSettings, TextRange textRange, int n, Object object) {
        if ((n & 4) != 0) {
            textRange = null;
        }
        return rsTrailingCommaFormatProcessor.doProcess(psiElement2, codeStyleSettings, textRange);
    }
}

