/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.formatter.processors;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.formatter.processors.RsFormatterRecursiveElementVisitor;
import org.rust.ide.formatter.processors.UtilKt;
import org.rust.ide.formatter.settings.RsCodeStyleSettings;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/rust/ide/formatter/processors/RsMatchArmCommaFormatProcessor;", "Lcom/intellij/psi/impl/source/codeStyle/PreFormatProcessor;", "<init>", "()V", "process", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/lang/ASTNode;", "range", "removeCommaAfterBlock", "", "Lorg/rust/lang/core/psi/RsMatchArm;", "intellij.rustrover.core"})
public final class RsMatchArmCommaFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (!UtilKt.shouldRunPunctuationProcessor(element)) {
            return range;
        }
        Ref.IntRef nRemovedCommas = new Ref.IntRef();
        PsiElement psi = element.getPsi();
        CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getCustomSettings((PsiFile)psi.getContainingFile(), RsCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        RsCodeStyleSettings customSettings = (RsCodeStyleSettings)customCodeStyleSettings;
        psi.accept((PsiElementVisitor)new RsFormatterRecursiveElementVisitor(customSettings, range, this, nRemovedCommas){
            final /* synthetic */ TextRange $range;
            final /* synthetic */ RsMatchArmCommaFormatProcessor this$0;
            final /* synthetic */ Ref.IntRef $nRemovedCommas;
            {
                this.$range = $range;
                this.this$0 = $receiver;
                this.$nRemovedCommas = $nRemovedCommas;
                super($customSettings);
            }

            public void doVisitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (this.$range.contains(element.getTextRange())) {
                    super.doVisitElement(element);
                }
                if (element instanceof RsMatchArm && RsMatchArmCommaFormatProcessor.access$removeCommaAfterBlock(this.this$0, (RsMatchArm)element)) {
                    ++this.$nRemovedCommas.element;
                }
            }
        });
        TextRange textRange = range.grown(-nRemovedCommas.element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"grown(...)");
        return textRange;
    }

    private final boolean removeCommaAfterBlock(RsMatchArm element) {
        RsExpr rsExpr = element.getExpr();
        if (rsExpr == null) {
            return false;
        }
        RsExpr expr = rsExpr;
        if (!(expr instanceof RsBlockExpr) || ((RsBlockExpr)expr).getUnsafe() != null) {
            return false;
        }
        PsiElement psiElement2 = PsiElementExtensionsKt.getNextNonCommentSibling(expr);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement comma = psiElement2;
        if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(comma), (Object)RsElementTypes.COMMA)) {
            comma.delete();
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean access$removeCommaAfterBlock(RsMatchArmCommaFormatProcessor $this, RsMatchArm element) {
        return $this.removeCommaAfterBlock(element);
    }
}

