/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.formatter.impl;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.formatter.RsFmtContext;
import org.rust.ide.formatter.RsFormattingUtils;
import org.rust.ide.formatter.blocks.RsASTBlock;
import org.rust.ide.formatter.impl.UtilsKt;
import org.rust.ide.formatter.settings.RsCodeStyleSettings;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsForExpr;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsLetDecl;
import org.rust.lang.core.psi.RsMatchExpr;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsStructLiteral;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsLooplikeExpr;
import org.rust.lang.core.psi.ext.RsOuterAttributeOwner;
import org.rust.lang.doc.psi.RsDocElementTypes;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\bH\u0002\u001a\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\bH\u0002\u001a\u0014\u0010\r\u001a\u00020\n*\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0002\u001a\u001a\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"computeIndent", "Lcom/intellij/formatting/Indent;", "Lorg/rust/ide/formatter/blocks/RsASTBlock;", "child", "Lcom/intellij/lang/ASTNode;", "childCtx", "Lorg/rust/ide/formatter/RsFmtContext;", "getIndentForStarDocGap", "Lcom/intellij/psi/PsiElement;", "shouldIndentLetDeclarationChild", "", "parent", "shouldIndentExprContinuation", "isBefore", "that", "getIndentForWherePred", "getIndentIfNotDelim", "customSpacingForCommentBeforeElseBlock", "block", "comment", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nindent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 indent.kt\norg/rust/ide/formatter/impl/IndentKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n66#2,2:169\n1#3:171\n*S KotlinDebug\n*F\n+ 1 indent.kt\norg/rust/ide/formatter/impl/IndentKt\n*L\n96#1:169,2\n*E\n"})
public final class IndentKt {
    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final Indent computeIndent(@NotNull RsASTBlock $this$computeIndent, @NotNull ASTNode child, @NotNull RsFmtContext childCtx) {
        Indent indent;
        PsiElement childPsi;
        IElementType childType;
        PsiElement parentPsi;
        IElementType parentType;
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter((Object)$this$computeIndent, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                Intrinsics.checkNotNullParameter((Object)childCtx, (String)"childCtx");
                IElementType iElementType = $this$computeIndent.getNode().getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                parentType = iElementType;
                parentPsi = $this$computeIndent.getNode().getPsi();
                IElementType iElementType2 = child.getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
                childType = iElementType2;
                childPsi = child.getPsi();
                if (Intrinsics.areEqual((Object)childType, (Object)RsElementTypes.RET_TYPE)) break block19;
                if (!Intrinsics.areEqual((Object)childType, (Object)RsElementTypes.WHERE_CLAUSE)) break block20;
                Object object = $this$computeIndent.getCtx();
                boolean bl = object != null && (object = object.getRustSettings()) != null ? ((RsCodeStyleSettings)((Object)object)).INDENT_WHERE_CLAUSE : false;
                if (!bl) break block20;
            }
            indent = Indent.getNormalIndent();
            return indent;
        }
        if (UtilsKt.isDelimitedBlock($this$computeIndent.getNode())) {
            Intrinsics.checkNotNull((Object)parentPsi);
            Intrinsics.checkNotNull((Object)childPsi);
            Indent indent = IndentKt.customSpacingForCommentBeforeElseBlock(parentPsi, childPsi);
            indent = indent;
            if (indent2 != null) return indent;
            indent = IndentKt.getIndentIfNotDelim($this$computeIndent, child, $this$computeIndent.getNode());
            return indent;
        }
        if (UtilsKt.isFlatBlock($this$computeIndent.getNode())) {
            if (childCtx.getMetLBrace()) {
                indent = IndentKt.getIndentIfNotDelim($this$computeIndent, child, $this$computeIndent.getNode());
                return indent;
            }
            indent = Indent.getNoneIndent();
            return indent;
        }
        Intrinsics.checkNotNull((Object)parentPsi);
        Intrinsics.checkNotNull((Object)childPsi);
        if (IndentKt.shouldIndentLetDeclarationChild(parentPsi, childPsi)) {
            indent = Indent.getContinuationWithoutFirstIndent();
            return indent;
        }
        if (childPsi instanceof RsExpr && (Intrinsics.areEqual((Object)parentType, (Object)RsElementTypes.MATCH_ARM) || Intrinsics.areEqual((Object)parentType, (Object)RsElementTypes.CONSTANT))) {
            indent = Indent.getNormalIndent();
            return indent;
        }
        if (parentPsi instanceof RsIfExpr) {
            indent = Indent.getNoneIndent();
            return indent;
        }
        if (parentPsi instanceof RsForExpr && Intrinsics.areEqual((Object)((RsForExpr)parentPsi).getExpr(), (Object)childPsi)) {
            indent = Indent.getNormalIndent();
            return indent;
        }
        if (parentPsi instanceof RsLooplikeExpr) {
            indent = Indent.getNoneIndent();
            return indent;
        }
        if (parentPsi instanceof RsMatchExpr) {
            indent = Indent.getNoneIndent();
            return indent;
        }
        if (parentPsi instanceof RsStructLiteral) {
            indent = Indent.getNoneIndent();
            return indent;
        }
        if (IndentKt.shouldIndentExprContinuation(parentPsi, childPsi)) {
            indent = Indent.getContinuationWithoutFirstIndent();
            return indent;
        }
        if (Intrinsics.areEqual((Object)childType, (Object)RsElementTypes.WHERE_PRED)) {
            indent = IndentKt.getIndentForWherePred($this$computeIndent);
            return indent;
        }
        if (Intrinsics.areEqual((Object)childType, (Object)((Object)RsDocElementTypes.INSTANCE.getDOC_GAP()))) {
            CharSequence charSequence = child.getChars();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
            if (StringsKt.startsWith$default((CharSequence)charSequence, (char)'*', (boolean)false, (int)2, null)) {
                Indent indent = IndentKt.getIndentForStarDocGap(childPsi);
                indent = indent;
                if (indent3 != null) return indent;
                indent = Indent.getNoneIndent();
                return indent;
            }
        }
        if (Intrinsics.areEqual((Object)parentType, (Object)RsElementTypes.META_ITEM_ARGS) && !Intrinsics.areEqual((Object)childType, (Object)RsElementTypes.LPAREN) && !Intrinsics.areEqual((Object)childType, (Object)RsElementTypes.RPAREN)) {
            indent = Indent.getNormalIndent();
            return indent;
        }
        if (Intrinsics.areEqual((Object)parentType, (Object)RsElementTypes.NAMED_FIELD_DECL) && childPsi instanceof RsTypeReference) {
            indent = Indent.getNormalIndent();
            return indent;
        }
        indent = Indent.getNoneIndent();
        return indent;
    }

    private static final Indent getIndentForStarDocGap(PsiElement child) {
        PsiElement $this$parentOfType_u24default$iv = child;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiComment psiComment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiComment.class, (boolean)true);
        if (psiComment == null) {
            return null;
        }
        PsiComment parent2 = psiComment;
        PsiFile file = child.getContainingFile();
        Intrinsics.checkNotNull((Object)file);
        ASTNode aSTNode = parent2.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        int parentIndent = RsFormattingUtils.INSTANCE.getSpaceIndent(file, aSTNode);
        ASTNode aSTNode2 = child.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"getNode(...)");
        int childIndent = RsFormattingUtils.INSTANCE.getSpaceIndent(file, aSTNode2);
        return childIndent <= parentIndent ? Indent.getNoneIndent() : Indent.getSpaceIndent((int)1);
    }

    private static final boolean shouldIndentLetDeclarationChild(PsiElement parent2, PsiElement child) {
        RsLetDecl rsLetDecl = parent2 instanceof RsLetDecl ? (RsLetDecl)parent2 : null;
        if (rsLetDecl == null) {
            return false;
        }
        RsLetDecl letDecl = rsLetDecl;
        if (Intrinsics.areEqual((Object)((RsLetDecl)parent2).getLetElseBranch(), (Object)child)) {
            return false;
        }
        PsiElement psiElement2 = letDecl.getLet();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getLet(...)");
        return !IndentKt.isBefore(child, psiElement2);
    }

    private static final boolean shouldIndentExprContinuation(PsiElement parent2, PsiElement child) {
        if (!(parent2 instanceof RsExpr)) {
            return false;
        }
        if (!(parent2 instanceof RsOuterAttributeOwner)) {
            return true;
        }
        RsOuterAttr rsOuterAttr = (RsOuterAttr)CollectionsKt.lastOrNull((List)((RsExpr)parent2).getOuterAttrList());
        if (rsOuterAttr == null || (rsOuterAttr = PsiElementExtensionsKt.getNextNonCommentSibling(rsOuterAttr)) == null) {
            rsOuterAttr = parent2.getFirstChild();
        }
        RsOuterAttr firstNonAttributeElement = rsOuterAttr;
        Intrinsics.checkNotNull((Object)firstNonAttributeElement);
        return !IndentKt.isBefore(child, firstNonAttributeElement);
    }

    private static final boolean isBefore(PsiElement $this$isBefore, PsiElement that) {
        Sequence before = SequencesKt.generateSequence((Object)that, IndentKt::isBefore$lambda$0);
        return SequencesKt.contains((Sequence)before, (Object)$this$isBefore);
    }

    @NotNull
    public static final Indent getIndentForWherePred(@NotNull RsASTBlock $this$getIndentForWherePred) {
        Intrinsics.checkNotNullParameter((Object)$this$getIndentForWherePred, (String)"<this>");
        Indent indent = Indent.getContinuationWithoutFirstIndent();
        Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"getContinuationWithoutFirstIndent(...)");
        return indent;
    }

    @NotNull
    public static final Indent getIndentIfNotDelim(@NotNull RsASTBlock $this$getIndentIfNotDelim, @NotNull ASTNode child, @NotNull ASTNode parent2) {
        Indent indent;
        Intrinsics.checkNotNullParameter((Object)$this$getIndentIfNotDelim, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        if (UtilsKt.isBlockDelim(child, parent2)) {
            Indent indent2 = Indent.getNoneIndent();
            Intrinsics.checkNotNull((Object)indent2);
            indent = indent2;
        } else {
            Indent indent3 = Indent.getNormalIndent();
            Intrinsics.checkNotNull((Object)indent3);
            indent = indent3;
        }
        return indent;
    }

    private static final Indent customSpacingForCommentBeforeElseBlock(PsiElement block, PsiElement comment) {
        if (!(comment instanceof PsiComment) || !(block instanceof RsBlock)) {
            return null;
        }
        PsiElement psiElement2 = ((RsBlock)block).getRbrace();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement rbrace = psiElement2;
        PsiElement it2 = (PsiElement)SequencesKt.singleOrNull((Sequence)SequencesKt.filterNot((Sequence)PsiTreeUtilKt.siblings((PsiElement)comment, (boolean)true, (boolean)true), IndentKt::customSpacingForCommentBeforeElseBlock$lambda$0));
        boolean $i$a$-let-IndentKt$customSpacingForCommentBeforeElseBlock$allCommentsAfter$32 = false;
        boolean allCommentsAfter = Intrinsics.areEqual((Object)it2, (Object)((RsBlock)block).getRbrace());
        if (!allCommentsAfter) {
            return null;
        }
        PsiElement $i$a$-let-IndentKt$customSpacingForCommentBeforeElseBlock$allCommentsAfter$32 = ((RsBlock)block).getParent().getParent();
        RsIfExpr rsIfExpr = $i$a$-let-IndentKt$customSpacingForCommentBeforeElseBlock$allCommentsAfter$32 instanceof RsIfExpr ? (RsIfExpr)$i$a$-let-IndentKt$customSpacingForCommentBeforeElseBlock$allCommentsAfter$32 : null;
        if (rsIfExpr == null) {
            return null;
        }
        RsIfExpr ifExpr = rsIfExpr;
        RsBlockExpr rsBlockExpr = ifExpr.getBlockExpr();
        if (!Intrinsics.areEqual((Object)(rsBlockExpr != null ? rsBlockExpr.getBlock() : null), (Object)block)) {
            return null;
        }
        if (ifExpr.getElseBranch() == null) {
            return null;
        }
        PsiElement psiElement3 = (PsiElement)SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.filterNot((Sequence)PsiTreeUtilKt.siblings((PsiElement)comment, (boolean)false, (boolean)true), IndentKt::customSpacingForCommentBeforeElseBlock$lambda$2), IndentKt::customSpacingForCommentBeforeElseBlock$lambda$3));
        if (psiElement3 == null) {
            return null;
        }
        PsiElement firstComment = psiElement3;
        if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getPrevNonWhitespaceSibling(firstComment), (Object)((RsBlock)block).getLbrace())) {
            return null;
        }
        PsiFile psiFile = ((RsBlock)block).getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        ASTNode aSTNode = firstComment.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        int firstCommentIndent = RsFormattingUtils.INSTANCE.getSpaceIndent(psiFile, aSTNode);
        PsiFile psiFile2 = ((RsBlock)block).getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        ASTNode aSTNode2 = rbrace.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"getNode(...)");
        int rbraceIndent = RsFormattingUtils.INSTANCE.getSpaceIndent(psiFile2, aSTNode2);
        return firstCommentIndent <= rbraceIndent ? Indent.getNoneIndent() : null;
    }

    private static final PsiElement isBefore$lambda$0(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getPrevSibling();
    }

    private static final boolean customSpacingForCommentBeforeElseBlock$lambda$0(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2 instanceof PsiComment || it2 instanceof PsiWhiteSpace;
    }

    private static final boolean customSpacingForCommentBeforeElseBlock$lambda$2(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2 instanceof PsiWhiteSpace;
    }

    private static final boolean customSpacingForCommentBeforeElseBlock$lambda$3(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2 instanceof PsiComment;
    }
}

