/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.formatter.RsFmtContext;
import org.rust.ide.formatter.blocks.RsASTBlock;
import org.rust.ide.formatter.blocks.RsLineBlock;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lorg/rust/ide/formatter/blocks/RsMultilineStringLiteralBlock;", "Lorg/rust/ide/formatter/blocks/RsASTBlock;", "node", "Lcom/intellij/lang/ASTNode;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "wrap", "Lcom/intellij/formatting/Wrap;", "ctx", "Lorg/rust/ide/formatter/RsFmtContext;", "<init>", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;Lcom/intellij/formatting/Wrap;Lorg/rust/ide/formatter/RsFmtContext;)V", "getCtx", "()Lorg/rust/ide/formatter/RsFmtContext;", "getNode", "getAlignment", "getIndent", "getWrap", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "isIncomplete", "", "isLeaf", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getSubBlocks", "", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "Lcom/intellij/formatting/Block;", "child2", "intellij.rustrover.core"})
public final class RsMultilineStringLiteralBlock
implements RsASTBlock {
    @NotNull
    private final ASTNode node;
    @Nullable
    private final Alignment alignment;
    @Nullable
    private final Indent indent;
    @Nullable
    private final Wrap wrap;
    @NotNull
    private final RsFmtContext ctx;

    public RsMultilineStringLiteralBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap2, @NotNull RsFmtContext ctx) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.node = node;
        this.alignment = alignment;
        this.indent = indent;
        this.wrap = wrap2;
        this.ctx = ctx;
    }

    @Override
    @NotNull
    public RsFmtContext getCtx() {
        return this.ctx;
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        return this.node;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.alignment;
    }

    @Nullable
    public Indent getIndent() {
        return this.indent;
    }

    @Nullable
    public Wrap getWrap() {
        return this.wrap;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.node.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return false;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(null, null);
    }

    @Override
    @NotNull
    public List<RsASTBlock> getSubBlocks() {
        ArrayList result2 = new ArrayList();
        int startOffset = 0;
        CharSequence charSequence = this.node.getChars();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
        CharSequence chars = charSequence;
        for (int j = 0; j < chars.length(); ++j) {
            int idx = j;
            char c = chars.charAt(j);
            if (c != '\n') continue;
            ((Collection)result2).add(new RsLineBlock(this.node, new TextRange(startOffset, idx), this.getCtx()));
            startOffset = idx;
        }
        if (startOffset < chars.length()) {
            ((Collection)result2).add(new RsLineBlock(this.node, new TextRange(startOffset, chars.length()), this.getCtx()));
        }
        return result2;
    }

    @NotNull
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        Spacing spacing = Spacing.getReadOnlySpacing();
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"getReadOnlySpacing(...)");
        return spacing;
    }
}

