/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.formatter;

import com.intellij.CodeStyleBundle;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.text.StringKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.settings.RustfmtProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.Rustfmt;
import org.rust.cargo.toolchain.tools.RustfmtKt;
import org.rust.cargo.toolchain.tools.Rustup;
import org.rust.ide.actions.InstallComponentAction;
import org.rust.ide.formatter.ActionHolder;
import org.rust.ide.formatter.ConfigureRustfmtAction;
import org.rust.ide.formatter.RustfmtFormattingService;
import org.rust.ide.formatter.RustfmtFormattingServiceKt;
import org.rust.ide.formatter.RustfmtTestmarks;
import org.rust.ide.notifications.RsNotifications;
import org.rust.ide.statistics.RustfmtUsagesCollector;
import org.rust.lang.core.psi.RsFile;
import org.rust.openapiext.CommandLineExtKt;
import org.rust.openapiext.RsProcessExecutionException;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\b\u0010\u0012\u001a\u00020\bH\u0014\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/formatter/RustfmtFormattingService;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService;", "<init>", "()V", "getFeatures", "", "Lcom/intellij/formatting/service/FormattingService$Feature;", "canFormat", "", "file", "Lcom/intellij/psi/PsiFile;", "createFormattingTask", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "request", "Lcom/intellij/formatting/service/AsyncFormattingRequest;", "getNotificationGroupId", "", "getName", "needToUpdate", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRustfmtFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RustfmtFormattingService.kt\norg/rust/ide/formatter/RustfmtFormattingService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,273:1\n30#2,2:274\n*S KotlinDebug\n*F\n+ 1 RustfmtFormattingService.kt\norg/rust/ide/formatter/RustfmtFormattingService\n*L\n67#1:274,2\n*E\n"})
public final class RustfmtFormattingService
extends AsyncDocumentFormattingService {
    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        return SetsKt.emptySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canFormat(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof RsFile)) return false;
        Project project = ((RsFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!RustfmtProjectSettingsServiceKt.getRustfmtSettings(project).getUseRustfmt()) return false;
        if (!RustfmtFormattingServiceKt.access$isSuitableCommand()) return false;
        return true;
    }

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(@NotNull AsyncFormattingRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        FormattingContext formattingContext = request.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)formattingContext, (String)"getContext(...)");
        FormattingContext context = formattingContext;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = context.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        CargoProject cargoProject = CargoProjectServiceKt.getCargoProjects(project2).findProjectForFile(virtualFile2);
        if (cargoProject == null) {
            return null;
        }
        CargoProject cargoProject2 = cargoProject;
        Object object = RustProjectSettingsServiceKt.getToolchain(project2);
        if (object == null || (object = RustfmtKt.rustfmt((RsToolchainBase)object)) == null) {
            return null;
        }
        Object rustfmt = object;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ActionHolder> serviceClass$iv = ActionHolder.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        boolean formattingInAction = ((ActionHolder)object2).getFormattingInAction();
        CountDownLatch formatterLatch = new CountDownLatch(1);
        RustfmtFormattingServiceKt.setFormatterLatch(file, formatterLatch);
        return new AsyncDocumentFormattingService.FormattingTask(request, formatterLatch, project2, cargoProject2, context, file, (Rustfmt)rustfmt, virtualFile2, formattingInAction){
            private ProgressIndicator indicator;
            final /* synthetic */ AsyncFormattingRequest $request;
            final /* synthetic */ CountDownLatch $formatterLatch;
            final /* synthetic */ Project $project;
            final /* synthetic */ CargoProject $cargoProject;
            final /* synthetic */ FormattingContext $context;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Rustfmt $rustfmt;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ boolean $formattingInAction;
            {
                this.$request = $request;
                this.$formatterLatch = $formatterLatch;
                this.$project = $project;
                this.$cargoProject = $cargoProject;
                this.$context = $context;
                this.$file = $file;
                this.$rustfmt = $rustfmt;
                this.$virtualFile = $virtualFile;
                this.$formattingInAction = $formattingInAction;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean runWithBuiltIn = Registry.Companion.is("org.rust.ide.formatter.run.builtin.before.rustfmt");
                try {
                    this.indicator = ProgressManager.getGlobalProgressIndicator();
                    if (this.indicator == null && UtilsKt.isHeadlessEnvironment()) {
                        ProgressManager.getInstance().runProcess(() -> createFormattingTask.1.run$lambda$0(this, runWithBuiltIn), (ProgressIndicator)new EmptyProgressIndicator());
                    } else {
                        this.doRun(runWithBuiltIn);
                    }
                }
                finally {
                    this.$request.onTextReady(null);
                    this.$formatterLatch.countDown();
                }
            }

            private final void doRun(boolean runWithBuiltIn) {
                switch (createFormattingTask.WhenMappings.$EnumSwitchMapping$0[Rustup.Companion.checkRustfmtAvailability(this.$project, this.$cargoProject.getRootDirPath()).ordinal()]) {
                    case 1: {
                        this.runWithRustfmt(runWithBuiltIn);
                        if (RustfmtFormattingServiceKt.access$getRustfmtEnabledByDefaultNotified()) break;
                        this.notifyRustfmtEnabledByDefault(this.$project);
                        RustfmtFormattingServiceKt.access$setRustfmtEnabledByDefaultNotified(true);
                        break;
                    }
                    case 2: {
                        this.runWithoutRustfmt();
                        this.notifyInstallRustfmtWithRustup(this.$project);
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.runWithoutRustfmt();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            private final void runWithoutRustfmt() {
                Object v0;
                block1: {
                    Iterable iterable = AsyncDocumentFormattingService.EP_NAME.getExtensionList();
                    for (T t : iterable) {
                        FormattingService it2 = (FormattingService)t;
                        boolean bl = false;
                        if (!(it2 instanceof CoreFormattingService)) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                FormattingService coreFormattingService = v0;
                PsiFile[] psiFileArray = new PsiFile[]{this.$context.getContainingFile()};
                WriteCommandAction.writeCommandAction((Project)this.$project, (PsiFile[])psiFileArray).withName(CodeStyleBundle.message((String)"process.reformat.code", (Object[])new Object[0])).shouldRecordActionForActiveDocument(false).run(() -> createFormattingTask.1.runWithoutRustfmt$lambda$2(coreFormattingService, this.$file, this.$request));
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            private final void runWithRustfmt(boolean runWithBuiltIn) {
                block9: {
                    RustfmtTestmarks.RustfmtUsed.INSTANCE.hit();
                    var2_2 = (Triple)ActionsKt.runReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, runWithRustfmt$lambda$3(com.intellij.openapi.vfs.VirtualFile ), ()Lkotlin/Triple;)((VirtualFile)this.$virtualFile));
                    document = (Document)var2_2.component1();
                    text = (String)var2_2.component2();
                    initialModificationStamp = (Long)var2_2.component3();
                    if (document == null || text == null || initialModificationStamp == null) {
                        return;
                    }
                    var7_6 = this.$rustfmt.createCommandLine(this.$cargoProject, this.$virtualFile);
                    if (var7_6 == null) ** GOTO lbl-1000
                    var9_7 = text;
                    v0 = var9_7.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getBytes(...)");
                    var8_8 = CommandLineExtKt.execute$default(var7_6, v0, null, 2, null);
                    if (var8_8 == null) ** GOTO lbl-1000
                    var10_9 = var8_8;
                    var11_10 = this.$formattingInAction;
                    var12_13 = this.$project;
                    var13_14 = this.$virtualFile;
                    $i$f$unwrapOrElse = false;
                    var15_18 = $this$unwrapOrElse$iv;
                    if (var15_18 instanceof RsResult.Ok) {
                        v1 = ((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
                    } else if (var15_18 instanceof RsResult.Err) {
                        e = (RsProcessExecutionException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                        $i$a$-unwrapOrElse-RustfmtFormattingService$createFormattingTask$1$runWithRustfmt$result$1 = false;
                        place = var11_10 != false ? RustfmtUsagesCollector.Place.EXPLICIT : RustfmtUsagesCollector.Place.IMPLICIT;
                        Rustfmt.Companion.reportRustfmtError(e, var12_13, var13_14, place);
                        if (UtilsKt.isUnitTestMode()) {
                            throw e;
                        }
                        v1 = null;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    var9_7 = (ProcessOutput)v1;
                    if (var9_7 == null) ** GOTO lbl-1000
                    var11_11 = var9_7;
                    it /* !! */  = var11_11;
                    $i$a$-takeIf-RustfmtFormattingService$createFormattingTask$1$runWithRustfmt$result$2 = false;
                    v2 = var10_9 = CommandLineExtKt.isSuccess((ProcessOutput)it /* !! */ ) != false ? var11_11 : null;
                    if (var10_9 != null) {
                        v3 = var10_9.getStdout();
                    } else lbl-1000:
                    // 4 sources

                    {
                        v3 = null;
                    }
                    result = StringKt.nullize$default(v3, (boolean)false, (int)1, null);
                    var9_7 = FormattingService.EP_NAME.getExtensionList();
                    var10_9 = var9_7.iterator();
                    while (var10_9.hasNext()) {
                        var11_12 = var10_9.next();
                        it /* !! */  = (FormattingService)var11_12;
                        $i$a$-find-RustfmtFormattingService$createFormattingTask$1$runWithRustfmt$coreFormattingService$1 = false;
                        if (!(it /* !! */  instanceof CoreFormattingService)) continue;
                        v4 = var11_12;
                        break block9;
                    }
                    v4 = null;
                }
                coreFormattingService = v4;
                var8_8 = new PsiFile[]{this.$context.getContainingFile()};
                WriteCommandAction.writeCommandAction((Project)this.$project, (PsiFile[])var8_8).withName(CodeStyleBundle.message((String)"process.reformat.code", (Object[])new Object[0])).shouldRecordActionForActiveDocument(false).run((ThrowableRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, runWithRustfmt$lambda$7(com.intellij.openapi.editor.Document java.lang.Long java.lang.String java.lang.String boolean com.intellij.formatting.service.FormattingService com.intellij.psi.PsiFile com.intellij.formatting.service.AsyncFormattingRequest com.intellij.openapi.project.Project ), ()V)((Document)document, (Long)initialModificationStamp, (String)result, (String)text, (boolean)runWithBuiltIn, (FormattingService)coreFormattingService, (PsiFile)this.$file, (AsyncFormattingRequest)this.$request, (Project)this.$project));
            }

            private final void notifyRustfmtEnabledByDefault(Project project) {
                if (RustfmtProjectSettingsServiceKt.getRustfmtSettings(project).getUseRustfmtOld()) {
                    RustfmtFormattingServiceKt.access$setRustfmtEnabledByDefaultNotified(true);
                    return;
                }
                Notification notification = RsNotifications.INSTANCE.createRustfmtNotification("rustfmt.enabled.by.default", (Function1<? super NotificationGroup, ? extends Notification>)((Function1)createFormattingTask.1::notifyRustfmtEnabledByDefault$lambda$8));
                notification.notify(project);
            }

            private final void notifyInstallRustfmtWithRustup(Project project) {
                Notification notification = RsNotifications.INSTANCE.createRustfmtNotification("rustfmt.not.installed", (Function1<? super NotificationGroup, ? extends Notification>)((Function1)arg_0 -> createFormattingTask.1.notifyInstallRustfmtWithRustup$lambda$9(project, this.$cargoProject, arg_0)));
                notification.notify(project);
            }

            public boolean cancel() {
                block0: {
                    ProgressIndicator progressIndicator = this.indicator;
                    if (progressIndicator == null) break block0;
                    progressIndicator.cancel();
                }
                return true;
            }

            public boolean isRunUnderProgress() {
                return true;
            }

            private static final void run$lambda$0(createFormattingTask.1 this$0, boolean $runWithBuiltIn) {
                this$0.doRun($runWithBuiltIn);
            }

            private static final void runWithoutRustfmt$lambda$2(FormattingService $coreFormattingService, PsiFile $file, AsyncFormattingRequest $request) {
                block0: {
                    FormattingService formattingService = $coreFormattingService;
                    if (formattingService == null) break block0;
                    formattingService.formatRanges($file, (FormattingRangesInfo)new FormatTextRanges($file.getTextRange(), true), $request.canChangeWhitespaceOnly(), false);
                }
            }

            private static final Triple runWithRustfmt$lambda$3(VirtualFile $virtualFile) {
                Document document;
                Document document2 = document = UtilsKt.getDocument($virtualFile);
                Document document3 = document;
                return new Triple((Object)document, (Object)(document2 != null ? document2.getText() : null), (Object)(document3 != null ? Long.valueOf(document3.getModificationStamp()) : null));
            }

            private static final void runWithRustfmt$lambda$7(Document $document, Long $initialModificationStamp, String $result, String $text, boolean $runWithBuiltIn, FormattingService $coreFormattingService, PsiFile $file, AsyncFormattingRequest $request, Project $project) {
                Long l = $initialModificationStamp;
                if (l != null && $document.getModificationStamp() == l.longValue() && !Intrinsics.areEqual((Object)$result, (Object)$text)) {
                    if ($runWithBuiltIn) {
                        FormattingService formattingService = $coreFormattingService;
                        if (formattingService != null) {
                            formattingService.formatRanges($file, (FormattingRangesInfo)new FormatTextRanges($file.getTextRange(), true), $request.canChangeWhitespaceOnly(), false);
                        }
                    }
                    if ($result != null) {
                        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)$project);
                        manager.doPostponedOperationsAndUnblockDocument($document);
                        $document.setText((CharSequence)$result);
                        manager.commitDocument($document);
                    }
                }
            }

            private static final Notification notifyRustfmtEnabledByDefault$lambda$8(NotificationGroup group2) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                Notification notification = group2.createNotification(RsBundle.INSTANCE.message("rustfmt.enabled.title", new Object[0]), RsBundle.INSTANCE.message("rustfmt.enabled.message", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)new ConfigureRustfmtAction());
                Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addAction(...)");
                return notification;
            }

            private static final Notification notifyInstallRustfmtWithRustup$lambda$9(Project $project, CargoProject $cargoProject, NotificationGroup group2) {
                String string;
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                if (RustfmtFormattingServiceKt.access$getRustfmtEnabledByDefaultNotified()) {
                    string = RsBundle.INSTANCE.message("rustfmt.is.not.installed.message", new Object[0]);
                } else if (RustfmtProjectSettingsServiceKt.getRustfmtSettings($project).getUseRustfmtOld()) {
                    RustfmtFormattingServiceKt.access$setRustfmtEnabledByDefaultNotified(true);
                    string = RsBundle.INSTANCE.message("rustfmt.is.not.installed.message", new Object[0]);
                } else {
                    RustfmtFormattingServiceKt.access$setRustfmtEnabledByDefaultNotified(true);
                    string = RsBundle.INSTANCE.message("rustfmt.is.not.installed.first.message", new Object[0]);
                }
                String message = string;
                Notification notification = group2.createNotification(RsBundle.INSTANCE.message("rustfmt.is.not.installed", new Object[0]), message, NotificationType.ERROR).addAction((AnAction)new InstallComponentAction($cargoProject.getRootDirPath(), "rustfmt", RsBundle.INSTANCE.message("rustfmt.install", new Object[0]))).addAction((AnAction)new ConfigureRustfmtAction());
                Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addAction(...)");
                return notification;
            }
        };
    }

    @NotNull
    protected String getNotificationGroupId() {
        return "Rust Plugin";
    }

    @NotNull
    protected String getName() {
        return "Rustfmt";
    }

    protected boolean needToUpdate() {
        return false;
    }
}

